/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.time.LocalDate;
import java.time.Month;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.earnings.AbstractChartTab;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class EarningsAccumulatedChartTab
extends AbstractChartTab {
    @Override
    public String getLabel() {
        return Messages.LabelAccumulatedEarnings;
    }

    @Override
    protected void createSeries() {
        LocalDate now = LocalDate.now();
        boolean isJanuary = now.getMonth() == Month.JANUARY;
        int index = 0;
        while (index < this.model.getNoOfMonths()) {
            int year = this.model.getStartYear() + index / 12;
            ILineSeries lineSeries = (ILineSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(year));
            double[] series = new double[Math.min(12, this.model.getNoOfMonths() - index)];
            long value = 0L;
            int ii = 0;
            while (ii < series.length) {
                series[ii] = (double)(value += this.model.getSum().getValue(index + ii)) / Values.Amount.divider();
                ++ii;
            }
            lineSeries.setYSeries(series);
            lineSeries.setLineColor(this.getColor(year));
            lineSeries.setLineWidth(2);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setAntialias(1);
            if (isJanuary && year == now.getYear()) {
                lineSeries.setSymbolSize(1);
                lineSeries.setSymbolType(ILineSeries.PlotSymbolType.SQUARE);
            }
            index += 12;
        }
    }
}

