/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.ui.util.swt.ColoredLabel;
import name.abuchen.portfolio.ui.views.earnings.AbstractChartTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class EarningsPerMonthChartTab
extends AbstractChartTab {
    @Override
    public String getLabel() {
        return Messages.LabelEarningsPerMonth;
    }

    @Override
    protected void attachTooltipTo(Chart chart) {
        DividendPerMonthChartToolTip toolTip = new DividendPerMonthChartToolTip(chart, this.model);
        toolTip.enableCategory(true);
    }

    @Override
    protected void createSeries() {
        int index = 0;
        while (index < this.model.getNoOfMonths()) {
            int year = this.model.getStartYear() + index / 12;
            IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, String.valueOf(year));
            double[] series = new double[Math.min(12, this.model.getNoOfMonths() - index)];
            int ii = 0;
            while (ii < series.length) {
                series[ii] = (double)this.model.getSum().getValue(index + ii) / Values.Amount.divider();
                ++ii;
            }
            barSeries.setYSeries(series);
            barSeries.setBarColor(this.getColor(year));
            barSeries.setBarPadding(25);
            index += 12;
        }
    }

    private class DividendPerMonthChartToolTip
    extends TimelineChartToolTip {
        private EarningsViewModel model;

        public DividendPerMonthChartToolTip(Chart chart, EarningsViewModel model) {
            super(chart);
            this.model = model;
        }

        @Override
        protected void createComposite(Composite parent) {
            int month = (Integer)this.getFocusedObject();
            int totalNoOfMonths = this.model.getNoOfMonths();
            List<EarningsViewModel.Line> lines = this.model.getLines().stream().filter(line -> {
                int index = month;
                while (index < totalNoOfMonths) {
                    if (line.getValue(index) != 0L) {
                        return true;
                    }
                    index += 12;
                }
                return false;
            }).sorted((l1, l2) -> l1.getVehicle().getName().compareToIgnoreCase(l2.getVehicle().getName())).collect(Collectors.toList());
            int noOfYears = totalNoOfMonths / 12 + (totalNoOfMonths % 12 > month ? 1 : 0);
            Composite container = new Composite(parent, 0);
            container.setBackgroundMode(2);
            GridLayoutFactory.swtDefaults().numColumns(1 + noOfYears).applyTo(container);
            Label topLeft = new Label(container, 0);
            topLeft.setText(Messages.ColumnSecurity);
            int year = 0;
            while (year < noOfYears) {
                ColoredLabel label = new ColoredLabel(container, 0x1000000);
                label.setBackdropColor(((IBarSeries)this.getChart().getSeriesSet().getSeries()[year]).getBarColor());
                label.setText(String.valueOf(this.model.getStartYear() + year));
                GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)label);
                ++year;
            }
            lines.forEach(line -> {
                Label l = new Label(container, 0);
                l.setText(TextUtil.tooltip((String)line.getVehicle().getName()));
                int m = month;
                while (m < totalNoOfMonths) {
                    l = new Label(container, 131072);
                    l.setText(Values.Amount.format((Object)line.getValue(m)));
                    GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)l);
                    m += 12;
                }
            });
            Label l = new Label(container, 0);
            l.setText(Messages.ColumnSum);
            int m = month;
            while (m < totalNoOfMonths) {
                ColoredLabel cl = new ColoredLabel(container, 131072);
                cl.setBackdropColor(((IBarSeries)this.getChart().getSeriesSet().getSeries()[m / 12]).getBarColor());
                cl.setText(Values.Amount.format((Object)this.model.getSum().getValue(m)));
                GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)cl);
                m += 12;
            }
        }
    }
}

