/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.preference.IPreferenceStore;

public class EarningsViewModel {
    private List<UpdateListener> listeners = new ArrayList<UpdateListener>();
    private CurrencyConverter converter;
    private final Client client;
    private final ClientFilterMenu clientFilter;
    private int startYear;
    private int noOfmonths;
    private List<Line> lines;
    private Line sum;
    private List<TransactionPair<?>> transactions = new ArrayList();
    private Mode mode = Mode.ALL;
    private boolean useGrossValue = true;

    public EarningsViewModel(IPreferenceStore preferences, CurrencyConverter converter, Client client) {
        this.converter = converter;
        this.client = client;
        this.clientFilter = new ClientFilterMenu(client, preferences, filter -> this.recalculate());
        String selection = preferences.getString(String.valueOf(EarningsViewModel.class.getSimpleName()) + "-client-filter");
        if (selection != null) {
            this.clientFilter.getAllItems().filter(item -> item.getUUIDs().equals(selection)).findAny().ifPresent(this.clientFilter::select);
        }
        this.clientFilter.addListener(filter -> preferences.putValue(String.valueOf(EarningsViewModel.class.getSimpleName()) + "-client-filter", this.clientFilter.getSelectedItem().getUUIDs()));
    }

    public void configure(int startYear, Mode mode, boolean useGrossValue) {
        this.startYear = startYear;
        this.mode = mode;
        this.useGrossValue = useGrossValue;
        this.recalculate();
    }

    Client getClient() {
        return this.client;
    }

    public ClientFilterMenu getClientFilterMenu() {
        return this.clientFilter;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getNoOfMonths() {
        return this.noOfmonths;
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public Line getSum() {
        return this.sum;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.recalculate();
    }

    public boolean usesGrossValue() {
        return this.useGrossValue;
    }

    public void setUseGrossValue(boolean useGrossValue) {
        this.useGrossValue = useGrossValue;
        this.recalculate();
    }

    public List<Line> getAllLines() {
        ArrayList<Line> answer = new ArrayList<Line>();
        answer.addAll(this.lines);
        answer.add(this.sum);
        return answer;
    }

    public List<TransactionPair<?>> getTransactions() {
        return this.transactions;
    }

    public void updateWith(int year) {
        this.startYear = year;
        this.recalculate();
    }

    public void recalculate() {
        this.converter = this.converter.with(this.client.getBaseCurrency());
        this.calculate();
        this.fireUpdateChange();
    }

    private void calculate() {
        int index;
        long value;
        LocalDate now = LocalDate.now();
        if (this.startYear > now.getYear()) {
            throw new IllegalArgumentException();
        }
        this.noOfmonths = (now.getYear() - this.startYear) * 12 + now.getMonthValue();
        Interval interval = Interval.of((LocalDate)LocalDate.of(this.startYear - 1, Month.DECEMBER, 31), (LocalDate)now);
        Predicate<Transaction> checkIsInInterval = t -> interval.contains(t.getDateTime());
        HashMap<InvestmentVehicle, Line> vehicle2line = new HashMap<InvestmentVehicle, Line>();
        this.sum = new Line(null, this.noOfmonths);
        this.transactions = new ArrayList();
        Client filteredClient = this.clientFilter.getSelectedFilter().filter(this.client);
        EnumSet<Mode> processPorfolioTx = EnumSet.of(Mode.TAXES, Mode.FEES, Mode.ALL);
        if (processPorfolioTx.contains((Object)this.mode)) {
            for (Portfolio portfolio : filteredClient.getPortfolios()) {
                for (PortfolioTransaction t2 : portfolio.getTransactions()) {
                    if (!checkIsInInterval.test((Transaction)t2)) continue;
                    value = 0L;
                    switch (this.mode) {
                        case TAXES: {
                            value -= t2.getUnitSum(Transaction.Unit.Type.TAX).with(this.converter.at(t2.getDateTime())).getAmount();
                            break;
                        }
                        case FEES: {
                            value -= t2.getUnitSum(Transaction.Unit.Type.FEE).with(this.converter.at(t2.getDateTime())).getAmount();
                            break;
                        }
                        case ALL: {
                            value -= t2.getUnitSum(Transaction.Unit.Type.TAX).with(this.converter.at(t2.getDateTime())).getAmount();
                            value -= t2.getUnitSum(Transaction.Unit.Type.FEE).with(this.converter.at(t2.getDateTime())).getAmount();
                        }
                    }
                    if (value == 0L) continue;
                    this.transactions.add(new TransactionPair((TransactionOwner)portfolio, (Transaction)t2));
                    index = (t2.getDateTime().getYear() - this.startYear) * 12 + t2.getDateTime().getMonthValue() - 1;
                    Line line = vehicle2line.computeIfAbsent((InvestmentVehicle)t2.getSecurity(), s -> new Line((InvestmentVehicle)s, this.noOfmonths));
                    int n = index;
                    line.values[n] = line.values[n] + value;
                    line.sum += value;
                    int n2 = index;
                    this.sum.values[n2] = this.sum.values[n2] + value;
                    this.sum.sum += value;
                }
            }
        }
        for (Account account : filteredClient.getAccounts()) {
            for (PortfolioTransaction t2 : account.getTransactions()) {
                if (!this.mode.isAccountTxIncluded((AccountTransaction)t2) || !checkIsInInterval.test((Transaction)t2)) continue;
                value = 0L;
                switch (this.mode) {
                    case TAXES: {
                        if (t2.getType() == AccountTransaction.Type.TAXES || t2.getType() == AccountTransaction.Type.TAX_REFUND) {
                            value = t2.getMonetaryAmount().with(this.converter.at(t2.getDateTime())).getAmount();
                            if (!t2.getType().isDebit()) break;
                            value *= -1L;
                            break;
                        }
                        value -= t2.getUnitSum(Transaction.Unit.Type.TAX).with(this.converter.at(t2.getDateTime())).getAmount();
                        break;
                    }
                    case FEES: {
                        if (t2.getType() == AccountTransaction.Type.FEES || t2.getType() == AccountTransaction.Type.FEES_REFUND) {
                            value = t2.getMonetaryAmount().with(this.converter.at(t2.getDateTime())).getAmount();
                            if (!t2.getType().isDebit()) break;
                            value *= -1L;
                            break;
                        }
                        value -= t2.getUnitSum(Transaction.Unit.Type.FEE).with(this.converter.at(t2.getDateTime())).getAmount();
                        break;
                    }
                    case ALL: {
                        value = t2.getMonetaryAmount().with(this.converter.at(t2.getDateTime())).getAmount();
                        if (!t2.getType().isDebit()) break;
                        value *= -1L;
                        break;
                    }
                    default: {
                        value = (this.useGrossValue ? t2.getGrossValue() : t2.getMonetaryAmount()).with(this.converter.at(t2.getDateTime())).getAmount();
                        if (!t2.getType().isDebit()) break;
                        value *= -1L;
                    }
                }
                if (value == 0L) continue;
                this.transactions.add(new TransactionPair((TransactionOwner)account, (Transaction)t2));
                index = (t2.getDateTime().getYear() - this.startYear) * 12 + t2.getDateTime().getMonthValue() - 1;
                Account vehicle = t2.getSecurity() != null ? t2.getSecurity() : account;
                Line line = vehicle2line.computeIfAbsent((InvestmentVehicle)vehicle, s -> new Line((InvestmentVehicle)s, this.noOfmonths));
                int n = index;
                line.values[n] = line.values[n] + value;
                line.sum += value;
                int n3 = index;
                this.sum.values[n3] = this.sum.values[n3] + value;
                this.sum.sum += value;
            }
        }
        this.lines = new ArrayList(vehicle2line.values());
    }

    public void addUpdateListener(UpdateListener listener) {
        this.listeners.add(listener);
    }

    protected void fireUpdateChange() {
        this.listeners.stream().forEach(UpdateListener::onUpdate);
    }

    public static class Line {
        private InvestmentVehicle vehicle;
        private long[] values;
        private long sum;

        public Line(InvestmentVehicle vehicle, int length) {
            this.vehicle = vehicle;
            this.values = new long[length];
        }

        public InvestmentVehicle getVehicle() {
            return this.vehicle;
        }

        public long getValue(int index) {
            return this.values[index];
        }

        public long getSum() {
            return this.sum;
        }

        public int getNoOfMonths() {
            return this.values.length;
        }
    }

    public static enum Mode {
        DIVIDENDS(Messages.LabelDividends, AccountTransaction.Type.DIVIDENDS, new AccountTransaction.Type[0]),
        INTEREST(Messages.LabelInterest, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE),
        EARNINGS(Messages.LabelEarnings, AccountTransaction.Type.DIVIDENDS, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE),
        TAXES(Messages.ColumnTaxes, AccountTransaction.Type.DIVIDENDS, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE, AccountTransaction.Type.TAXES, AccountTransaction.Type.TAX_REFUND),
        FEES(Messages.ColumnFees, AccountTransaction.Type.DIVIDENDS, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE, AccountTransaction.Type.FEES, AccountTransaction.Type.FEES_REFUND),
        ALL("\u2211", AccountTransaction.Type.DIVIDENDS, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE, AccountTransaction.Type.TAXES, AccountTransaction.Type.TAX_REFUND, AccountTransaction.Type.FEES, AccountTransaction.Type.FEES_REFUND);

        private String label;
        private Set<AccountTransaction.Type> types;

        private Mode(String label, AccountTransaction.Type first, AccountTransaction.Type ... rest) {
            this.label = label;
            this.types = EnumSet.of(first, rest);
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isAccountTxIncluded(AccountTransaction transaction) {
            return this.types.contains(transaction.getType());
        }
    }

    @FunctionalInterface
    public static interface UpdateListener {
        public void onUpdate();
    }
}

