/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import com.google.common.base.Strings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dnd.SecurityTransfer;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TreeViewerCSVExporter;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ValueEditingSupport;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.IsinColumn;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.ui.views.taxonomy.Page;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeTransfer;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

abstract class AbstractNodeTreeViewer
extends Page
implements ColumnEditingSupport.ModificationListener {
    protected static final String MENU_GROUP_DEFAULT_ACTIONS = "defaultActions";
    protected static final String MENU_GROUP_CUSTOM_ACTIONS = "customActions";
    protected static final String MENU_GROUP_DELETE_ACTIONS = "deleteActions";
    @Inject
    private SelectionService selectionService;
    @Inject
    private PortfolioPart part;
    private boolean useIndirectQuotation = false;
    private final AbstractFinanceView view;
    private TreeViewer nodeViewer;
    private ShowHideColumnHelper support;
    private boolean isFirstView = true;

    public AbstractNodeTreeViewer(AbstractFinanceView view, TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(model, renderer);
        this.view = view;
    }

    @Inject
    private void setUseIndirectQuotation(@Preference(value="USE_INDIRECT_QUOTATION") boolean useIndirectQuotation) {
        this.useIndirectQuotation = useIndirectQuotation;
        if (this.nodeViewer != null) {
            this.nodeViewer.refresh();
        }
    }

    protected abstract String readExpansionState();

    protected abstract void storeExpansionState(String var1);

    protected final TreeViewer getNodeViewer() {
        return this.nodeViewer;
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        this.onTaxnomyNodeEdited((TaxonomyNode)element);
    }

    public void onWeightModified(Object element, Object newValue, Object oldValue) {
        TaxonomyNode node = (TaxonomyNode)element;
        if (node.getWeight() > Classification.ONE_HUNDRED_PERCENT) {
            node.setWeight(Classification.ONE_HUNDRED_PERCENT);
        } else if (node.getWeight() < 0) {
            node.setWeight(0);
        }
        if (node.isAssignment()) {
            int oldWeight = (Integer)oldValue;
            this.doChangeAssignmentWeight(node, oldWeight);
        }
        this.onModified(element, newValue, oldValue);
    }

    @Override
    public void configMenuAboutToShow(IMenuManager manager) {
        this.support.menuAboutToShow(manager);
    }

    @Override
    public void exportMenuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new SimpleAction(Messages.MenuExportData, action -> new TreeViewerCSVExporter(this.nodeViewer).export(String.valueOf(this.getModel().getTaxonomy().getName()) + ".csv")));
    }

    @Override
    public final Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        container.setLayout((Layout)layout);
        this.nodeViewer = new TreeViewer(container, 65538);
        ColumnEditingSupport.prepare((ColumnViewer)this.nodeViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.nodeViewer, (int)2);
        this.support = new ShowHideColumnHelper(String.valueOf(this.getClass().getSimpleName()) + '-' + this.getModel().getTaxonomy().getId(), this.getPreferenceStore(), this.nodeViewer, layout);
        this.addColumns(this.support);
        this.support.createColumns();
        this.nodeViewer.getTree().setHeaderVisible(true);
        this.nodeViewer.getTree().setLinesVisible(true);
        this.nodeViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        this.nodeViewer.addDragSupport(3, new Transfer[]{TaxonomyNodeTransfer.getTransfer(), SecurityTransfer.getTransfer()}, (DragSourceListener)new NodeDragListener(this.nodeViewer));
        this.nodeViewer.addDropSupport(3, new Transfer[]{TaxonomyNodeTransfer.getTransfer()}, (DropTargetListener)new NodeDropListener(this));
        this.nodeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                for (Predicate<TaxonomyNode> predicate : AbstractNodeTreeViewer.this.getModel().getNodeFilters()) {
                    if (predicate.test(node)) continue;
                    return false;
                }
                return true;
            }
        });
        this.nodeViewer.addSelectionChangedListener(event -> {
            TaxonomyNode node = (TaxonomyNode)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (node != null && node.getBackingSecurity() != null) {
                this.selectionService.setSelection(new SecuritySelection(this.getModel().getClient(), node.getBackingSecurity()));
            }
        });
        this.nodeViewer.setInput((Object)this.getModel());
        new ContextMenu(this.nodeViewer.getControl(), this::fillContextMenu).hook();
        return container;
    }

    protected abstract void addColumns(ShowHideColumnHelper var1);

    protected void addDimensionColumn(ShowHideColumnHelper support) {
        Column column = new NameColumn("txname", Messages.ColumnLevels, 0, 400, this.part.getClient());
        column.setLabelProvider((CellLabelProvider)new NameColumn.NameColumnLabelProvider(this.part.getClient()){

            @Override
            public Image getImage(Object e) {
                if (((TaxonomyNode)e).isUnassignedCategory()) {
                    return Images.UNASSIGNED_CATEGORY.image();
                }
                return super.getImage(e);
            }

            @Override
            public String getToolTipText(Object e) {
                TaxonomyNode node = (TaxonomyNode)e;
                if (!node.isClassification()) {
                    return super.getToolTipText(e);
                }
                String note = node.getClassification().getNote();
                return Strings.isNullOrEmpty((String)note) ? super.getToolTipText(e) : TextUtil.wordwrap((String)(String.valueOf(node.getName()) + "\n\n" + note));
            }
        });
        new StringEditingSupport(Named.class, "name"){

            @Override
            public boolean canEdit(Object element) {
                if (((TaxonomyNode)element).isUnassignedCategory()) {
                    return false;
                }
                return super.canEdit(element);
            }
        }.setMandatory(true).addListener(this).attachTo(column);
        column.setRemovable(false);
        column.setSorter(null);
        support.addColumn(column);
        column = new IsinColumn();
        column.getEditingSupport().addListener(this);
        column.setSorter(null);
        column.setVisible(false);
        support.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(this);
        column.setSorter(null);
        column.setVisible(false);
        support.addColumn(column);
        this.addWeightColumn(support);
    }

    private void addWeightColumn(ShowHideColumnHelper support) {
        Column column = new Column("weight", Messages.ColumnWeight, 131072, 70);
        column.setDescription(Messages.ColumnWeight_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isAssignment() ? Values.Weight.format((Object)node.getWeight()) : null;
            }

            public Color getForeground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isAssignment() && AbstractNodeTreeViewer.this.getModel().hasWeightError(node) ? Colors.BLACK : null;
            }

            public Color getBackground(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isAssignment() && AbstractNodeTreeViewer.this.getModel().hasWeightError(node) ? Colors.theme().warningBackground() : null;
            }

            public Image getImage(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return node.isAssignment() && AbstractNodeTreeViewer.this.getModel().hasWeightError(node) ? Images.QUICKFIX.image() : null;
            }
        });
        new ValueEditingSupport(TaxonomyNode.class, "weight", Values.Weight){

            @Override
            public boolean canEdit(Object element) {
                if (((TaxonomyNode)element).isUnassignedCategory()) {
                    return false;
                }
                if (((TaxonomyNode)element).isClassification()) {
                    return false;
                }
                return super.canEdit(element);
            }
        }.addListener(this::onWeightModified).attachTo(column);
        support.addColumn(column);
    }

    protected void addActualColumns(ShowHideColumnHelper support) {
        Column column = new Column("act%", Messages.ColumnActualPercent, 131072, 60);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                long base;
                TaxonomyNode node = (TaxonomyNode)element;
                long actual = node.getActual().getAmount();
                long l = base = node.getParent() == null ? node.getActual().getAmount() : node.getParent().getActual().getAmount();
                if (base == 0L) {
                    return Values.Percent.format((Object)0.0);
                }
                return Values.Percent.format((Object)((double)actual / (double)base));
            }
        });
        support.addColumn(column);
        column = new Column("amGV%", Messages.ColumnPctOfTotal, 131072, 60);
        column.setMenuLabel(Messages.ColumnPctOfTotal_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                long actual = node.getActual().getAmount();
                long total = node.getRoot().getActual().getAmount();
                if (total == 0L) {
                    return Values.Percent.format((Object)0.0);
                }
                return Values.Percent.format((Object)((double)actual / (double)total));
            }
        });
        support.addColumn(column);
        column = new Column("act", Messages.ColumnActualValue, 131072, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                return Values.Money.format(node.getActual(), AbstractNodeTreeViewer.this.getModel().getCurrencyCode());
            }
        });
        support.addColumn(column);
    }

    protected void addAdditionalColumns(ShowHideColumnHelper support) {
        Column column = new Column("exchangeRate", Messages.ColumnExchangeRate, 131072, 80);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (!node.isAssignment()) {
                    return null;
                }
                String baseCurrency = node.getAssignment().getInvestmentVehicle().getCurrencyCode();
                if (baseCurrency == null) {
                    return null;
                }
                CurrencyConverter converter = AbstractNodeTreeViewer.this.getModel().getCurrencyConverter();
                ExchangeRate rate = converter.getRate(LocalDate.now(), baseCurrency);
                if (AbstractNodeTreeViewer.this.useIndirectQuotation) {
                    rate = rate.inverse();
                }
                return Values.ExchangeRate.format((Object)rate.getValue());
            }

            public String getToolTipText(Object e) {
                String text = this.getText(e);
                if (text == null) {
                    return null;
                }
                String term = AbstractNodeTreeViewer.this.getModel().getCurrencyConverter().getTermCurrency();
                String base = ((TaxonomyNode)e).getAssignment().getInvestmentVehicle().getCurrencyCode();
                return String.valueOf(text) + ' ' + (AbstractNodeTreeViewer.this.useIndirectQuotation ? String.valueOf(base) + '/' + term : String.valueOf(term) + '/' + base);
            }
        });
        column.setVisible(false);
        support.addColumn(column);
        column = new Column("actBaseCurrency", String.valueOf(Messages.ColumnActualValue) + Messages.BaseCurrencyCue, 131072, 100);
        column.setDescription(Messages.ColumnActualValueBaseCurrency);
        column.setGroupLabel(Messages.ColumnForeignCurrencies);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxonomyNode node = (TaxonomyNode)element;
                if (node.isClassification() || AbstractNodeTreeViewer.this.getModel().getCurrencyCode().equals(node.getAssignment().getInvestmentVehicle().getCurrencyCode())) {
                    return Values.Money.format(node.getActual(), AbstractNodeTreeViewer.this.getModel().getCurrencyCode());
                }
                if (node.getAssignment().getInvestmentVehicle().getCurrencyCode() != null) {
                    return Values.Money.format(AbstractNodeTreeViewer.this.getModel().getCurrencyConverter().with(node.getAssignment().getInvestmentVehicle().getCurrencyCode()).convert(LocalDate.now(), node.getActual()), AbstractNodeTreeViewer.this.getModel().getCurrencyCode());
                }
                return null;
            }
        });
        column.setVisible(false);
        support.addColumn(column);
        this.getModel().getAttachedModels().forEach(m -> m.addColumns(support));
        AttributeColumn.createFor(this.getModel().getClient(), Security.class).forEach(c -> {
            c.setSorter(null);
            c.getEditingSupport().addListener(this);
            support.addColumn((Column)c);
        });
    }

    private void expandNodes() {
        ArrayList<TaxonomyNode> expanded = new ArrayList<TaxonomyNode>();
        String expansion = this.readExpansionState();
        if (expansion != null && !expansion.isEmpty()) {
            HashSet<String> uuid = new HashSet<String>(Arrays.asList(expansion.split(",")));
            this.getModel().visitAll(node -> {
                if (node.isClassification() && uuid.contains(node.getClassification().getId())) {
                    expanded.add(node);
                }
            });
        } else {
            LinkedList<TaxonomyNode> stack = new LinkedList<TaxonomyNode>();
            stack.push(this.getModel().getVirtualRootNode());
            while (!stack.isEmpty()) {
                TaxonomyNode node2 = (TaxonomyNode)stack.pop();
                if (!node2.isClassification() || node2.getClassification().getChildren().isEmpty()) continue;
                expanded.add(node2);
                stack.addAll(node2.getChildren());
            }
        }
        this.nodeViewer.getTree().setRedraw(false);
        try {
            this.nodeViewer.setExpandedElements(expanded.toArray());
        }
        finally {
            this.nodeViewer.getTree().setRedraw(true);
        }
    }

    protected void onTaxnomyNodeEdited(TaxonomyNode node) {
        this.getModel().recalculate();
        this.getModel().fireTaxonomyModelChange(node);
        this.getModel().markDirty();
    }

    @Override
    public void nodeChange(TaxonomyNode node) {
        if (!this.nodeViewer.getTree().isDisposed()) {
            this.nodeViewer.refresh();
        }
    }

    @Override
    public void beforePage() {
        if (this.isFirstView) {
            this.expandNodes();
            this.isFirstView = false;
        }
    }

    @Override
    public void afterPage() {
    }

    @Override
    public void dispose() {
        StringJoiner expansionState = new StringJoiner(",");
        Object[] objectArray = this.nodeViewer.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            TaxonomyNode node = (TaxonomyNode)element;
            if (node.isClassification()) {
                expansionState.add(node.getClassification().getId());
            }
            ++n2;
        }
        this.storeExpansionState(expansionState.toString());
        super.dispose();
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.nodeViewer.getSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        TaxonomyNode node = (TaxonomyNode)selection.getFirstElement();
        if (node.isUnassignedCategory()) {
            return;
        }
        manager.add((IContributionItem)new Separator(MENU_GROUP_CUSTOM_ACTIONS));
        manager.add((IContributionItem)new Separator(MENU_GROUP_DEFAULT_ACTIONS));
        if (node.isClassification()) {
            manager.add((IAction)new SimpleAction(Messages.MenuTaxonomyClassificationCreate, a -> this.doAddClassification(node)));
            TaxonomyNode unassigned = this.getModel().getUnassignedNode();
            if (!unassigned.getChildren().isEmpty()) {
                MenuManager subMenu = new MenuManager(Messages.MenuTaxonomyMakeAssignment);
                this.addAvailableAssignments(subMenu, node);
                manager.add((IContributionItem)subMenu);
            }
            manager.add((IContributionItem)new Separator());
            MenuManager sorting = new MenuManager(Messages.MenuTaxonomySortTreeBy);
            sorting.add((IAction)new SimpleAction(Messages.MenuTaxonomySortByTypName, a -> this.doSort(node, true)));
            sorting.add((IAction)new SimpleAction(Messages.MenuTaxonomySortByName, a -> this.doSort(node, false)));
            manager.add((IContributionItem)sorting);
            if (!node.isRoot()) {
                manager.add((IContributionItem)new Separator(MENU_GROUP_DELETE_ACTIONS));
                manager.add((IAction)new SimpleAction(Messages.MenuTaxonomyClassificationDelete, a -> this.doDeleteClassification(node)));
            }
        } else {
            Security security;
            if (!node.getParent().isUnassignedCategory()) {
                manager.add((IAction)new SimpleAction(Messages.MenuTaxonomyAssignmentRemove, a -> {
                    int oldWeight = node.getWeight();
                    node.setWeight(0);
                    this.doChangeAssignmentWeight(node, oldWeight);
                    this.onTaxnomyNodeEdited(this.getModel().getVirtualRootNode());
                }));
            }
            if ((security = node.getBackingSecurity()) != null) {
                manager.add((IContributionItem)new Separator());
                new SecurityContextMenu(this.view).menuAboutToShow(manager, security);
            }
        }
    }

    private void addAvailableAssignments(MenuManager manager, final TaxonomyNode targetNode) {
        for (final TaxonomyNode assignment : this.getModel().getUnassignedNode().getChildren()) {
            String label = assignment.getName();
            if (assignment.getWeight() < Classification.ONE_HUNDRED_PERCENT) {
                label = String.valueOf(label) + " (" + Values.Weight.format((Object)assignment.getWeight()) + "%)";
            }
            manager.add((IAction)new Action(label){

                public void run() {
                    assignment.moveTo(targetNode);
                    AbstractNodeTreeViewer.this.nodeViewer.setExpandedState((Object)targetNode, true);
                    AbstractNodeTreeViewer.this.onTaxnomyNodeEdited(targetNode);
                }
            });
        }
    }

    private void doAddClassification(TaxonomyNode parent) {
        Classification newClassification = new Classification(null, UUID.randomUUID().toString(), Messages.LabelNewClassification);
        TaxonomyNode newNode = parent.addChild(newClassification);
        this.nodeViewer.setExpandedState((Object)parent, true);
        this.onTaxnomyNodeEdited(parent);
        this.nodeViewer.editElement((Object)newNode, 0);
    }

    private void doDeleteClassification(TaxonomyNode node) {
        if (node.isRoot() || node.isUnassignedCategory()) {
            return;
        }
        node.getParent().removeChild(node);
        node.accept(node1 -> {
            if (node1.isAssignment()) {
                node1.moveTo(this.getModel().getUnassignedNode());
            }
        });
        this.onTaxnomyNodeEdited(this.getModel().getVirtualRootNode());
    }

    private void doChangeAssignmentWeight(TaxonomyNode node, int oldWeight) {
        int change = oldWeight - node.getWeight();
        if (change == 0) {
            return;
        }
        if (node.getWeight() == 0) {
            node.getParent().removeChild(node);
        }
        InvestmentVehicle investmentVehicle = node.getAssignment().getInvestmentVehicle();
        int totalWeight = this.getModel().getWeightByInvestmentVehicle(investmentVehicle) - change;
        this.getModel().setWeightByInvestmentVehicle(investmentVehicle, totalWeight);
        change = Math.min(change, Classification.ONE_HUNDRED_PERCENT - totalWeight);
        if (change == 0) {
            return;
        }
        TaxonomyNode unassigned = this.getModel().getUnassignedNode().getChildByInvestmentVehicle(investmentVehicle);
        if (unassigned != null) {
            int newWeight = unassigned.getWeight() + change;
            if (newWeight <= 0) {
                this.getModel().getUnassignedNode().removeChild(unassigned);
                this.getModel().setWeightByInvestmentVehicle(investmentVehicle, totalWeight - unassigned.getWeight());
            } else {
                unassigned.setWeight(newWeight);
                this.getModel().setWeightByInvestmentVehicle(investmentVehicle, totalWeight + change);
            }
        } else if (change > 0) {
            Classification.Assignment assignment = new Classification.Assignment(investmentVehicle);
            assignment.setWeight(change);
            this.getModel().getUnassignedNode().addChild(assignment);
            this.getModel().setWeightByInvestmentVehicle(investmentVehicle, totalWeight + change);
        }
    }

    private void doSort(TaxonomyNode node, boolean byType) {
        Collections.sort(node.getChildren(), (node1, node2) -> {
            if (node1.isUnassignedCategory()) {
                return 1;
            }
            if (node2.isUnassignedCategory()) {
                return -1;
            }
            if (byType && node1.isClassification() && !node2.isClassification()) {
                return -1;
            }
            if (byType && !node1.isClassification() && node2.isClassification()) {
                return 1;
            }
            return node1.getName().compareToIgnoreCase(node2.getName());
        });
        int rank = 0;
        for (TaxonomyNode child : node.getChildren()) {
            child.setRank(rank++);
        }
        this.getModel().markDirty();
        this.getModel().fireTaxonomyModelChange(node);
    }

    private static class ItemContentProvider
    implements ITreeContentProvider {
        private TaxonomyModel model;

        private ItemContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.model = (TaxonomyModel)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.model.getVirtualRootNode().getChildren().toArray();
        }

        public boolean hasChildren(Object element) {
            return !((TaxonomyNode)element).getChildren().isEmpty();
        }

        public Object[] getChildren(Object parentElement) {
            return ((TaxonomyNode)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((TaxonomyNode)element).getParent();
        }

        public void dispose() {
        }
    }

    private static class NodeDragListener
    extends DragSourceAdapter {
        private TreeViewer treeViewer;

        public NodeDragListener(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public void dragSetData(DragSourceEvent event) {
            Classification.Assignment assignment;
            List nodes = ((TreeSelection)this.treeViewer.getSelection()).toList();
            TaxonomyNodeTransfer.getTransfer().setTaxonomyNodes(nodes);
            Classification.Assignment assignment2 = assignment = nodes.size() == 1 ? ((TaxonomyNode)nodes.get(0)).getAssignment() : null;
            if (assignment != null && assignment.getInvestmentVehicle() instanceof Security) {
                ArrayList<Security> securities = new ArrayList<Security>();
                securities.add((Security)assignment.getInvestmentVehicle());
                SecurityTransfer.getTransfer().setSecurities(securities);
            } else {
                SecurityTransfer.getTransfer().setSecurities(null);
            }
            event.data = nodes;
        }

        public void dragStart(DragSourceEvent event) {
            List nodes = ((TreeSelection)this.treeViewer.getSelection()).toList();
            event.doit = nodes.stream().noneMatch(n -> n.getParent().isRoot());
        }
    }

    private static class NodeDropListener
    extends ViewerDropAdapter {
        private AbstractNodeTreeViewer viewer;

        public NodeDropListener(AbstractNodeTreeViewer viewer) {
            super((Viewer)viewer.getNodeViewer());
            this.viewer = viewer;
        }

        public boolean performDrop(Object data) {
            TaxonomyNode target;
            List<TaxonomyNode> droppedNodes = this.getSubtreeNodes(TaxonomyNodeTransfer.getTransfer().getTaxonomyNodes());
            if (droppedNodes.contains(target = (TaxonomyNode)this.getCurrentTarget())) {
                return false;
            }
            for (TaxonomyNode n2 : target.getPath()) {
                if (!droppedNodes.contains(n2)) continue;
                return false;
            }
            if (target.isRoot() || target.getParent().isRoot()) {
                return false;
            }
            if (target.getPath().stream().anyMatch(TaxonomyNode::isUnassignedCategory) && droppedNodes.stream().anyMatch(TaxonomyNode::isClassification)) {
                return false;
            }
            switch (this.getCurrentLocation()) {
                case 2: {
                    TaxonomyNode t = target;
                    for (TaxonomyNode node : droppedNodes) {
                        node.insertAfter(t);
                        t = node;
                    }
                    this.viewer.onTaxnomyNodeEdited(this.viewer.getModel().getVirtualRootNode());
                    break;
                }
                case 1: {
                    for (TaxonomyNode node : droppedNodes) {
                        node.insertBefore(target);
                    }
                    this.viewer.onTaxnomyNodeEdited(this.viewer.getModel().getVirtualRootNode());
                    break;
                }
                case 3: {
                    if (target.getPath().stream().anyMatch(droppedNodes::contains)) {
                        return false;
                    }
                    droppedNodes.stream().filter(n -> !n.getParent().equals(target)).forEach(n -> n.moveTo(target));
                    this.viewer.onTaxnomyNodeEdited(this.viewer.getModel().getVirtualRootNode());
                    break;
                }
            }
            return true;
        }

        private List<TaxonomyNode> getSubtreeNodes(List<TaxonomyNode> nodes) {
            ArrayList<TaxonomyNode> answer = new ArrayList<TaxonomyNode>();
            for (TaxonomyNode node : nodes) {
                List<TaxonomyNode> path = node.getPath();
                if (!path.subList(0, path.size() - 1).stream().noneMatch(nodes::contains)) continue;
                answer.add(node);
            }
            return answer;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (!(target instanceof TaxonomyNode)) {
                return false;
            }
            TaxonomyNode targetNode = (TaxonomyNode)target;
            int location = this.determineLocation(this.getCurrentEvent());
            if (targetNode.isClassification()) {
                return true;
            }
            if (targetNode.isAssignment()) {
                return location == 2 || location == 1;
            }
            return false;
        }
    }
}

