/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;

public class RecalculateTargetsAttachedModel
implements TaxonomyModel.AttachedModel {
    @Override
    public void recalculate(TaxonomyModel model) {
        TaxonomyNode virtualRootNode = model.getVirtualRootNode();
        TaxonomyNode unassignedNode = model.getUnassignedNode();
        virtualRootNode.setTarget(virtualRootNode.getActual().subtract(unassignedNode.getActual()));
        model.visitAll(node -> {
            if (node.isClassification() && !node.isRoot()) {
                Money parent = node.getParent().getTarget();
                Money target = Money.of((String)parent.getCurrencyCode(), (long)Math.round((double)(parent.getAmount() * (long)node.getWeight()) / (double)Classification.ONE_HUNDRED_PERCENT));
                node.setTarget(target);
            }
        });
    }
}

