/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import java.text.DecimalFormat;
import java.text.Format;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.snapshot.Aggregation;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.chart.StackedTimelineChart;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractChartPage;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.ISeries;
import org.swtchart.Range;

public class StackedChartViewer
extends AbstractChartPage {
    private StackedTimelineChart chart;
    private boolean isVisible = false;
    private boolean isDirty = true;
    private List<LocalDate> dates;

    @Inject
    public StackedChartViewer(PortfolioPart part, TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(model, renderer);
        Interval interval = part.getSelectedPeriod().toInterval(LocalDate.now());
        Aggregation.Period weekly = Aggregation.Period.WEEKLY;
        LocalDate start = interval.getStart();
        LocalDate now = LocalDate.now();
        LocalDate end = interval.getEnd().isAfter(now) ? now : interval.getEnd();
        LocalDate current = weekly.getStartDateFor(start);
        this.dates = new ArrayList<LocalDate>();
        while (current.isBefore(end)) {
            this.dates.add(current);
            current = current.plus(weekly.getPeriod());
        }
        this.dates.add(end);
    }

    @Override
    public Control createControl(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setBackground(Display.getDefault().getSystemColor(1));
        composite.setLayout((Layout)new FillLayout());
        this.chart = new StackedTimelineChart(composite, this.dates);
        this.chart.getTitle().setVisible(false);
        this.chart.getLegend().setPosition(1024);
        this.chart.getLegend().setVisible(true);
        this.chart.getAxisSet().getYAxis(0).getTick().setFormat((Format)new DecimalFormat("#0.0%"));
        return composite;
    }

    @Override
    public void configMenuAboutToShow(IMenuManager manager) {
        super.configMenuAboutToShow(manager);
        SimpleAction action = new SimpleAction(Messages.LabelOrderByTaxonomy, a -> {
            this.getModel().setOrderByTaxonomyInStackChart(!this.getModel().isOrderByTaxonomyInStackChart());
            this.onConfigChanged();
        });
        action.setChecked(this.getModel().isOrderByTaxonomyInStackChart());
        manager.add((IAction)action);
    }

    @Override
    public void nodeChange(TaxonomyNode node) {
        this.onConfigChanged();
    }

    @Override
    public void onConfigChanged() {
        this.isDirty = true;
        if (this.isVisible) {
            this.asyncUpdateChart();
        }
    }

    @Override
    public void beforePage() {
        this.isVisible = true;
        if (this.isDirty) {
            this.asyncUpdateChart();
        }
    }

    @Override
    public void afterPage() {
        this.isVisible = false;
    }

    private void asyncUpdateChart() {
        new Job(Messages.JobLabelUpdateStackedLineChart){

            protected IStatus run(IProgressMonitor monitor) {
                StackedChartViewer.this.updateChart();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void updateChart() {
        HashMap vehicle2builder = new HashMap();
        LinkedHashMap node2series = new LinkedHashMap();
        this.getModel().visitAll(node -> {
            if (node.isClassification()) {
                node2series.put(node, new SeriesBuilder(node, this.dates.size()));
            } else {
                InvestmentVehicle vehicle = node.getAssignment().getInvestmentVehicle();
                VehicleBuilder builder = (VehicleBuilder)vehicle2builder.get(vehicle);
                if (builder == null) {
                    builder = new VehicleBuilder();
                    vehicle2builder.put(vehicle, builder);
                }
                builder.add(node.getWeight(), (SeriesBuilder)node2series.get(node.getParent()));
            }
        });
        long[] totals = new long[this.dates.size()];
        int index = 0;
        for (LocalDate current : this.dates) {
            ClientSnapshot snapshot = ClientSnapshot.create((Client)this.getModel().getFilteredClient(), (CurrencyConverter)this.getModel().getCurrencyConverter(), (LocalDate)current);
            totals[index] = snapshot.getMonetaryAssets().getAmount();
            Map p = snapshot.getPositionsByVehicle();
            for (Map.Entry entry : vehicle2builder.entrySet()) {
                AssetPosition pos = (AssetPosition)p.get(entry.getKey());
                if (pos == null) continue;
                ((VehicleBuilder)entry.getValue()).book(index, pos);
            }
            ++index;
        }
        if (this.getModel().isUnassignedCategoryInChartsExcluded()) {
            SeriesBuilder unassigned = (SeriesBuilder)node2series.get(this.getModel().getUnassignedNode());
            int ii = 0;
            while (ii < totals.length) {
                int n = ii;
                totals[n] = totals[n] - unassigned.values[ii];
                ++ii;
            }
        }
        Stream<SeriesBuilder> seriesStream = node2series.values().stream().filter(SeriesBuilder::hasValues);
        if (this.getModel().isUnassignedCategoryInChartsExcluded()) {
            seriesStream = seriesStream.filter(s -> !s.node.isUnassignedCategory());
        }
        List series = seriesStream.collect(Collectors.toList());
        if (this.getModel().isOrderByTaxonomyInStackChart()) {
            Collections.reverse(series);
        } else {
            Collections.sort(series);
        }
        Display.getDefault().asyncExec(() -> this.rebuildChartSeries(totals, series));
    }

    private void rebuildChartSeries(long[] totals, List<SeriesBuilder> series) {
        if (this.chart.isDisposed()) {
            return;
        }
        try {
            this.chart.suspendUpdate(true);
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            for (SeriesBuilder serie : series) {
                this.chart.addSeries(serie.node.getClassification().getPathName(false), serie.getValues(totals), this.getRenderer().getColorFor(serie.node));
            }
            this.chart.getAxisSet().adjustRange();
            this.chart.getAxisSet().getYAxis(0).setRange(new Range(-0.01, 1.01));
        }
        finally {
            this.chart.suspendUpdate(false);
            this.chart.redraw();
        }
        this.isDirty = false;
    }

    private static class SeriesBuilder
    implements Comparable<SeriesBuilder> {
        private TaxonomyNode node;
        private long[] values;
        private boolean hasValues = false;

        public SeriesBuilder(TaxonomyNode node, int size) {
            this.node = node;
            this.values = new long[size];
        }

        public boolean hasValues() {
            return this.hasValues;
        }

        public void book(int index, long l) {
            if (l < 0L) {
                return;
            }
            this.hasValues = true;
            int n = index;
            this.values[n] = this.values[n] + l;
        }

        public double[] getValues(long[] totals) {
            double[] answer = new double[this.values.length];
            int ii = 0;
            while (ii < answer.length) {
                answer[ii] = totals[ii] == 0L ? 0.0 : (double)this.values[ii] / (double)totals[ii];
                ++ii;
            }
            return answer;
        }

        @Override
        public int compareTo(SeriesBuilder other) {
            long l1 = this.values[this.values.length - 1];
            long l2 = other.values[other.values.length - 1];
            return Long.compare(l1, l2) * -1;
        }
    }

    private static class VehicleBuilder {
        private List<Integer> weights = new ArrayList<Integer>();
        private List<SeriesBuilder> series = new ArrayList<SeriesBuilder>();

        private VehicleBuilder() {
        }

        public void add(int weight, SeriesBuilder series) {
            this.weights.add(weight);
            this.series.add(series);
        }

        public void book(int index, AssetPosition pos) {
            long value = pos.getValuation().getAmount();
            int ii = 0;
            while (ii < this.weights.size()) {
                this.series.get(ii).book(index, value * (long)this.weights.get(ii).intValue() / (long)Classification.ONE_HUNDRED_PERCENT);
                ++ii;
            }
        }
    }
}

