/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.online.TaxonomySource;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractNodeTreeViewer;
import name.abuchen.portfolio.ui.views.taxonomy.DefinitionViewer;
import name.abuchen.portfolio.ui.views.taxonomy.DonutViewer;
import name.abuchen.portfolio.ui.views.taxonomy.Page;
import name.abuchen.portfolio.ui.views.taxonomy.PieChartViewer;
import name.abuchen.portfolio.ui.views.taxonomy.ReBalancingViewer;
import name.abuchen.portfolio.ui.views.taxonomy.StackedChartViewer;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import name.abuchen.portfolio.ui.views.taxonomy.TreeMapViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TaxonomyView
extends AbstractFinanceView
implements PropertyChangeListener {
    private String identifierView;
    private String identifierUnassigned;
    private String identifierExclucdeSecuritiesInPieChart;
    private String identifierOrderByTaxonomy;
    private String expansionStateDefinition;
    private String expansionStateReblancing;
    private TaxonomyModel model;
    private Taxonomy taxonomy;
    private ClientFilter clientFilter;
    private Composite container;
    private List<Action> viewActions = new ArrayList<Action>();

    @Override
    protected String getDefaultTitle() {
        return this.taxonomy.getName();
    }

    @Inject
    public void setup(@Named(value="name.abuchen.portfolio.ui.param.viewparameter") Taxonomy parameter) {
        this.taxonomy = parameter;
        this.identifierView = String.valueOf(TaxonomyView.class.getSimpleName()) + "-VIEW-" + this.taxonomy.getId();
        this.identifierUnassigned = String.valueOf(TaxonomyView.class.getSimpleName()) + "-UNASSIGNED-" + this.taxonomy.getId();
        this.identifierExclucdeSecuritiesInPieChart = String.valueOf(TaxonomyView.class.getSimpleName()) + "-EXCLUDESECURITESPIECHART-" + this.taxonomy.getId();
        this.identifierOrderByTaxonomy = String.valueOf(TaxonomyView.class.getSimpleName()) + "-ORDERBYTAXONOMY-" + this.taxonomy.getId();
        this.expansionStateDefinition = String.valueOf(TaxonomyView.class.getSimpleName()) + "-EXPANSION-DEFINITION-" + this.taxonomy.getId();
        this.expansionStateReblancing = String.valueOf(TaxonomyView.class.getSimpleName()) + "-EXPANSION-REBALANCE-" + this.taxonomy.getId();
        this.model = this.make(TaxonomyModel.class, this.taxonomy);
        IPreferenceStore preferences = this.getPreferenceStore();
        this.model.setExcludeUnassignedCategoryInCharts(preferences.getBoolean(this.identifierUnassigned));
        this.model.setExcludeSecuritiesInPieChart(preferences.getBoolean(this.identifierExclucdeSecuritiesInPieChart));
        this.model.setOrderByTaxonomyInStackChart(preferences.getBoolean(this.identifierOrderByTaxonomy));
        this.model.setExpansionStateDefinition(preferences.getString(this.expansionStateDefinition));
        this.model.setExpansionStateRebalancing(preferences.getString(this.expansionStateReblancing));
        this.taxonomy.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.updateTitle(this.taxonomy.getName());
    }

    @Override
    public void dispose() {
        Control[] children;
        this.taxonomy.removePropertyChangeListener((PropertyChangeListener)this);
        Control[] controlArray = children = this.container.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Page page = (Page)control.getData();
            page.dispose();
            ++n2;
        }
        IPreferenceStore preferences = this.getPreferenceStore();
        preferences.setValue(this.identifierUnassigned, this.model.isUnassignedCategoryInChartsExcluded());
        preferences.setValue(this.identifierExclucdeSecuritiesInPieChart, this.model.isSecuritiesInPieChartExcluded());
        preferences.setValue(this.identifierOrderByTaxonomy, this.model.isOrderByTaxonomyInStackChart());
        preferences.setValue(this.expansionStateDefinition, this.model.getExpansionStateDefinition());
        preferences.setValue(this.expansionStateReblancing, this.model.getExpansionStateRebalancing());
        super.dispose();
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        this.addView(toolBar, Messages.LabelViewTaxonomyDefinition, Images.VIEW_TABLE, 0);
        this.addView(toolBar, Messages.LabelViewReBalancing, Images.VIEW_REBALANCING, 1);
        this.addView(toolBar, Messages.LabelViewPieChart, Images.VIEW_PIECHART, 2);
        this.addView(toolBar, Messages.LabelViewDonutChart, Images.VIEW_DONUT, 3);
        this.addView(toolBar, Messages.LabelViewTreeMap, Images.VIEW_TREEMAP, 4);
        this.addView(toolBar, Messages.LabelViewStackedChart, Images.VIEW_STACKEDCHART, 5);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IContributionItem)new FilterDropDown(this.getPreferenceStore()));
        this.addExportButton(toolBar);
        this.addConfigButton(toolBar);
    }

    private void addExportButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new DropDown(Messages.MenuExportData, Images.EXPORT, 0, manager -> this.getCurrentPage().ifPresent(p -> p.exportMenuAboutToShow(manager))));
    }

    private void addConfigButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new DropDown("Sync", Images.CLOUD, 0, manager -> {
            String source = this.taxonomy.getSource();
            TaxonomySource[] taxonomySourceArray = TaxonomySource.values();
            int n = taxonomySourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaxonomySource ts = taxonomySourceArray[n2];
                SimpleAction action = new SimpleAction(ts.getLabel(), a -> {
                    if (ts.getIdentifier().equals(source)) {
                        this.taxonomy.setSource(null);
                    } else {
                        this.taxonomy.setSource(ts.getIdentifier());
                    }
                    this.model.getClient().touch();
                });
                action.setChecked(ts.getIdentifier().equals(source));
                manager.add((IAction)action);
                ++n2;
            }
        }));
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> this.getCurrentPage().ifPresent(p -> p.configMenuAboutToShow(manager))));
    }

    private Optional<Page> getCurrentPage() {
        StackLayout layout = (StackLayout)this.container.getLayout();
        return layout.topControl != null ? Optional.of((Page)layout.topControl.getData()) : Optional.empty();
    }

    @Override
    public void notifyModelUpdated() {
        Client filteredClient = this.clientFilter.filter(this.getClient());
        this.model.updateClientSnapshot(filteredClient);
    }

    private void addView(ToolBarManager toolBar, String label, Images image, int index) {
        SimpleAction showDefinition = new SimpleAction(label, 2, a -> this.activateView(index));
        showDefinition.setImageDescriptor(image.descriptor());
        showDefinition.setToolTipText(label);
        toolBar.add((IAction)showDefinition);
        this.viewActions.add(showDefinition);
    }

    @Override
    protected Control createBody(Composite parent) {
        Page[] pages;
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        TaxonomyNodeRenderer renderer = new TaxonomyNodeRenderer(resources);
        this.container = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        this.container.setLayout((Layout)layout);
        Page[] pageArray = pages = new Page[]{this.make(DefinitionViewer.class, this, this.model, renderer), this.make(ReBalancingViewer.class, this, this.model, renderer), this.make(PieChartViewer.class, this.model, renderer), this.make(DonutViewer.class, this.model, renderer), this.make(TreeMapViewer.class, this.model, renderer), this.make(StackedChartViewer.class, this.model, renderer)};
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Page page = pageArray[n2];
            Control control = page.createControl(this.container);
            control.setData((Object)page);
            ++n2;
        }
        this.activateView(this.getPart().getPreferenceStore().getInt(this.identifierView));
        this.model.addDirtyListener(this::markDirty);
        return this.container;
    }

    private void activateView(int index) {
        StackLayout layout = (StackLayout)this.container.getLayout();
        Control[] children = this.container.getChildren();
        if (index >= 0 && index < children.length) {
            if (layout.topControl != null) {
                ((Page)layout.topControl.getData()).afterPage();
            }
            ((Page)children[index].getData()).beforePage();
            layout.topControl = children[index];
            this.container.layout();
            int ii = 0;
            while (ii < this.viewActions.size()) {
                this.viewActions.get(ii).setChecked(index == ii);
                ++ii;
            }
            this.getPart().getPreferenceStore().setValue(this.identifierView, index);
        }
    }

    private class FilterDropDown
    extends DropDown
    implements IMenuListener {
        private ClientFilterMenu clientFilterMenu;

        public FilterDropDown(IPreferenceStore preferenceStore) {
            super(Messages.SecurityFilter, Images.FILTER_OFF, 0);
            this.setMenuListener(this);
            this.clientFilterMenu = new ClientFilterMenu(TaxonomyView.this.getClient(), TaxonomyView.this.getPreferenceStore());
            Consumer<ClientFilter> listener = filter -> {
                Client filteredClient = filter.filter(TaxonomyView.this.getClient());
                TaxonomyView.this.model.updateClientSnapshot(filteredClient);
            };
            this.clientFilterMenu.addListener(listener);
            this.clientFilterMenu.addListener(filter -> this.updateIcon());
            this.loadPreselectedFilter(preferenceStore);
            if (this.clientFilterMenu.hasActiveFilter() || !TaxonomyView.this.model.getNodeFilters().isEmpty()) {
                this.setImage(Images.FILTER_ON);
            }
            TaxonomyView.this.clientFilter = this.clientFilterMenu.getSelectedFilter();
            if (this.clientFilterMenu.hasActiveFilter()) {
                listener.accept(this.clientFilterMenu.getSelectedFilter());
            }
        }

        private void loadPreselectedFilter(IPreferenceStore preferenceStore) {
            String prefix = String.valueOf(TaxonomyView.class.getSimpleName()) + "-" + TaxonomyView.this.taxonomy.getId();
            String key = String.valueOf(prefix) + "-client-filter";
            String selection = preferenceStore.getString(key);
            if (selection != null) {
                this.clientFilterMenu.getAllItems().filter(item -> item.getUUIDs().equals(selection)).findAny().ifPresent(this.clientFilterMenu::select);
            }
            this.clientFilterMenu.addListener(filter -> preferenceStore.putValue(key, this.clientFilterMenu.getSelectedItem().getUUIDs()));
            if (preferenceStore.getBoolean(String.valueOf(prefix) + "-filter-non-zero")) {
                TaxonomyView.this.model.getNodeFilters().add(TaxonomyModel.FILTER_NON_ZERO);
            }
            if (preferenceStore.getBoolean(String.valueOf(prefix) + "-filter-not-retired")) {
                TaxonomyView.this.model.getNodeFilters().add(TaxonomyModel.FILTER_NOT_RETIRED);
            }
            this.addDisposeListener(e -> {
                preferenceStore.setValue(String.valueOf(prefix) + "-filter-non-zero", TaxonomyView.this.model.getNodeFilters().contains(TaxonomyModel.FILTER_NON_ZERO));
                preferenceStore.setValue(String.valueOf(prefix) + "-filter-not-retired", TaxonomyView.this.model.getNodeFilters().contains(TaxonomyModel.FILTER_NOT_RETIRED));
            });
        }

        private void updateIcon() {
            boolean hasActiveFilter = this.clientFilterMenu.hasActiveFilter() || !TaxonomyView.this.model.getNodeFilters().isEmpty();
            this.setImage(hasActiveFilter ? Images.FILTER_ON : Images.FILTER_OFF);
        }

        public void menuAboutToShow(IMenuManager manager) {
            TaxonomyView.this.getCurrentPage().filter(p -> p instanceof AbstractNodeTreeViewer).ifPresent(p -> {
                manager.add((IAction)this.buildNodeFilterAction(Messages.FilterValuationNonZero, TaxonomyModel.FILTER_NON_ZERO));
                manager.add((IAction)this.buildNodeFilterAction(Messages.FilterNotRetired, TaxonomyModel.FILTER_NOT_RETIRED));
            });
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new LabelOnly(Messages.MenuChooseClientFilter));
            this.clientFilterMenu.menuAboutToShow(manager);
        }

        private Action buildNodeFilterAction(String label, Predicate<TaxonomyNode> predicate) {
            SimpleAction action = new SimpleAction(label, a -> {
                boolean isActive = TaxonomyView.this.model.getNodeFilters().contains(predicate);
                if (!isActive) {
                    TaxonomyView.this.model.getNodeFilters().add(predicate);
                } else {
                    TaxonomyView.this.model.getNodeFilters().remove(predicate);
                }
                TaxonomyView.this.model.fireTaxonomyModelChange(TaxonomyView.this.model.getVirtualRootNode());
                this.updateIcon();
            });
            action.setChecked(TaxonomyView.this.model.getNodeFilters().contains(predicate));
            return action;
        }
    }
}

