/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.client.AddTaxonomyPage;
import name.abuchen.portfolio.ui.wizards.client.BaseCurrencySelectionPage;
import name.abuchen.portfolio.ui.wizards.client.ImportIndizesPage;
import name.abuchen.portfolio.ui.wizards.client.NewAccountPage;
import name.abuchen.portfolio.ui.wizards.client.NewPortfolioAccountPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class NewClientWizard
extends Wizard {
    private Client client = new Client();
    private BaseCurrencySelectionPage page;

    public Image getDefaultPageImage() {
        return Images.BANNER.image();
    }

    public boolean performFinish() {
        CurrencyUnit currency = this.page.getSelectedCurrency();
        this.client.setBaseCurrency(currency.getCurrencyCode());
        this.client.getAccounts().stream().forEach(a -> a.setCurrencyCode(currency.getCurrencyCode()));
        return true;
    }

    public Client getClient() {
        return this.client;
    }

    public void addPages() {
        this.page = new BaseCurrencySelectionPage(Messages.BaseCurrencySelectionPage_Title, Messages.BaseCurrencySelectionPage_Description, Messages.BaseCurrencySelectionPage_ExplanationIndividualCurrency);
        this.addPage((IWizardPage)this.page);
        this.addPage((IWizardPage)new NewPortfolioAccountPage(this.client));
        this.addPage((IWizardPage)new NewAccountPage(this.client));
        this.addPage((IWizardPage)new ImportIndizesPage(this.client));
        this.addPage((IWizardPage)new AddTaxonomyPage(this.client));
        AbstractWizardPage.attachPageListenerTo(this.getContainer());
    }
}

