/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.datatransfer.SecurityCache;
import name.abuchen.portfolio.datatransfer.actions.InsertAction;
import name.abuchen.portfolio.datatransfer.csv.CSVConfig;
import name.abuchen.portfolio.datatransfer.csv.CSVConfigManager;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.jobs.ConsistencyChecksJob;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.CSVImportDefinitionPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ExtractedEntry;
import name.abuchen.portfolio.ui.wizards.datatransfer.ReviewExtractedItemsPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.SelectSecurityPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class CSVImportWizard
extends Wizard {
    static final String REVIEW_PAGE_ID = "reviewitems";
    private Client client;
    private IPreferenceStore preferences;
    private CSVImporter importer;
    @Inject
    private CSVConfigManager configManager;
    private Security target;
    private Account account;
    private Portfolio portfolio;
    private CSVConfig initialConfig;
    private CSVImportDefinitionPage definitionPage;
    private ReviewExtractedItemsPage reviewPage;
    private SelectSecurityPage selectSecurityPage;

    public CSVImportWizard(Client client, IPreferenceStore preferences, File inputFile) {
        this.client = client;
        this.preferences = preferences;
        this.importer = new CSVImporter(client, inputFile);
        this.setWindowTitle(Messages.CSVImportWizardTitle);
    }

    public void setTarget(Account target) {
        this.account = target;
    }

    public void setTarget(Portfolio target) {
        this.portfolio = target;
    }

    public void setTarget(Security target) {
        this.target = target;
    }

    public void setConfiguration(CSVConfig config) {
        this.initialConfig = config;
    }

    public Image getDefaultPageImage() {
        return Images.BANNER.image();
    }

    public void addPages() {
        this.definitionPage = new CSVImportDefinitionPage(this.client, this.importer, this.configManager, this.target != null);
        if (this.initialConfig != null) {
            this.definitionPage.setInitialConfiguration(this.initialConfig);
        }
        this.addPage((IWizardPage)this.definitionPage);
        this.selectSecurityPage = new SelectSecurityPage(this.client);
        this.addPage((IWizardPage)this.selectSecurityPage);
        this.reviewPage = new ReviewExtractedItemsPage(this.client, new ExtractorProxy(this.importer), this.preferences, Arrays.asList(new Extractor.InputFile(this.importer.getInputFile())), REVIEW_PAGE_ID);
        if (this.account != null) {
            this.reviewPage.setAccount(this.account);
        }
        if (this.portfolio != null) {
            this.reviewPage.setPortfolio(this.portfolio);
        }
        this.reviewPage.setDoExtractBeforeEveryPageDisplay(true);
        this.addPage((IWizardPage)this.reviewPage);
        AbstractWizardPage.attachPageListenerTo(this.getContainer());
    }

    public boolean canFinish() {
        return super.canFinish() && (this.target != null || this.getContainer().getCurrentPage() != this.definitionPage);
    }

    public boolean performFinish() {
        ((AbstractWizardPage)this.getContainer().getCurrentPage()).afterPage();
        boolean isDirty = false;
        isDirty = this.importer.getExtractor() == this.importer.getSecurityPriceExtractor() ? this.importSecurityPrices() : this.importItems();
        if (isDirty) {
            this.client.markDirty();
            new ConsistencyChecksJob(this.client, false).schedule();
        }
        return true;
    }

    private boolean importSecurityPrices() {
        Security security = this.target != null ? this.target : this.selectSecurityPage.getSelectedSecurity();
        List prices = ((Extractor.Item)this.importer.createItems(new ArrayList()).get(0)).getSecurity().getPrices();
        boolean isDirty = false;
        for (SecurityPrice p : prices) {
            if (!security.addPrice(p)) continue;
            isDirty = true;
        }
        return isDirty;
    }

    private boolean importItems() {
        InsertAction action = new InsertAction(this.client);
        action.setConvertBuySellToDelivery(this.reviewPage.doConvertToDelivery());
        action.setRemoveDividends(this.reviewPage.doRemoveDividends());
        boolean isDirty = false;
        for (ExtractedEntry entry : this.reviewPage.getEntries()) {
            if (!entry.isImported()) continue;
            entry.getItem().apply((ImportAction)action, (ImportAction.Context)this.reviewPage);
            isDirty = true;
        }
        return isDirty;
    }

    private static class ExtractorProxy
    implements Extractor {
        private final CSVImporter importer;

        public ExtractorProxy(CSVImporter importer) {
            this.importer = importer;
        }

        public String getLabel() {
            return this.importer.getExtractor().getLabel();
        }

        public List<Extractor.Item> extract(SecurityCache securityCache, Extractor.InputFile file, List<Exception> errors) {
            return this.importer.createItems(errors);
        }

        public List<Extractor.Item> extract(List<Extractor.InputFile> file, List<Exception> errors) {
            return this.importer.createItems(errors);
        }
    }
}

