/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ExportSelectionPage
extends AbstractWizardPage {
    private Client client;
    private TreeViewer treeViewer;

    protected ExportSelectionPage(Client client) {
        super("export");
        this.setTitle(Messages.ExportWizardTitle);
        this.setDescription(Messages.ExportWizardDescription);
        this.client = client;
    }

    public Object getExportItem() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public Class<?> getExportClass() {
        TreeItem parentItem = this.treeViewer.getTree().getSelection()[0].getParentItem();
        return parentItem == null ? null : (Class)parentItem.getData();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FillLayout());
        Composite treeComposite = new Composite(container, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(treeComposite, 2052);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(false);
        tree.setLinesVisible(true);
        TreeColumn column = new TreeColumn(tree, 0);
        column.setText(Messages.ColumnDate);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100));
        this.treeViewer.setContentProvider((IContentProvider)new ExportItemsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ExportItemsLabelProvider(this.client));
        this.treeViewer.setInput((Object)this.client);
        this.treeViewer.setExpandedElements(new Object[]{AccountTransaction.class, PortfolioTransaction.class, Security.class});
        this.setPageComplete(false);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)ExportSelectionPage.this.treeViewer.getSelection()).getFirstElement();
                ExportSelectionPage.this.setPageComplete(element != null);
            }
        });
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Object element = ((IStructuredSelection)ExportSelectionPage.this.treeViewer.getSelection()).getFirstElement();
                ExportSelectionPage.this.setPageComplete(element != null);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (ExportSelectionPage.this.getWizard().performFinish()) {
                    ((WizardDialog)ExportSelectionPage.this.getContainer()).close();
                }
            }
        });
    }

    private static class ExportItemsContentProvider
    implements ITreeContentProvider {
        private Client client;

        private ExportItemsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.client = (Client)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return new Class[]{AccountTransaction.class, PortfolioTransaction.class, Security.class, SecurityPrice.class};
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Class) {
                if (parentElement == AccountTransaction.class) {
                    return this.client.getAccounts().stream().sorted(new Named.ByName()).toArray();
                }
                if (parentElement == PortfolioTransaction.class) {
                    return this.client.getPortfolios().stream().sorted(new Named.ByName()).toArray();
                }
                if (parentElement == Security.class) {
                    return new String[]{Messages.ExportWizardSecurityMasterData, Messages.ExportWizardMergedSecurityPrices, Messages.ExportWizardAllTransactionsAktienfreundeNet, Messages.ExportWizardVINISApp};
                }
                if (parentElement == SecurityPrice.class) {
                    return this.client.getSecurities().stream().sorted(new Security.ByName()).toArray();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Class;
        }

        public void dispose() {
        }
    }

    static class ExportItemsLabelProvider
    extends LabelProvider {
        private Client client;

        public ExportItemsLabelProvider(Client client) {
            this.client = client;
        }

        public String getText(Object element) {
            if (element instanceof Account) {
                return ((Account)element).getName();
            }
            if (element instanceof Portfolio) {
                return ((Portfolio)element).getName();
            }
            if (element instanceof Security) {
                return ((Security)element).getName();
            }
            if (element == AccountTransaction.class) {
                return Messages.ExportWizardAccountTransactions;
            }
            if (element == PortfolioTransaction.class) {
                return Messages.ExportWizardPortfolioTransactions;
            }
            if (element == Security.class) {
                return Messages.ExportWizardSecurities;
            }
            if (element == SecurityPrice.class) {
                return Messages.ExportWizardHistoricalQuotes;
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }

        public Image getImage(Object element) {
            return LogoManager.instance().getDefaultColumnImage(element, this.client.getSettings());
        }
    }
}

