/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.datatransfer.SecurityCache;
import name.abuchen.portfolio.datatransfer.actions.InsertAction;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.jobs.ConsistencyChecksJob;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ErroneousImportFilesPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ExtractedEntry;
import name.abuchen.portfolio.ui.wizards.datatransfer.ReviewExtractedItemsPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public final class ImportExtractedItemsWizard
extends Wizard {
    private Client client;
    private IPreferenceStore preferences;
    private Map<Extractor, List<Extractor.Item>> result;
    private Map<File, List<Exception>> errors;
    private List<ReviewExtractedItemsPage> pages = new ArrayList<ReviewExtractedItemsPage>();
    private Account account;
    private Portfolio portfolio;

    public ImportExtractedItemsWizard(Client client, IPreferenceStore preferences, Map<Extractor, List<Extractor.Item>> result, Map<File, List<Exception>> errors) {
        this.client = client;
        this.preferences = preferences;
        this.result = result;
        this.errors = errors;
        this.setWindowTitle(Messages.PDFImportWizardTitle);
        this.setNeedsProgressMonitor(false);
    }

    public void setTarget(Account target) {
        this.account = target;
    }

    public void setTarget(Portfolio target) {
        this.portfolio = target;
    }

    public boolean canFinish() {
        return !this.pages.isEmpty() && this.getContainer().getCurrentPage() == this.pages.get(this.pages.size() - 1);
    }

    public Image getDefaultPageImage() {
        return Images.BANNER.image();
    }

    public void addPages() {
        if (!this.errors.isEmpty()) {
            this.addPage((IWizardPage)new ErroneousImportFilesPage(this.errors));
        }
        this.result.entrySet().stream().sorted((r, l) -> ((Extractor)r.getKey()).getLabel().compareTo(((Extractor)l.getKey()).getLabel())).map(entry -> new Extractor((Map.Entry)entry){
            private final /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
            }

            public String getLabel() {
                return ((Extractor)this.val$entry.getKey()).getLabel();
            }

            public List<Extractor.Item> extract(SecurityCache securityCache, Extractor.InputFile file, List<Exception> errors) {
                return (List)this.val$entry.getValue();
            }

            public List<Extractor.Item> extract(List<Extractor.InputFile> file, List<Exception> errors) {
                return (List)this.val$entry.getValue();
            }
        }).forEach(extractor -> {
            ReviewExtractedItemsPage page = new ReviewExtractedItemsPage(this.client, (Extractor)extractor, this.preferences, Collections.emptyList());
            if (this.account != null) {
                page.setAccount(this.account);
            }
            if (this.portfolio != null) {
                page.setPortfolio(this.portfolio);
            }
            this.pages.add(page);
            this.addPage((IWizardPage)page);
        });
        AbstractWizardPage.attachPageListenerTo(this.getContainer());
    }

    public boolean performFinish() {
        if (!this.pages.isEmpty()) {
            boolean isDirty = false;
            int index = 0;
            while (index < this.pages.size()) {
                ReviewExtractedItemsPage page = this.pages.get(index);
                page.afterPage();
                InsertAction action = new InsertAction(this.client);
                action.setConvertBuySellToDelivery(page.doConvertToDelivery());
                action.setRemoveDividends(page.doRemoveDividends());
                for (ExtractedEntry entry : page.getEntries()) {
                    if (!entry.isImported()) continue;
                    if (entry.getItem().isInvestmentPlanItem()) {
                        action.setInvestmentPlanItem(true);
                    }
                    entry.getItem().apply((ImportAction)action, (ImportAction.Context)page);
                    action.setInvestmentPlanItem(false);
                    isDirty = true;
                }
                ++index;
            }
            if (isDirty) {
                this.client.markDirty();
                new ConsistencyChecksJob(this.client, false).schedule();
            }
        }
        return true;
    }
}

