/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.text.MessageFormat;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class ImportSourcePage
extends AbstractWizardPage {
    private Security security;
    private Text source;

    protected ImportSourcePage(Security security) {
        super("source");
        this.setTitle(Messages.ImportWizardPasteSourceTitle);
        this.setDescription(MessageFormat.format(Messages.ImportWizardPasteSourceDescription, security.getName()));
        this.security = security;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        Link explanation = new Link(container, 0);
        FormData fd_text = new FormData();
        fd_text.top = new FormAttachment(0);
        fd_text.left = new FormAttachment(0);
        explanation.setLayoutData((Object)fd_text);
        explanation.setText(MessageFormat.format(Messages.ImportWizardPasteSourceExplanation, this.security.getIsin()));
        this.source = new Text(container, 2050);
        FormData fd_source = new FormData();
        fd_source.top = new FormAttachment((Control)explanation, 5);
        fd_source.left = new FormAttachment(0);
        fd_source.right = new FormAttachment(100, 0);
        fd_source.bottom = new FormAttachment(100, 0);
        this.source.setLayoutData((Object)fd_source);
        final String initialText = Messages.ImportWizardPasteSourcePasteHere;
        this.source.setText(initialText);
        this.source.setSelection(0, this.source.getText().length());
        this.source.setFocus();
        this.setPageComplete(false);
        explanation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DesktopAPI.browse(event.text);
            }
        });
        this.source.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ImportSourcePage.this.setPageComplete(!initialText.equals(ImportSourcePage.this.source.getText()) && ImportSourcePage.this.source.getText().length() > 0);
            }
        });
    }

    public String getSourceText() {
        return this.source.getText();
    }
}

