/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.util.List;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.HTMLTableQuoteFeed;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.QuotesTableViewer;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ImportSourcePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ReviewImportedQuotesPage
extends AbstractWizardPage {
    private ImportSourcePage page;
    private QuotesTableViewer tableSampleData;
    private List<LatestSecurityPrice> quotes;

    protected ReviewImportedQuotesPage(ImportSourcePage page) {
        super("review");
        this.setTitle(Messages.ImportWizardReviewTitle);
        this.setDescription(Messages.ImportWizardReviewDescription);
        this.page = page;
        this.setPageComplete(false);
    }

    @Override
    public void beforePage() {
        String source = this.page.getSourceText();
        HTMLTableQuoteFeed feed = (HTMLTableQuoteFeed)Factory.getQuoteFeedProvider((String)"GENERIC_HTML_TABLE");
        QuoteFeedData data = feed.getHistoricalQuotes(source);
        this.quotes = data.getLatestPrices();
        if (!data.getErrors().isEmpty()) {
            PortfolioPlugin.log(data.getErrors());
        }
        this.setErrorMessage(null);
        this.setPageComplete(!this.quotes.isEmpty());
        this.tableSampleData.setInput(this.quotes);
        this.tableSampleData.refresh(true);
        if (!this.quotes.isEmpty()) {
            this.tableSampleData.getTable().showItem(this.tableSampleData.getTable().getItem(0));
        }
    }

    public List<LatestSecurityPrice> getQuotes() {
        return this.quotes;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.tableSampleData = new QuotesTableViewer(container);
    }
}

