/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.util.List;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectSecurityPage
extends AbstractWizardPage {
    static final String PAGE_ID = "select-security-page";
    private Client client;
    private ComboViewer combo;

    public SelectSecurityPage(Client client) {
        super(PAGE_ID);
        this.setTitle(Messages.PageTitleSelectSecurity);
        this.setDescription(Messages.PageDescriptionSelectSecurity);
        this.client = client;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public void beforePage() {
        this.setPageComplete(!this.combo.getSelection().isEmpty());
    }

    @Override
    public void afterPage() {
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        Label label = new Label(container, 0);
        label.setText(Messages.ColumnSecurity);
        List securities = this.client.getActiveSecurities();
        this.combo = new ComboViewer(container);
        this.combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.combo.setInput((Object)securities);
        if (!securities.isEmpty()) {
            this.combo.setSelection((ISelection)new StructuredSelection(securities.get(0)));
        }
        this.combo.addSelectionChangedListener(e -> this.setPageComplete(!this.combo.getSelection().isEmpty()));
        FormDataFactory.startingWith(this.combo.getControl(), label);
        this.setPageComplete(true);
        this.setControl((Control)container);
    }

    public Security getSelectedSecurity() {
        return (Security)((IStructuredSelection)this.combo.getSelection()).getFirstElement();
    }
}

