/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.io.IOException;
import java.util.HashSet;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.IValidatingConverter;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.wizards.security.AbstractPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import name.abuchen.portfolio.util.ImageUtil;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AttributesPage
extends AbstractPage
implements IMenuListener {
    private final EditSecurityModel model;
    private final BindingHelper bindings;
    private Composite attributeContainer;
    private Menu menu;

    public AttributesPage(EditSecurityModel model, BindingHelper bindings) {
        this.model = model;
        this.bindings = bindings;
        this.setTitle(Messages.EditWizardAttributesTitle);
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.attributeContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.attributeContainer);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).applyTo(this.attributeContainer);
        for (EditSecurityModel.AttributeDesignation attribute : this.model.getAttributes()) {
            this.addAttributeBlock(this.attributeContainer, attribute);
        }
        Button addButton = new Button(composite, 8);
        addButton.setImage(Images.ADD.image());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributesPage.this.showAdditionalAttributes();
            }
        });
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)addButton);
        parent.addDisposeListener(e -> {
            if (this.menu != null && !this.menu.isDisposed()) {
                this.menu.dispose();
            }
        });
    }

    private void addAttributeBlock(Composite container, final EditSecurityModel.AttributeDesignation attribute) {
        Binding binding;
        Button value;
        final Label label = new Label(container, 0);
        label.setText(attribute.getType().getName());
        if (attribute.getType().getType() == Boolean.class) {
            value = new Button(container, 32);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)value);
            IObservableValue attributeModel = BeanProperties.value((String)"value", Boolean.class).observe((Object)attribute);
            ISWTObservableValue attributeTarget = WidgetProperties.buttonSelection().observe((Widget)value);
            binding = this.bindings.getBindingContext().bindValue((IObservableValue)attributeTarget, attributeModel);
        } else if (attribute.getType().getConverter() instanceof AttributeType.ImageConverter) {
            value = new Composite(container, 8);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)value);
            final Button preview = new Button((Composite)value, 8);
            String previewPlaceholderText = "...";
            preview.setText("...");
            final AttributeType.ImageConverter conv = (AttributeType.ImageConverter)attribute.getType().getConverter();
            Image img = ImageUtil.toImage((String)conv.toString(attribute.getValue()), (int)16, (int)16);
            if (img != null) {
                preview.setImage(img);
            }
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)value);
            ToAttributeObjectConverter input2model = new ToAttributeObjectConverter(attribute);
            IObservableValue attributeModel = BeanProperties.value((String)"value").observe((Object)attribute);
            ISWTObservableValue attributeTarget = WidgetProperties.tooltipText().observe((Widget)preview);
            binding = this.bindings.getBindingContext().bindValue((IObservableValue)attributeTarget, attributeModel, new UpdateValueStrategy().setAfterGetValidator((IValidator)input2model).setConverter((IConverter)input2model), new UpdateValueStrategy().setConverter((IConverter)new ToAttributeStringConverter(attribute)).setBeforeSetValidator((IValidator)new IValidator<Object>((Control)value){
                private final /* synthetic */ Control val$value;
                {
                    this.val$value = control;
                }

                public IStatus validate(Object value) {
                    String s = conv.toString(value);
                    if (s == null || s.length() == 0) {
                        this.updatePreview(null);
                        return Status.OK_STATUS;
                    }
                    Image img = ImageUtil.toImage((String)s, (int)16, (int)16);
                    this.updatePreview(img);
                    return img == null ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }

                private void updatePreview(Image img) {
                    preview.setImage(img);
                    if (img == null) {
                        preview.setText("...");
                    } else {
                        preview.setText("");
                    }
                    this.val$value.getParent().getParent().layout(true);
                }
            }));
            preview.addMouseListener(MouseListener.mouseDownAdapter(e -> {
                FileDialog dial = new FileDialog(container.getShell());
                String filename = dial.open();
                if (filename != null) {
                    try {
                        String b64 = ImageUtil.loadAndPrepare((String)filename, (int)64, (int)64);
                        attributeModel.setValue((Object)b64);
                    }
                    catch (IOException ex) {
                        PortfolioPlugin.log(ex);
                    }
                }
            }));
        } else {
            value = new Text(container, 2048);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)value);
            ToAttributeObjectConverter input2model = new ToAttributeObjectConverter(attribute);
            IObservableValue attributeModel = BeanProperties.value((String)"value").observe((Object)attribute);
            ISWTObservableValue attributeTarget = WidgetProperties.text((int)24).observe((Widget)value);
            binding = this.bindings.getBindingContext().bindValue((IObservableValue)attributeTarget, attributeModel, new UpdateValueStrategy().setAfterGetValidator((IValidator)input2model).setConverter((IConverter)input2model), new UpdateValueStrategy().setConverter((IConverter)new ToAttributeStringConverter(attribute)));
        }
        final Button deleteButton = new Button(container, 8);
        deleteButton.setImage(Images.REMOVE.image());
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter((Control)value){
            private final /* synthetic */ Control val$value;
            {
                this.val$value = control;
            }

            public void widgetSelected(SelectionEvent e) {
                AttributesPage.this.model.getAttributes().remove(attribute);
                AttributesPage.this.bindings.getBindingContext().removeBinding(binding);
                Composite parent = deleteButton.getParent();
                label.dispose();
                this.val$value.dispose();
                deleteButton.dispose();
                parent.getParent().layout(true);
            }
        });
    }

    protected void showAdditionalAttributes() {
        if (this.menu == null) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener((IMenuListener)this);
            this.menu = menuMgr.createContextMenu((Control)this.getShell());
        }
        this.menu.setVisible(true);
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new LabelOnly(Messages.LabelAvailableAttributes));
        HashSet<AttributeType> existing = new HashSet<AttributeType>();
        for (EditSecurityModel.AttributeDesignation d : this.model.getAttributes()) {
            existing.add(d.getType());
        }
        this.model.getClient().getSettings().getAttributeTypes().filter(a -> !existing.contains(a)).filter(a -> a.supports(Security.class)).forEach(attribute -> this.addMenu(manager, (AttributeType)attribute));
    }

    private void addMenu(IMenuManager manager, final AttributeType attribute) {
        manager.add((IAction)new Action(attribute.getName()){

            public void run() {
                EditSecurityModel.AttributeDesignation a = new EditSecurityModel.AttributeDesignation(attribute, null);
                AttributesPage.this.model.getAttributes().add(a);
                AttributesPage.this.addAttributeBlock(AttributesPage.this.attributeContainer, a);
                AttributesPage.this.attributeContainer.getParent().layout(true);
            }
        });
    }

    private static final class ToAttributeObjectConverter
    implements IValidatingConverter<String, Object> {
        private final EditSecurityModel.AttributeDesignation attribute;

        private ToAttributeObjectConverter(EditSecurityModel.AttributeDesignation attribute) {
            this.attribute = attribute;
        }

        public Object getToType() {
            return Object.class;
        }

        public Object getFromType() {
            return String.class;
        }

        public Object convert(String fromObject) {
            return this.attribute.getType().getConverter().fromString(fromObject);
        }
    }

    private static final class ToAttributeStringConverter
    implements IConverter<Object, String> {
        private final EditSecurityModel.AttributeDesignation attribute;

        private ToAttributeStringConverter(EditSecurityModel.AttributeDesignation attribute) {
            this.attribute = attribute;
        }

        public Object getToType() {
            return String.class;
        }

        public Object getFromType() {
            return Object.class;
        }

        public String convert(Object fromObject) {
            return this.attribute.getType().getConverter().toString(fromObject);
        }
    }
}

