/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.ui.util.BindingHelper;

final class EditSecurityModel
extends BindingHelper.Model {
    private Security security;
    private String name;
    private String onlineId;
    private String currencyCode;
    private String targetCurrencyCode;
    private String note;
    private String isin;
    private String tickerSymbol;
    private String wkn;
    private String calendar;
    private String feed;
    private String feedURL;
    private String latestFeed;
    private String latestFeedURL;
    private boolean isRetired;
    private String statusHistoricalQuotesProvider;
    private String statusLatestQuotesProvider;
    private List<TaxonomyDesignation> taxonomies = new ArrayList<TaxonomyDesignation>();
    private List<AttributeDesignation> attributes = new ArrayList<AttributeDesignation>();
    private Map<String, String> feedProperties = new HashMap<String, String>();

    public EditSecurityModel(Client client, Security security) {
        super(client);
        this.security = security;
        this.name = security.getName();
        this.onlineId = security.getOnlineId();
        this.currencyCode = security.getCurrencyCode();
        this.targetCurrencyCode = security.getTargetCurrencyCode();
        this.note = security.getNote();
        this.isin = security.getIsin();
        this.tickerSymbol = security.getTickerSymbol();
        this.wkn = security.getWkn();
        this.calendar = security.getCalendar();
        this.feed = security.getFeed();
        this.feedURL = security.getFeedURL();
        this.latestFeed = security.getLatestFeed();
        this.latestFeedURL = security.getLatestFeedURL();
        this.isRetired = security.isRetired();
        for (Taxonomy taxonomy : client.getTaxonomies()) {
            this.taxonomies.add(new TaxonomyDesignation(taxonomy, security));
        }
        Attributes securityAttributes = security.getAttributes();
        client.getSettings().getAttributeTypes().filter(arg_0 -> ((Attributes)securityAttributes).exists(arg_0)).filter(a -> a.supports(Security.class)).forEach(a -> {
            AttributeDesignation designation = new AttributeDesignation((AttributeType)a, securityAttributes.get(a));
            this.attributes.add(designation);
        });
        security.getProperties().filter(p -> p.getType() == SecurityProperty.Type.FEED).forEach(p -> {
            String string = this.feedProperties.put(p.getName(), p.getValue());
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    public String getOnlineId() {
        return this.onlineId;
    }

    public void setOnlineId(String onlineId) {
        this.onlineId = onlineId;
        this.firePropertyChange("onlineId", this.onlineId, this.onlineId);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        this.firePropertyChange("currencyCode", this.currencyCode, this.currencyCode);
    }

    public String getTargetCurrencyCode() {
        return this.targetCurrencyCode;
    }

    public void setTargetCurrencyCode(String targetCurrencyCode) {
        this.targetCurrencyCode = targetCurrencyCode;
        this.firePropertyChange("targetCurrencyCode", this.targetCurrencyCode, this.targetCurrencyCode);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.firePropertyChange("note", this.note, this.note);
    }

    public String getIsin() {
        return this.isin;
    }

    public void setIsin(String isin) {
        this.isin = isin;
        this.firePropertyChange("isin", this.isin, this.isin);
    }

    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        this.firePropertyChange("tickerSymbol", this.tickerSymbol, this.tickerSymbol);
    }

    public String getWkn() {
        return this.wkn;
    }

    public void setWkn(String wkn) {
        this.wkn = wkn;
        this.firePropertyChange("wkn", this.wkn, this.wkn);
    }

    public String getCalendar() {
        return this.calendar;
    }

    public void setCalendar(String calendar) {
        this.calendar = calendar;
        this.firePropertyChange("calendar", this.calendar, this.calendar);
    }

    public String getFeed() {
        return this.feed;
    }

    public void setFeed(String feed) {
        this.feed = feed;
        this.firePropertyChange("feed", this.feed, this.feed);
    }

    public String getFeedURL() {
        return this.feedURL;
    }

    public void setFeedURL(String feedURL) {
        this.feedURL = feedURL;
        this.firePropertyChange("feedURL", this.feedURL, this.feedURL);
    }

    public String getLatestFeed() {
        return this.latestFeed;
    }

    public void setLatestFeed(String latestFeed) {
        this.latestFeed = latestFeed;
        this.firePropertyChange("latestFeed", this.latestFeed, this.latestFeed);
    }

    public String getLatestFeedURL() {
        return this.latestFeedURL;
    }

    public void setLatestFeedURL(String latestFeedURL) {
        this.latestFeedURL = latestFeedURL;
        this.firePropertyChange("latestFeedURL", this.latestFeedURL, this.latestFeedURL);
    }

    public boolean isRetired() {
        return this.isRetired;
    }

    public void setRetired(boolean isRetired) {
        this.isRetired = isRetired;
        this.firePropertyChange("retired", this.isRetired, this.isRetired);
    }

    public String getStatusHistoricalQuotesProvider() {
        return this.statusHistoricalQuotesProvider;
    }

    public void setStatusHistoricalQuotesProvider(String status) {
        this.statusHistoricalQuotesProvider = status;
        this.firePropertyChange("statusHistoricalQuotesProvider", this.statusHistoricalQuotesProvider, this.statusHistoricalQuotesProvider);
    }

    public String getStatusLatestQuotesProvider() {
        return this.statusLatestQuotesProvider;
    }

    public void setStatusLatestQuotesProvider(String status) {
        this.statusLatestQuotesProvider = status;
        this.firePropertyChange("statusLatestQuotesProvider", this.statusLatestQuotesProvider, this.statusLatestQuotesProvider);
    }

    public List<TaxonomyDesignation> getDesignations() {
        return this.taxonomies;
    }

    public List<AttributeDesignation> getAttributes() {
        return this.attributes;
    }

    public String getFeedProperty(String name) {
        return this.feedProperties.get(name);
    }

    public void setFeedProperty(String name, String value) {
        this.feedProperties.put(name, value);
    }

    public Security getSecurity() {
        return this.security;
    }

    @Override
    public void applyChanges() {
        this.setAttributes(this.security);
        for (TaxonomyDesignation designation : this.taxonomies) {
            designation.applyChanges();
        }
    }

    public void setAttributes(Security security) {
        security.setName(this.name);
        security.setOnlineId(this.onlineId);
        security.setCurrencyCode(this.currencyCode);
        security.setTargetCurrencyCode(this.targetCurrencyCode);
        security.setNote(this.note);
        security.setIsin(this.isin);
        security.setTickerSymbol(this.tickerSymbol);
        security.setWkn(this.wkn);
        security.setCalendar(this.calendar);
        security.setFeed(this.feed);
        security.setFeedURL(this.feedURL);
        security.setLatestFeed(this.latestFeed);
        security.setLatestFeedURL(this.latestFeedURL);
        security.setRetired(this.isRetired);
        Attributes a = new Attributes();
        for (AttributeDesignation attribute : this.attributes) {
            a.put(attribute.getType(), attribute.getValue());
        }
        security.setAttributes(a);
        security.removePropertyIf(p -> p.getType() == SecurityProperty.Type.FEED);
        this.feedProperties.entrySet().stream().filter(entry -> !Strings.isNullOrEmpty((String)((String)entry.getValue()))).forEach(entry -> security.addProperty(new SecurityProperty(SecurityProperty.Type.FEED, (String)entry.getKey(), (String)entry.getValue())));
    }

    static class AttributeDesignation
    extends BindingHelper.Model {
        private final AttributeType type;
        private Object value;

        public AttributeDesignation(AttributeType type, Object value) {
            this.type = type;
            this.value = value;
        }

        public AttributeType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
            this.firePropertyChange("value", this.value, this.value);
        }

        @Override
        public void applyChanges() {
        }
    }

    static class ClassificationLink
    extends BindingHelper.Model {
        private Classification classification;
        private int weight;

        public ClassificationLink(Classification classification, Classification.Assignment assignment) {
            this.classification = classification;
            this.weight = assignment.getWeight();
        }

        public ClassificationLink() {
            this.weight = Classification.ONE_HUNDRED_PERCENT;
        }

        public Classification getClassification() {
            return this.classification;
        }

        public void setClassification(Classification classification) {
            this.classification = classification;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        @Override
        public void applyChanges() {
        }
    }

    static class TaxonomyDesignation
    extends BindingHelper.Model {
        private Taxonomy taxonomy;
        private Security security;
        private List<Classification> elements;
        private List<ClassificationLink> links = new ArrayList<ClassificationLink>();

        public TaxonomyDesignation(Taxonomy taxonomy, final Security security) {
            this.taxonomy = taxonomy;
            this.security = security;
            this.elements = taxonomy.getRoot().getTreeElements();
            taxonomy.foreach(new Taxonomy.Visitor(){

                public void visit(Classification classification, Classification.Assignment assignment) {
                    if (assignment.getInvestmentVehicle().equals(security)) {
                        links.add(new ClassificationLink(classification, assignment));
                    }
                }
            });
        }

        public Taxonomy getTaxonomy() {
            return this.taxonomy;
        }

        public List<Classification> getElements() {
            return this.elements;
        }

        public List<ClassificationLink> getLinks() {
            return this.links;
        }

        @Override
        public void applyChanges() {
            final HashMap<Classification, ClassificationLink> classification2link = new HashMap<Classification, ClassificationLink>();
            for (ClassificationLink link : this.links) {
                classification2link.put(link.getClassification(), link);
            }
            this.taxonomy.foreach(new Taxonomy.Visitor(){

                public void visit(Classification classification, Classification.Assignment assignment) {
                    if (assignment.getInvestmentVehicle().equals(security)) {
                        ClassificationLink link = (ClassificationLink)classification2link.remove(classification);
                        if (link == null) {
                            classification.getAssignments().remove(assignment);
                        } else {
                            assignment.setWeight(link.getWeight());
                        }
                    }
                }
            });
            for (ClassificationLink link : classification2link.values()) {
                Classification.Assignment assignment = new Classification.Assignment((InvestmentVehicle)this.security);
                assignment.setWeight(link.getWeight());
                assignment.setRank(Integer.MAX_VALUE);
                link.getClassification().addAssignment(assignment);
            }
        }
    }
}

