/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.QuotesTableViewer;
import name.abuchen.portfolio.ui.wizards.security.AbstractQuoteProviderPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import name.abuchen.portfolio.ui.wizards.security.RawResponsesDialog;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class HistoricalQuoteProviderPage
extends AbstractQuoteProviderPage {
    private QuoteFeedData feedData;
    private QuotesTableViewer tableSampleData;
    private Button showRawResponse;
    private Map<Object, QuoteFeedData> cacheQuotes = new HashMap<Object, QuoteFeedData>();
    private LoadHistoricalQuotes currentJob;

    public HistoricalQuoteProviderPage(EditSecurityModel model, BindingHelper bindings) {
        super(model, bindings);
        this.setTitle(Messages.EditWizardQuoteFeedTitle);
        bindings.getBindingContext().addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(model){
            IObservableValue<?> observable;
            {
                this.observable = BeanProperties.value((String)"statusHistoricalQuotesProvider").observe((Object)editSecurityModel);
            }

            protected IStatus validate() {
                return this.observable.getValue() == null ? ValidationStatus.ok() : ValidationStatus.error((String)this.observable.getValue().toString());
            }
        });
    }

    @Override
    protected String getFeed() {
        return this.getModel().getFeed();
    }

    @Override
    protected void setFeed(String feed) {
        this.getModel().setFeed(feed);
    }

    @Override
    protected String getFeedURL() {
        return this.getModel().getFeedURL();
    }

    @Override
    protected void setFeedURL(String feedURL) {
        this.getModel().setFeedURL(feedURL);
    }

    @Override
    protected String getJSONDatePropertyName() {
        return "GENERIC-JSON-DATE";
    }

    @Override
    protected String getJSONClosePropertyName() {
        return "GENERIC-JSON-CLOSE";
    }

    @Override
    protected void setStatus(String status) {
        this.getModel().setStatusHistoricalQuotesProvider(status);
    }

    @Override
    protected List<QuoteFeed> getAvailableFeeds() {
        ArrayList<QuoteFeed> feeds = new ArrayList<QuoteFeed>();
        feeds.addAll(Factory.getQuoteFeedProvider());
        if (this.getModel().getSecurity().getOnlineId() == null) {
            feeds.remove(Factory.getQuoteFeedProvider((String)"PORTFOLIO-REPORT"));
        }
        return feeds;
    }

    @Override
    protected QuoteFeed getQuoteFeedProvider(String feedId) {
        return Factory.getQuoteFeedProvider((String)feedId);
    }

    @Override
    protected void createAdditionalButtons(Composite buttonArea) {
        this.showRawResponse = new Button(buttonArea, 0);
        this.showRawResponse.setText(Messages.LabelShowRawResponse);
        this.showRawResponse.setEnabled(false);
        this.showRawResponse.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            if (this.feedData == null || this.feedData.getResponses().isEmpty()) {
                return;
            }
            new RawResponsesDialog(Display.getCurrent().getActiveShell(), this.feedData.getResponses()).open();
        }));
    }

    @Override
    protected void createSampleArea(Composite container) {
        Composite composite = new Composite(container, 0);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        this.tableSampleData = new QuotesTableViewer(composite);
    }

    @Override
    protected void reinitCaches() {
        this.cacheQuotes = new HashMap<Object, QuoteFeedData>();
    }

    @Override
    protected void clearSampleQuotes() {
        this.currentJob = null;
        this.tableSampleData.setInput(null);
        this.tableSampleData.refresh();
        this.feedData = null;
        this.showRawResponse.setEnabled(false);
    }

    private Object buildCacheKey(Exchange exchange) {
        if (exchange != null) {
            return String.valueOf(this.getFeed()) + exchange.getId();
        }
        if ("ALPHAVANTAGE".equals(this.getFeed())) {
            return "ALPHAVANTAGE" + this.getModel().getTickerSymbol();
        }
        if ("FINNHUB-CANDLE".equals(this.getFeed())) {
            return "FINNHUB-CANDLE" + this.getModel().getTickerSymbol();
        }
        if ("QUANDL-DATASETS".equals(this.getFeed())) {
            return "QUANDL-DATASETS" + String.valueOf(this.getModel().getFeedProperty("QUANDLCODE")) + String.valueOf(this.getModel().getFeedProperty("QUANDLCLOSE"));
        }
        if ("GENERIC-JSON".equals(this.getFeed())) {
            return "GENERIC-JSON" + this.getModel().getFeedURL() + String.valueOf(this.getModel().getFeedProperty("GENERIC-JSON-DATE")) + String.valueOf(this.getModel().getFeedProperty("GENERIC-JSON-CLOSE"));
        }
        return String.valueOf(this.getFeed()) + this.getModel().getFeedURL();
    }

    @Override
    protected void showSampleQuotes(QuoteFeed feed, Exchange exchange) {
        Object cacheKey = this.buildCacheKey(exchange);
        QuoteFeedData data = this.cacheQuotes.get(cacheKey);
        if (data != null) {
            this.feedData = data;
            this.tableSampleData.setInput(data.getLatestPrices());
            this.tableSampleData.refresh();
            this.showRawResponse.setEnabled(!data.getResponses().isEmpty());
        } else {
            this.feedData = null;
            this.tableSampleData.setMessage(Messages.EditWizardQuoteFeedMsgLoading);
            this.tableSampleData.refresh();
            this.showRawResponse.setEnabled(false);
            LoadHistoricalQuotes job = new LoadHistoricalQuotes(feed, exchange, cacheKey);
            job.setUser(true);
            job.schedule(150L);
        }
    }

    private class LoadHistoricalQuotes
    extends Job {
        private QuoteFeed feed;
        private Exchange exchange;
        private Object cacheKey;

        public LoadHistoricalQuotes(QuoteFeed feed, Exchange exchange, Object cacheKey) {
            super(MessageFormat.format(Messages.JobMsgSamplingHistoricalQuotes, exchange != null ? exchange.getName() : ""));
            this.feed = feed;
            this.exchange = exchange;
            this.cacheKey = cacheKey;
            HistoricalQuoteProviderPage.this.currentJob = this;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Security s = HistoricalQuoteProviderPage.this.buildTemporarySecurity();
                if (this.exchange != null) {
                    s.setTickerSymbol(this.exchange.getId());
                    s.setPropertyValue(SecurityProperty.Type.FEED, "PORTFOLIO-REPORT-MARKET", this.exchange.getId());
                }
                s.setFeed(this.feed.getId());
                QuoteFeedData data = this.feed.previewHistoricalQuotes(s);
                Display.getDefault().asyncExec(() -> {
                    if (((Object)((Object)this)).equals((Object)HistoricalQuoteProviderPage.this.currentJob) && !HistoricalQuoteProviderPage.this.tableSampleData.getControl().isDisposed()) {
                        HistoricalQuoteProviderPage.this.currentJob = null;
                        HistoricalQuoteProviderPage.this.cacheQuotes.put(this.cacheKey, data);
                        HistoricalQuoteProviderPage.this.feedData = data;
                        HistoricalQuoteProviderPage.this.tableSampleData.setInput(data.getLatestPrices());
                        HistoricalQuoteProviderPage.this.tableSampleData.refresh();
                        HistoricalQuoteProviderPage.this.showRawResponse.setEnabled(!data.getResponses().isEmpty());
                    }
                });
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(() -> {
                    if (((Object)((Object)this)).equals((Object)HistoricalQuoteProviderPage.this.currentJob) && !HistoricalQuoteProviderPage.this.tableSampleData.getControl().isDisposed()) {
                        HistoricalQuoteProviderPage.this.currentJob = null;
                        HistoricalQuoteProviderPage.this.feedData = null;
                        String message = e.getMessage();
                        if (message == null || message.isEmpty()) {
                            message = Messages.EditWizardQuoteFeedMsgErrorOrNoData;
                        }
                        HistoricalQuoteProviderPage.this.tableSampleData.setMessage(message);
                        HistoricalQuoteProviderPage.this.tableSampleData.refresh();
                        HistoricalQuoteProviderPage.this.showRawResponse.setEnabled(false);
                    }
                });
                PortfolioPlugin.log(e);
            }
            return Status.OK_STATUS;
        }
    }
}

