/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public class RawResponsesDialog
extends Dialog {
    private final List<QuoteFeedData.RawResponse> rawResponses;
    private Text rawText;

    public RawResponsesDialog(Shell parentShell, List<QuoteFeedData.RawResponse> rawResponses) {
        super(parentShell);
        this.rawResponses = Objects.requireNonNull(rawResponses);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LabelInfo);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite editArea = new Composite(composite, 0);
        editArea.setLayoutData((Object)new GridData(1808));
        editArea.setLayout((Layout)new FormLayout());
        ComboViewer comboURL = SWTHelper.createComboViewer(editArea);
        comboURL.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboURL.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((QuoteFeedData.RawResponse)element).getUrl();
            }
        });
        comboURL.setInput(this.rawResponses);
        comboURL.addSelectionChangedListener(event -> this.rawText.setText(((QuoteFeedData.RawResponse)event.getStructuredSelection().getFirstElement()).getContent()));
        this.rawText = new Text(editArea, 2632);
        FormDataFactory.startingWith(comboURL.getControl()).left(new FormAttachment(0, 10)).right(new FormAttachment(100, -10)).width(500).thenBelow((Control)this.rawText, 10).left(new FormAttachment(0, 10)).right(new FormAttachment(100, -10)).width(500).height(300);
        if (!this.rawResponses.isEmpty()) {
            comboURL.setSelection((ISelection)new StructuredSelection((Object)this.rawResponses.get(0)));
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        Button button = this.createButton(parent, 9999, Messages.LabelCopyToClipboard, false);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.rawText.isDisposed()) {
                return;
            }
            Clipboard cb = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{this.rawText.getText()}, new Transfer[]{textTransfer});
        }));
        button = this.createButton(parent, 9998, Messages.LabelFormatJSON, false);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.rawText.isDisposed()) {
                return;
            }
            try {
                JsonElement jsonElement = new JsonParser().parse(this.rawText.getText());
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                this.rawText.setText(gson.toJson(jsonElement));
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }));
        button = this.createButton(parent, 9997, Messages.LabelCleanHTML, false);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.rawText.isDisposed()) {
                return;
            }
            this.rawText.setText(Jsoup.clean((String)this.rawText.getText(), (Whitelist)Whitelist.relaxed()));
        }));
    }
}

