/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SearchSecurityWizardPage
extends WizardPage {
    public static final String PAGE_ID = "searchpage";
    private Client client;
    private SecuritySearchProvider.ResultItem item;

    public SearchSecurityWizardPage(Client client) {
        super(PAGE_ID);
        this.setTitle(Messages.SecurityMenuAddNewSecurity);
        this.setDescription(Messages.SecurityMenuAddNewSecurityDescription);
        this.client = client;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        Text searchBox = new Text(container, 2052);
        searchBox.setText("");
        searchBox.setFocus();
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)searchBox);
        ComboViewer typeBox = new ComboViewer(container, 8);
        typeBox.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        typeBox.setInput((Object)SecuritySearchProvider.Type.values());
        typeBox.setSelection((ISelection)new StructuredSelection((Object)SecuritySearchProvider.Type.ALL));
        Button searchButton = new Button(container, 8);
        searchButton.setText(Messages.LabelSearch);
        TableViewer resultTable = new TableViewer(container, 65536);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo(resultTable.getControl());
        TableColumn column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.ColumnName);
        column.setWidth(250);
        column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.ColumnSymbol);
        column.setWidth(60);
        column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.ColumnISIN);
        column.setWidth(100);
        column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.ColumnWKN);
        column.setWidth(60);
        column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.ColumnSecurityType);
        column.setWidth(60);
        column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.ColumnSecurityExchange);
        column.setWidth(80);
        column = new TableColumn(resultTable.getTable(), 0);
        column.setText(Messages.EditWizardAttributesTitle);
        column.setWidth(250);
        resultTable.getTable().setHeaderVisible(true);
        resultTable.getTable().setLinesVisible(true);
        HashSet<String> existingSymbols = new HashSet<String>();
        for (Security s : this.client.getSecurities()) {
            existingSymbols.add(s.getTickerSymbol());
        }
        resultTable.setLabelProvider((IBaseLabelProvider)new ResultItemLabelProvider(existingSymbols));
        resultTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        searchBox.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
            }
        });
        Consumer<SelectionEvent> onSearchEvent = e -> this.doSearch(searchBox.getText(), (SecuritySearchProvider.Type)typeBox.getStructuredSelection().getFirstElement(), resultTable);
        searchBox.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(onSearchEvent));
        searchButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(onSearchEvent));
        resultTable.addSelectionChangedListener(event -> {
            this.item = (SecuritySearchProvider.ResultItem)((IStructuredSelection)event.getSelection()).getFirstElement();
            this.setPageComplete(this.item != null && !existingSymbols.contains(this.item.getSymbol()));
        });
        this.setControl((Control)container);
    }

    public SecuritySearchProvider.ResultItem getResult() {
        return this.item;
    }

    private void doSearch(String query, SecuritySearchProvider.Type type, TableViewer resultTable) {
        try {
            this.getContainer().run(true, false, progressMonitor -> {
                List providers = Factory.getSearchProvider();
                progressMonitor.beginTask(Messages.SecurityMenuSearch4Securities, providers.size());
                ArrayList result = new ArrayList();
                ArrayList<String> errors = new ArrayList<String>();
                for (SecuritySearchProvider provider : providers) {
                    try {
                        progressMonitor.setTaskName(provider.getName());
                        result.addAll(provider.search(query, type));
                    }
                    catch (IOException e) {
                        PortfolioPlugin.log(e);
                        errors.add(String.valueOf(provider.getName()) + ": " + e.getMessage());
                    }
                    progressMonitor.worked(1);
                }
                Display.getDefault().asyncExec(() -> {
                    resultTable.setInput((Object)result);
                    if (!errors.isEmpty()) {
                        this.setErrorMessage(String.join((CharSequence)", ", errors));
                    }
                });
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            PortfolioPlugin.log(e);
        }
    }

    private static class ResultItemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final Set<String> symbols;

        public ResultItemLabelProvider(Set<String> symbols) {
            this.symbols = symbols;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            SecuritySearchProvider.ResultItem item = (SecuritySearchProvider.ResultItem)element;
            if (item.hasPrices()) {
                return Images.VIEW_LINECHART.image();
            }
            if (item.getOnlineId() != null) {
                return Images.ONLINE.image();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SecuritySearchProvider.ResultItem item = (SecuritySearchProvider.ResultItem)element;
            switch (columnIndex) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getSymbol();
                }
                case 2: {
                    return item.getIsin();
                }
                case 3: {
                    return item.getWkn();
                }
                case 4: {
                    return item.getType();
                }
                case 5: {
                    return item.getExchange();
                }
                case 6: {
                    return item.getExtraAttributes();
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex));
        }

        public Color getForeground(Object element, int columnIndex) {
            SecuritySearchProvider.ResultItem item = (SecuritySearchProvider.ResultItem)element;
            if (item.getSymbol() != null && this.symbols.contains(item.getSymbol())) {
                return Display.getCurrent().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

