/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.wizards.security.AbstractPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class SecurityMasterDataPage
extends AbstractPage {
    private final EditSecurityModel model;
    private final BindingHelper bindings;
    private Text isin;
    private Text wkn;

    protected SecurityMasterDataPage(EditSecurityModel model, BindingHelper bindings) {
        this.model = model;
        this.bindings = bindings;
        this.setTitle(Messages.EditWizardMasterDataTitle);
    }

    @Override
    public void createControl(Composite parent) {
        boolean isSyncedOnline;
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(container);
        boolean isExchangeRate = this.model.getSecurity().isExchangeRate();
        boolean bl = isSyncedOnline = this.model.getOnlineId() != null;
        if (isSyncedOnline) {
            new Label(container, 0).setText("");
            Composite area = new Composite(container, 0);
            RowLayout layout = new RowLayout();
            layout.center = true;
            area.setLayout((Layout)layout);
            Link link = new Link(area, 4);
            link.setText(Messages.LabelLinkedToPortfolioReport);
            link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> DesktopAPI.browse("https://www.portfolio-report.net/securities/" + this.model.getOnlineId())));
            Button unlink = new Button(area, 8);
            unlink.setText(Messages.EditWizardMasterDataUnlink);
            unlink.setToolTipText(Messages.EditWizardMasterDataUnlink_ToolTip);
            unlink.setImage(Images.ONLINE.image());
            unlink.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
                this.model.setOnlineId(null);
                this.isin.setEditable(true);
                this.isin.setBackground(null);
                this.wkn.setEditable(true);
                this.wkn.setBackground(null);
                link.setEnabled(false);
                unlink.setEnabled(false);
            }));
        }
        ComboViewer currencyCode = this.bindings.bindCurrencyCodeCombo(container, Messages.ColumnCurrency, "currencyCode", !isExchangeRate);
        if (this.model.getSecurity().hasTransactions(this.model.getClient())) {
            currencyCode.getCombo().setEnabled(false);
            new Label(container, 0).setText("");
            Composite info = new Composite(container, 0);
            info.setLayout((Layout)new RowLayout());
            Label l = new Label(info, 0);
            l.setImage(Images.INFO.image());
            l = new Label(info, 0);
            l.setText(Messages.MsgInfoChangingCurrencyNotPossible);
        }
        if (isExchangeRate) {
            ComboViewer targetCurrencyCode = this.bindings.bindCurrencyCodeCombo(container, Messages.ColumnTargetCurrency, "targetCurrencyCode", false);
            targetCurrencyCode.getCombo().setToolTipText(Messages.ColumnTargetCurrencyToolTip);
        }
        if (!isExchangeRate) {
            this.isin = this.bindings.bindISINInput(container, Messages.ColumnISIN, "isin");
            if (isSyncedOnline) {
                this.isin.setEditable(false);
                this.isin.setBackground(Colors.SIDEBAR_BACKGROUND_SELECTED);
            }
        }
        this.bindings.bindStringInput(container, Messages.ColumnTicker, "tickerSymbol", 0, 12);
        if (!isExchangeRate) {
            this.wkn = this.bindings.bindStringInput(container, Messages.ColumnWKN, "wkn", 0, 12);
            if (isSyncedOnline) {
                this.wkn.setEditable(false);
                this.wkn.setBackground(Colors.SIDEBAR_BACKGROUND_SELECTED);
            }
            ComboViewer calendar = this.bindings.bindCalendarCombo(container, Messages.LabelSecurityCalendar, "calendar");
            calendar.getCombo().setToolTipText(Messages.LabelSecurityCalendarToolTip);
        }
        Control control = this.bindings.bindBooleanInput(container, Messages.ColumnRetired, "retired");
        int margin = 2;
        Image info = Images.INFO.image();
        Rectangle bounds = info.getBounds();
        GridDataFactory.fillDefaults().indent(bounds.width + margin, 0).applyTo(control);
        ControlDecoration deco = new ControlDecoration(control, 0x1004000);
        deco.setDescriptionText(Messages.MsgInfoRetiredSecurities);
        deco.setImage(info);
        deco.setMarginWidth(margin);
        deco.show();
        Text valueNote = this.bindings.bindStringInput(container, Messages.ColumnNote, "note", 2818, -1);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, SWTHelper.lineHeight((Control)valueNote) * 4).applyTo((Control)valueNote);
    }
}

