/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.splits;

import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.splits.StockSplitModel;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class PreviewTransactionsPage
extends AbstractWizardPage {
    private StockSplitModel model;
    private TableViewer tableViewer;

    public PreviewTransactionsPage(StockSplitModel model) {
        super("preview-transactions");
        this.setTitle(Messages.SplitWizardReviewTransactionsTitle);
        this.setDescription(Messages.SplitWizardReviewTransactionsDescription);
        this.model = model;
    }

    @Override
    public void beforePage() {
        Security security = this.model.getSecurity();
        List transactions = security.getTransactions(this.model.getClient());
        Collections.sort(transactions, new TransactionPair.ByDate());
        this.tableViewer.setInput((Object)transactions);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        Button checkbox = new Button(container, 32);
        checkbox.setText(Messages.SplitWizardLabelUpdateTransactions);
        Composite tableContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableContainer);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(tableContainer, 2048);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnDate);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(100, true));
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnTransactionType);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 131072);
        column.setText(Messages.ColumnCurrentShares);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 131072);
        column.setText(Messages.ColumnUpdatedShares);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnSource);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(200, true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TransactionLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        DataBindingContext context = new DataBindingContext();
        ISWTObservableValue targetObservable = WidgetProperties.buttonSelection().observe((Widget)checkbox);
        IObservableValue modelObservable = BeanProperties.value((String)"changeTransactions").observe((Object)this.model);
        context.bindValue((IObservableValue)targetObservable, modelObservable);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewTransactionsPage.this.tableViewer.refresh();
            }
        });
    }

    private class TransactionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TransactionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                Transaction t = ((TransactionPair)element).getTransaction();
                if (t instanceof AccountTransaction) {
                    return Images.ACCOUNT.image();
                }
                if (t instanceof PortfolioTransaction) {
                    return Images.PORTFOLIO.image();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TransactionPair pair = (TransactionPair)element;
            Transaction t = pair.getTransaction();
            switch (columnIndex) {
                case 0: {
                    return Values.DateTime.format((Object)t.getDateTime());
                }
                case 1: {
                    if (t instanceof AccountTransaction) {
                        return ((AccountTransaction)t).getType().toString();
                    }
                    if (t instanceof PortfolioTransaction) {
                        return ((PortfolioTransaction)t).getType().toString();
                    }
                    return null;
                }
                case 2: {
                    return Values.Share.format((Object)t.getShares());
                }
                case 3: {
                    if (PreviewTransactionsPage.this.model.isChangeTransactions() && t.getDateTime().toLocalDate().isBefore(PreviewTransactionsPage.this.model.getExDate())) {
                        long shares = t.getShares() * (long)PreviewTransactionsPage.this.model.getNewShares() / (long)PreviewTransactionsPage.this.model.getOldShares();
                        return Values.Share.format((Object)shares);
                    }
                    return null;
                }
                case 4: {
                    return pair.getOwner().toString();
                }
            }
            return null;
        }
    }
}

