/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.splits;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.DatePicker;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.SimpleDateTimeDateSelectionProperty;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.splits.StockSplitModel;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SelectSplitPage
extends AbstractWizardPage {
    private StockSplitModel model;
    private BindingHelper bindings;

    public SelectSplitPage(StockSplitModel model) {
        super("select-stock-split");
        this.setTitle(Messages.SplitWizardDefinitionTitle);
        this.setDescription(Messages.SplitWizardDefinitionDescription);
        this.model = model;
        this.bindings = new BindingHelper(model){

            @Override
            public void onValidationStatusChanged(IStatus status) {
                boolean isOK = status.getSeverity() == 0;
                SelectSplitPage.this.setErrorMessage(isOK ? null : status.getMessage());
                SelectSplitPage.this.setPageComplete(isOK);
            }
        };
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        Label labelSecurity = new Label(container, 0);
        labelSecurity.setText(Messages.ColumnSecurity);
        List securities = this.model.getClient().getActiveSecurities();
        if (this.model.getSecurity() != null && !securities.contains(this.model.getSecurity())) {
            securities.add(0, this.model.getSecurity());
        }
        ComboViewer comboSecurity = new ComboViewer(container, 8);
        comboSecurity.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboSecurity.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Security)element).getName();
            }
        });
        comboSecurity.setInput((Object)securities);
        Label labelExDate = new Label(container, 0);
        labelExDate.setText(Messages.ColumnExDate);
        DatePicker boxExDate = new DatePicker(container);
        Label labelSplit = new Label(container, 0);
        labelSplit.setText(Messages.SplitWizardLabelSplit);
        Spinner spinnerNewShares = new Spinner(container, 2048);
        spinnerNewShares.setMinimum(1);
        spinnerNewShares.setMaximum(1000000);
        spinnerNewShares.setSelection(1);
        spinnerNewShares.setIncrement(1);
        spinnerNewShares.setFocus();
        Label labelColon = new Label(container, 0);
        labelColon.setText(Messages.SplitWizardLabelNewForOld);
        Spinner spinnerOldShares = new Spinner(container, 2048);
        spinnerOldShares.setMinimum(1);
        spinnerOldShares.setMaximum(1000000);
        spinnerOldShares.setSelection(1);
        spinnerOldShares.setIncrement(1);
        int labelWidth = SWTHelper.widest(new Control[]{labelSecurity, labelExDate, labelSplit});
        FormDataFactory.startingWith(comboSecurity.getControl(), labelSecurity).thenBelow(boxExDate.getControl()).label(labelExDate).thenBelow((Control)spinnerNewShares).label(labelSplit).thenRight((Control)labelColon).thenRight((Control)spinnerOldShares);
        FormDataFactory.startingWith((Control)labelSecurity).width(labelWidth);
        DataBindingContext context = this.bindings.getBindingContext();
        IViewerObservableValue targetObservable = ViewerProperties.singleSelection().observe((Viewer)comboSecurity);
        IObservableValue securityObservable = BeanProperties.value((String)"security").observe((Object)this.model);
        context.bindValue((IObservableValue)targetObservable, securityObservable, null, null);
        ISWTObservableValue targetExDate = new SimpleDateTimeDateSelectionProperty().observe((Widget)boxExDate.getControl());
        IObservableValue modelExDate = BeanProperties.value((String)"exDate", LocalDate.class).observe((Object)this.model);
        context.bindValue((IObservableValue)targetExDate, modelExDate, new UpdateValueStrategy().setAfterConvertValidator(value -> value != null ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, Messages.ColumnExDate))), null);
        ISWTObservableValue newSharesTargetObservable = WidgetProperties.spinnerSelection().observe((Widget)spinnerNewShares);
        IObservableValue newSharesModelObservable = BeanProperties.value((String)"newShares").observe((Object)this.model);
        context.bindValue((IObservableValue)newSharesTargetObservable, newSharesModelObservable);
        ISWTObservableValue oldSharesTargetObservable = WidgetProperties.spinnerSelection().observe((Widget)spinnerOldShares);
        IObservableValue oldSharesModelObservable = BeanProperties.value((String)"oldShares").observe((Object)this.model);
        context.bindValue((IObservableValue)oldSharesTargetObservable, oldSharesModelObservable);
        MultiValidator validator = new MultiValidator((IObservableValue)newSharesTargetObservable, (IObservableValue)oldSharesTargetObservable){
            private final /* synthetic */ IObservableValue val$newSharesTargetObservable;
            private final /* synthetic */ IObservableValue val$oldSharesTargetObservable;
            {
                this.val$newSharesTargetObservable = iObservableValue;
                this.val$oldSharesTargetObservable = iObservableValue2;
            }

            protected IStatus validate() {
                Object oldShares;
                Object newShares = this.val$newSharesTargetObservable.getValue();
                return newShares.equals(oldShares = this.val$oldSharesTargetObservable.getValue()) ? ValidationStatus.error((String)Messages.SplitWizardErrorNewAndOldMustNotBeEqual) : ValidationStatus.ok();
            }
        };
        context.addValidationStatusProvider((ValidationStatusProvider)validator);
    }
}

