/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.checks.impl.BuySellMissingSecurityIssue;
import name.abuchen.portfolio.checks.impl.MissingAccountTransferIssue;
import name.abuchen.portfolio.checks.impl.MissingBuySellAccountIssue;
import name.abuchen.portfolio.checks.impl.MissingBuySellPortfolioIssue;
import name.abuchen.portfolio.checks.impl.MissingPortfolioTransferIssue;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;

public class CrossEntryCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        return new CheckImpl(client).execute();
    }

    private static class AccountEntry {
        Account account;
        AccountTransaction transaction;

        private AccountEntry(Account owner, AccountTransaction transaction) {
            this.account = owner;
            this.transaction = transaction;
        }
    }

    private static class CheckImpl {
        private Client client;
        private List<AccountEntry> accountTransactions = new ArrayList<AccountEntry>();
        private List<PortfolioEntry> portfolioTransactions = new ArrayList<PortfolioEntry>();
        private List<Issue> issues = new ArrayList<Issue>();

        public CheckImpl(Client client) {
            this.client = client;
        }

        public List<Issue> execute() {
            this.collectAccountTransactions();
            this.collectPortfolioTransactions();
            this.matchBuySell();
            this.matchAccountTransfers();
            this.matchPortfolioTransfers();
            return this.issues;
        }

        private void collectAccountTransactions() {
            for (Account account : this.client.getAccounts()) {
                for (AccountTransaction t : account.getTransactions()) {
                    if (t.getCrossEntry() != null) continue;
                    switch (t.getType()) {
                        case BUY: 
                        case SELL: 
                        case TRANSFER_IN: 
                        case TRANSFER_OUT: {
                            this.accountTransactions.add(new AccountEntry(account, t));
                            break;
                        }
                    }
                }
            }
        }

        private void collectPortfolioTransactions() {
            for (Portfolio portfolio : this.client.getPortfolios()) {
                for (PortfolioTransaction t : portfolio.getTransactions()) {
                    if (t.getCrossEntry() != null) continue;
                    switch (t.getType()) {
                        case BUY: 
                        case SELL: 
                        case TRANSFER_IN: 
                        case TRANSFER_OUT: {
                            this.portfolioTransactions.add(new PortfolioEntry(portfolio, t));
                            break;
                        }
                    }
                }
            }
        }

        private void matchBuySell() {
            Iterator<AccountEntry> iterAccount = this.accountTransactions.iterator();
            while (iterAccount.hasNext()) {
                AccountEntry suspect = iterAccount.next();
                if (suspect.transaction.getType() != AccountTransaction.Type.BUY && suspect.transaction.getType() != AccountTransaction.Type.SELL) continue;
                if (suspect.transaction.getSecurity() == null) {
                    this.issues.add(new BuySellMissingSecurityIssue(this.client, suspect.account, suspect.transaction));
                    iterAccount.remove();
                    continue;
                }
                PortfolioTransaction.Type neededType = PortfolioTransaction.Type.valueOf(suspect.transaction.getType().name());
                PortfolioEntry match = null;
                for (PortfolioEntry candidate : this.portfolioTransactions) {
                    if (candidate.transaction.getType() != neededType || !candidate.transaction.getDateTime().equals(suspect.transaction.getDateTime()) || candidate.transaction.getSecurity() != suspect.transaction.getSecurity() || candidate.transaction.getAmount() != suspect.transaction.getAmount()) continue;
                    match = candidate;
                    break;
                }
                if (match == null) {
                    this.issues.add(new MissingBuySellPortfolioIssue(this.client, suspect.account, suspect.transaction));
                    iterAccount.remove();
                    continue;
                }
                BuySellEntry entry = new BuySellEntry(match.portfolio, suspect.account);
                entry.setCurrencyCode(match.transaction.getCurrencyCode());
                entry.setType(match.transaction.getType());
                entry.setDate(match.transaction.getDateTime());
                entry.setSecurity(match.transaction.getSecurity());
                entry.setShares(match.transaction.getShares());
                entry.setAmount(match.transaction.getAmount());
                entry.getPortfolioTransaction().addUnits(match.transaction.getUnits());
                entry.insert();
                match.portfolio.getTransactions().remove(match.transaction);
                suspect.account.getTransactions().remove(suspect.transaction);
                this.portfolioTransactions.remove(match);
                iterAccount.remove();
            }
            Iterator<PortfolioEntry> iterPorfolio = this.portfolioTransactions.iterator();
            while (iterPorfolio.hasNext()) {
                PortfolioEntry t = iterPorfolio.next();
                if (t.transaction.getType() != PortfolioTransaction.Type.BUY && t.transaction.getType() != PortfolioTransaction.Type.SELL) continue;
                this.issues.add(new MissingBuySellAccountIssue(this.client, t.portfolio, t.transaction));
                iterPorfolio.remove();
            }
        }

        private void matchAccountTransfers() {
            HashSet<AccountEntry> matched = new HashSet<AccountEntry>();
            for (AccountEntry suspect : this.accountTransactions) {
                if (matched.contains(suspect)) continue;
                AccountTransaction.Type neededType = null;
                if (suspect.transaction.getType() == AccountTransaction.Type.TRANSFER_IN) {
                    neededType = AccountTransaction.Type.TRANSFER_OUT;
                } else if (suspect.transaction.getType() == AccountTransaction.Type.TRANSFER_OUT) {
                    neededType = AccountTransaction.Type.TRANSFER_IN;
                }
                if (neededType == null) continue;
                AccountEntry match = null;
                for (AccountEntry candidate : this.accountTransactions) {
                    if (matched.contains(candidate) || candidate.account.equals(suspect.account) || candidate.transaction.getType() != neededType || !candidate.transaction.getDateTime().equals(suspect.transaction.getDateTime()) || candidate.transaction.getAmount() != suspect.transaction.getAmount()) continue;
                    match = candidate;
                    break;
                }
                if (match == null) {
                    matched.add(suspect);
                    this.issues.add(new MissingAccountTransferIssue(this.client, suspect.account, suspect.transaction));
                    continue;
                }
                AccountTransferEntry crossentry = null;
                crossentry = suspect.transaction.getType() == AccountTransaction.Type.TRANSFER_IN ? new AccountTransferEntry(match.account, suspect.account) : new AccountTransferEntry(suspect.account, match.account);
                crossentry.setDate(match.transaction.getDateTime());
                crossentry.setAmount(match.transaction.getAmount());
                crossentry.setCurrencyCode(match.transaction.getCurrencyCode());
                crossentry.insert();
                suspect.account.getTransactions().remove(suspect.transaction);
                match.account.getTransactions().remove(match.transaction);
                matched.add(suspect);
                matched.add(match);
            }
            this.accountTransactions.removeAll(matched);
        }

        private void matchPortfolioTransfers() {
            HashSet<PortfolioEntry> matched = new HashSet<PortfolioEntry>();
            for (PortfolioEntry suspect : this.portfolioTransactions) {
                if (matched.contains(suspect)) continue;
                PortfolioTransaction.Type neededType = null;
                if (suspect.transaction.getType() == PortfolioTransaction.Type.TRANSFER_IN) {
                    neededType = PortfolioTransaction.Type.TRANSFER_OUT;
                } else if (suspect.transaction.getType() == PortfolioTransaction.Type.TRANSFER_OUT) {
                    neededType = PortfolioTransaction.Type.TRANSFER_IN;
                }
                if (neededType == null) continue;
                PortfolioEntry match = null;
                for (PortfolioEntry possibleMatch : this.portfolioTransactions) {
                    if (matched.contains(possibleMatch) || possibleMatch.portfolio.equals(suspect.portfolio) || possibleMatch.transaction.getType() != neededType || !possibleMatch.transaction.getDateTime().equals(suspect.transaction.getDateTime()) || !possibleMatch.transaction.getSecurity().equals(suspect.transaction.getSecurity()) || possibleMatch.transaction.getShares() != suspect.transaction.getShares() || possibleMatch.transaction.getAmount() != suspect.transaction.getAmount()) continue;
                    match = possibleMatch;
                    break;
                }
                if (match == null) {
                    matched.add(suspect);
                    this.issues.add(new MissingPortfolioTransferIssue(this.client, suspect.portfolio, suspect.transaction));
                    continue;
                }
                PortfolioTransferEntry crossentry = null;
                crossentry = suspect.transaction.getType() == PortfolioTransaction.Type.TRANSFER_IN ? new PortfolioTransferEntry(match.portfolio, suspect.portfolio) : new PortfolioTransferEntry(suspect.portfolio, match.portfolio);
                crossentry.setDate(match.transaction.getDateTime());
                crossentry.setSecurity(match.transaction.getSecurity());
                crossentry.setShares(match.transaction.getShares());
                crossentry.setAmount(match.transaction.getAmount());
                crossentry.setCurrencyCode(match.transaction.getCurrencyCode());
                crossentry.insert();
                suspect.portfolio.getTransactions().remove(suspect.transaction);
                match.portfolio.getTransactions().remove(match.transaction);
                matched.add(suspect);
                matched.add(match);
            }
            this.portfolioTransactions.removeAll(matched);
        }
    }

    private static class PortfolioEntry {
        Portfolio portfolio;
        PortfolioTransaction transaction;

        private PortfolioEntry(Portfolio owner, PortfolioTransaction transaction) {
            this.portfolio = owner;
            this.transaction = transaction;
        }
    }
}

