/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;

public class FixWrongTransfersCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        List transactions = client.getPortfolios().stream().flatMap(p -> p.getTransactions().stream()).filter(t -> PortfolioTransaction.Type.TRANSFER_IN.equals((Object)t.getType())).collect(Collectors.toList());
        for (PortfolioTransaction t2 : transactions) {
            if (!(t2.getCrossEntry() instanceof BuySellEntry)) continue;
            PortfolioTransaction copy = new PortfolioTransaction(t2.getDateTime(), t2.getCurrencyCode(), t2.getAmount(), t2.getSecurity(), t2.getShares(), PortfolioTransaction.Type.DELIVERY_INBOUND, t2.getUnitSum(Transaction.Unit.Type.FEE).getAmount(), t2.getUnitSum(Transaction.Unit.Type.TAX).getAmount());
            copy.setNote(t2.getNote());
            ((Portfolio)t2.getCrossEntry().getOwner(t2)).addTransaction(copy);
            ((Portfolio)t2.getCrossEntry().getOwner(t2)).deleteTransaction(t2, client);
        }
        return Collections.emptyList();
    }
}

