/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.AbstractAccountIssue;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.Client;

class MissingAccountTransferIssue
extends AbstractAccountIssue {
    public MissingAccountTransferIssue(Client client, Account account, AccountTransaction transaction) {
        super(client, account, transaction);
    }

    @Override
    public String getLabel() {
        return MessageFormat.format(Messages.IssueMissingAccountTransfer, this.transaction.getType().toString());
    }

    @Override
    public List<QuickFix> getAvailableFixes() {
        List<QuickFix> answer = this.client.getAccounts().stream().filter(a -> !a.equals(this.account)).map(a -> new CreateTransferFix((Account)a)).collect(Collectors.toList());
        answer.add(new DeleteTransactionFix<AccountTransaction>(this.client, this.account, this.transaction));
        return answer;
    }

    private final class CreateTransferFix
    implements QuickFix {
        private Account crossAccount;

        private CreateTransferFix(Account crossAccount) {
            this.crossAccount = crossAccount;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixCreateTransfer, this.crossAccount.getName());
        }

        @Override
        public String getDoneLabel() {
            AccountTransaction.Type target = null;
            target = MissingAccountTransferIssue.this.transaction.getType() == AccountTransaction.Type.TRANSFER_IN ? AccountTransaction.Type.TRANSFER_OUT : AccountTransaction.Type.TRANSFER_IN;
            return MessageFormat.format(Messages.FixCreateTransferDone, target.toString());
        }

        @Override
        public void execute() {
            Account from = null;
            Account to = null;
            if (MissingAccountTransferIssue.this.transaction.getType() == AccountTransaction.Type.TRANSFER_IN) {
                from = this.crossAccount;
                to = MissingAccountTransferIssue.this.account;
            } else {
                from = MissingAccountTransferIssue.this.account;
                to = this.crossAccount;
            }
            AccountTransferEntry entry = new AccountTransferEntry(from, to);
            entry.setDate(MissingAccountTransferIssue.this.transaction.getDateTime());
            entry.setAmount(MissingAccountTransferIssue.this.transaction.getAmount());
            entry.setCurrencyCode(MissingAccountTransferIssue.this.transaction.getCurrencyCode());
            entry.insert();
            MissingAccountTransferIssue.this.account.getTransactions().remove(MissingAccountTransferIssue.this.transaction);
        }
    }
}

