/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.AbstractAccountIssue;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.money.Values;

class MissingBuySellPortfolioIssue
extends AbstractAccountIssue {
    public MissingBuySellPortfolioIssue(Client client, Account account, AccountTransaction transaction) {
        super(client, account, transaction);
    }

    @Override
    public String getLabel() {
        return MessageFormat.format(Messages.IssueMissingBuySellInPortfolio, this.transaction.getType().toString(), this.transaction.getSecurity().getName());
    }

    @Override
    public List<QuickFix> getAvailableFixes() {
        ArrayList<QuickFix> answer = new ArrayList<QuickFix>();
        answer.add(new DeleteTransactionFix<AccountTransaction>(this.client, this.account, this.transaction));
        this.client.getPortfolios().stream().forEach(p -> {
            boolean bl = answer.add(new CreateBuySellEntryFix((Portfolio)p));
        });
        return answer;
    }

    private final class CreateBuySellEntryFix
    implements QuickFix {
        private final Portfolio portfolio;

        private CreateBuySellEntryFix(Portfolio portfolio) {
            this.portfolio = portfolio;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixCreateCrossEntryPortfolio, this.portfolio.getName());
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixCreateCrossEntryDone, MissingBuySellPortfolioIssue.this.transaction.getType().toString());
        }

        @Override
        public void execute() {
            BuySellEntry entry = new BuySellEntry(this.portfolio, MissingBuySellPortfolioIssue.this.account);
            entry.setDate(MissingBuySellPortfolioIssue.this.transaction.getDateTime());
            entry.setType(PortfolioTransaction.Type.valueOf(MissingBuySellPortfolioIssue.this.transaction.getType().name()));
            entry.setSecurity(MissingBuySellPortfolioIssue.this.transaction.getSecurity());
            entry.setShares(Values.Share.factor());
            entry.setAmount(MissingBuySellPortfolioIssue.this.transaction.getAmount());
            entry.setCurrencyCode(MissingBuySellPortfolioIssue.this.transaction.getCurrencyCode());
            entry.insert();
            MissingBuySellPortfolioIssue.this.account.getTransactions().remove(MissingBuySellPortfolioIssue.this.transaction);
        }
    }
}

