/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.AbstractPortfolioIssue;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.money.Values;

class MissingPortfolioTransferIssue
extends AbstractPortfolioIssue {
    public MissingPortfolioTransferIssue(Client client, Portfolio portfolio, PortfolioTransaction transaction) {
        super(client, portfolio, transaction);
    }

    @Override
    public String getLabel() {
        return MessageFormat.format(Messages.IssueMissingPortfolioTransfer, this.transaction.getType().toString(), Values.Share.format(this.transaction.getShares()), Values.Quote.format(this.transaction.getGrossPricePerShare()), this.transaction.getSecurity().getName());
    }

    @Override
    public List<QuickFix> getAvailableFixes() {
        List<QuickFix> answer = this.client.getPortfolios().stream().filter(p -> !p.equals(this.portfolio)).map(p -> new CreateTransferFix((Portfolio)p)).collect(Collectors.toList());
        answer.add(new DeleteTransactionFix<PortfolioTransaction>(this.client, this.portfolio, this.transaction));
        return answer;
    }

    private final class CreateTransferFix
    implements QuickFix {
        private Portfolio crossPortfolio;

        private CreateTransferFix(Portfolio crossPortfolio) {
            this.crossPortfolio = crossPortfolio;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixCreateTransfer, this.crossPortfolio.getName());
        }

        @Override
        public String getDoneLabel() {
            PortfolioTransaction.Type target = MissingPortfolioTransferIssue.this.transaction.getType() == PortfolioTransaction.Type.TRANSFER_IN ? PortfolioTransaction.Type.TRANSFER_OUT : PortfolioTransaction.Type.TRANSFER_IN;
            return MessageFormat.format(Messages.FixCreateTransferDone, target.toString());
        }

        @Override
        public void execute() {
            Portfolio to;
            Portfolio from;
            if (MissingPortfolioTransferIssue.this.transaction.getType() == PortfolioTransaction.Type.TRANSFER_IN) {
                from = this.crossPortfolio;
                to = MissingPortfolioTransferIssue.this.portfolio;
            } else {
                from = MissingPortfolioTransferIssue.this.portfolio;
                to = this.crossPortfolio;
            }
            PortfolioTransferEntry entry = new PortfolioTransferEntry(from, to);
            entry.setDate(MissingPortfolioTransferIssue.this.transaction.getDateTime());
            entry.setSecurity(MissingPortfolioTransferIssue.this.transaction.getSecurity());
            entry.setShares(MissingPortfolioTransferIssue.this.transaction.getShares());
            entry.setAmount(MissingPortfolioTransferIssue.this.transaction.getAmount());
            entry.setCurrencyCode(MissingPortfolioTransferIssue.this.transaction.getCurrencyCode());
            entry.insert();
            MissingPortfolioTransferIssue.this.portfolio.getTransactions().remove(MissingPortfolioTransferIssue.this.transaction);
        }
    }
}

