/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer;

import java.io.File;
import java.time.LocalDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.IBFlexStatementExtractor;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.datatransfer.SecurityCache;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;

public interface Extractor {
    public String getLabel();

    public List<Item> extract(SecurityCache var1, InputFile var2, List<Exception> var3);

    default public List<Item> extract(List<InputFile> file, List<Exception> errors) {
        Client client = null;
        if (this instanceof AbstractPDFExtractor) {
            client = ((AbstractPDFExtractor)this).getClient();
        } else if (this instanceof IBFlexStatementExtractor) {
            client = ((IBFlexStatementExtractor)this).getClient();
        } else {
            throw new IllegalArgumentException();
        }
        SecurityCache securityCache = new SecurityCache(client);
        List<Item> result = file.stream().flatMap(f -> this.extract(securityCache, (InputFile)f, errors).stream()).collect(Collectors.toList());
        HashMap<Extractor, List<Item>> itemsByExtractor = new HashMap<Extractor, List<Item>>();
        itemsByExtractor.put(this, this.postProcessing(result));
        securityCache.addMissingSecurityItems(itemsByExtractor);
        return result;
    }

    default public List<Item> postProcessing(List<Item> result) {
        return result;
    }

    public static class AccountTransferItem
    extends Item {
        private final AccountTransferEntry entry;
        private final boolean isOutbound;

        public AccountTransferItem(AccountTransferEntry entry, boolean isOutbound) {
            this.entry = entry;
            this.isOutbound = isOutbound;
        }

        @Override
        public Annotated getSubject() {
            return this.entry;
        }

        @Override
        public String getTypeInformation() {
            return this.isOutbound ? PortfolioTransaction.Type.TRANSFER_OUT.toString() : PortfolioTransaction.Type.TRANSFER_IN.toString();
        }

        @Override
        public LocalDateTime getDate() {
            return this.entry.getSourceTransaction().getDateTime();
        }

        @Override
        public Money getAmount() {
            return this.entry.getSourceTransaction().getMonetaryAmount();
        }

        @Override
        public Security getSecurity() {
            return null;
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            Account accountSecondary;
            Account account = this.getAccountPrimary();
            if (account == null) {
                account = context.getAccount();
            }
            if ((accountSecondary = this.getAccountSecondary()) == null) {
                accountSecondary = context.getSecondaryAccount();
            }
            if (this.isOutbound) {
                return action.process(this.entry, account, accountSecondary);
            }
            return action.process(this.entry, accountSecondary, account);
        }
    }

    public static class BuySellEntryItem
    extends Item {
        private final BuySellEntry entry;

        public BuySellEntryItem(BuySellEntry entry) {
            this.entry = entry;
        }

        @Override
        public Annotated getSubject() {
            return this.entry;
        }

        @Override
        public String getTypeInformation() {
            return this.entry.getAccountTransaction().getType().toString();
        }

        @Override
        public LocalDateTime getDate() {
            return this.entry.getAccountTransaction().getDateTime();
        }

        @Override
        public Money getAmount() {
            return this.entry.getAccountTransaction().getMonetaryAmount();
        }

        @Override
        public long getShares() {
            return this.entry.getPortfolioTransaction().getShares();
        }

        @Override
        public Security getSecurity() {
            return this.entry.getAccountTransaction().getSecurity();
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            ImportAction.Status status;
            Portfolio portfolio;
            Account account = this.getAccountPrimary();
            if (account == null) {
                account = context.getAccount();
            }
            if ((portfolio = this.getPortfolioPrimary()) == null) {
                portfolio = context.getPortfolio();
            }
            if (Messages.InvestmentPlanItemImportToolTip.equals((status = action.process(this.entry, account, portfolio)).getMessage())) {
                super.setInvestmentPlanItem(true);
            }
            return status;
        }
    }

    public static class InputFile {
        private File file;

        public InputFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.file.getName();
        }
    }

    public static abstract class Item {
        private Object data;
        private Account accountPrimary;
        private Account accountSecondary;
        private Portfolio portfolioPrimary;
        private Portfolio portfolioSecondary;
        private boolean investmentPlanItem = false;

        public abstract Annotated getSubject();

        public abstract Security getSecurity();

        public abstract String getTypeInformation();

        public abstract LocalDateTime getDate();

        public Money getAmount() {
            return null;
        }

        public long getShares() {
            return 0L;
        }

        public abstract ImportAction.Status apply(ImportAction var1, ImportAction.Context var2);

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Account getAccountPrimary() {
            return this.accountPrimary;
        }

        public void setAccountPrimary(Account account) {
            this.accountPrimary = account;
        }

        public Account getAccountSecondary() {
            return this.accountSecondary;
        }

        public void setAccountSecondary(Account account) {
            this.accountSecondary = account;
        }

        public Portfolio getPortfolioPrimary() {
            return this.portfolioPrimary;
        }

        public void setPortfolioPrimary(Portfolio portfolio) {
            this.portfolioPrimary = portfolio;
        }

        public Portfolio getPortfolioSecondary() {
            return this.portfolioSecondary;
        }

        public void setPortfolioSecondary(Portfolio portfolio) {
            this.portfolioSecondary = portfolio;
        }

        public boolean isInvestmentPlanItem() {
            return this.investmentPlanItem;
        }

        public void setInvestmentPlanItem(boolean flag) {
            this.investmentPlanItem = flag;
        }
    }

    public static class NonImportableItem
    extends Item
    implements Annotated {
        private String typeInformation;
        private String note;

        public NonImportableItem(String typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public Annotated getSubject() {
            return this;
        }

        @Override
        public Security getSecurity() {
            return null;
        }

        @Override
        public String getTypeInformation() {
            return this.typeInformation;
        }

        @Override
        public LocalDateTime getDate() {
            return null;
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            return action.process(this);
        }

        @Override
        public void setNote(String note) {
            this.note = note;
        }

        @Override
        public String getNote() {
            return this.note;
        }
    }

    public static class PortfolioTransferItem
    extends Item {
        private final PortfolioTransferEntry entry;

        public PortfolioTransferItem(PortfolioTransferEntry entry) {
            this.entry = entry;
        }

        @Override
        public Annotated getSubject() {
            return this.entry;
        }

        @Override
        public String getTypeInformation() {
            return Messages.LabelTransferPortfolio;
        }

        @Override
        public LocalDateTime getDate() {
            return this.entry.getSourceTransaction().getDateTime();
        }

        @Override
        public Money getAmount() {
            return this.entry.getSourceTransaction().getMonetaryAmount();
        }

        @Override
        public long getShares() {
            return this.entry.getSourceTransaction().getShares();
        }

        @Override
        public Security getSecurity() {
            return this.entry.getSourceTransaction().getSecurity();
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            Portfolio portfolioSecondary;
            Portfolio portfolio = this.getPortfolioPrimary();
            if (portfolio == null) {
                portfolio = context.getPortfolio();
            }
            if ((portfolioSecondary = this.getPortfolioSecondary()) == null) {
                portfolioSecondary = context.getSecondaryPortfolio();
            }
            return action.process(this.entry, portfolio, portfolioSecondary);
        }
    }

    public static class SecurityItem
    extends Item {
        private Security security;

        public SecurityItem(Security security) {
            this.security = security;
        }

        @Override
        public Annotated getSubject() {
            return this.getSecurity();
        }

        @Override
        public String getTypeInformation() {
            return Messages.LabelSecurity;
        }

        @Override
        public LocalDateTime getDate() {
            return null;
        }

        @Override
        public Security getSecurity() {
            return this.security;
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            return action.process(this.security);
        }
    }

    public static class SecurityPriceItem
    extends Item {
        private Security security;
        private SecurityPrice price;

        public SecurityPriceItem(Security security, SecurityPrice price) {
            this.security = security;
            this.price = price;
        }

        @Override
        public Annotated getSubject() {
            return this.getSecurity();
        }

        @Override
        public String getTypeInformation() {
            return Messages.LabelSecurityPrice;
        }

        @Override
        public LocalDateTime getDate() {
            return this.price.getDate().atStartOfDay();
        }

        @Override
        public Money getAmount() {
            return Money.of(this.security.getCurrencyCode(), Math.round((double)this.price.getValue() / Values.Quote.dividerToMoney()));
        }

        @Override
        public Security getSecurity() {
            return this.security;
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            return action.process(this.security, this.price);
        }
    }

    public static class TransactionItem
    extends Item {
        private Transaction transaction;

        public TransactionItem(AccountTransaction transaction) {
            if (EnumSet.of(AccountTransaction.Type.BUY, AccountTransaction.Type.SELL, AccountTransaction.Type.TRANSFER_IN, AccountTransaction.Type.TRANSFER_OUT).contains((Object)transaction.getType())) {
                throw new UnsupportedOperationException();
            }
            this.transaction = transaction;
        }

        public TransactionItem(PortfolioTransaction transaction) {
            if (EnumSet.of(PortfolioTransaction.Type.BUY, PortfolioTransaction.Type.SELL, PortfolioTransaction.Type.TRANSFER_IN, PortfolioTransaction.Type.TRANSFER_OUT).contains((Object)transaction.getType())) {
                throw new UnsupportedOperationException();
            }
            this.transaction = transaction;
        }

        @Override
        public Annotated getSubject() {
            return this.transaction;
        }

        @Override
        public String getTypeInformation() {
            if (this.transaction instanceof AccountTransaction) {
                return ((AccountTransaction)this.transaction).getType().toString();
            }
            if (this.transaction instanceof PortfolioTransaction) {
                return ((PortfolioTransaction)this.transaction).getType().toString();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getDate() {
            return this.transaction.getDateTime();
        }

        @Override
        public Money getAmount() {
            return this.transaction.getMonetaryAmount();
        }

        @Override
        public long getShares() {
            return this.transaction.getShares();
        }

        @Override
        public Security getSecurity() {
            return this.transaction.getSecurity();
        }

        @Override
        public ImportAction.Status apply(ImportAction action, ImportAction.Context context) {
            if (this.transaction instanceof AccountTransaction) {
                Account account = this.getAccountPrimary();
                if (account == null) {
                    account = context.getAccount();
                }
                return action.process((AccountTransaction)this.transaction, account);
            }
            if (this.transaction instanceof PortfolioTransaction) {
                Portfolio portfolio = this.getPortfolioPrimary();
                if (portfolio == null) {
                    portfolio = context.getPortfolio();
                }
                return action.process((PortfolioTransaction)this.transaction, portfolio);
            }
            throw new UnsupportedOperationException();
        }
    }
}

