/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.SecurityCache;
import name.abuchen.portfolio.datatransfer.csv.CSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.util.TextUtil;

abstract class BaseCSVExtractor
extends CSVExtractor {
    private Client client;
    private SecurityCache securityCache;
    private String label;
    private List<CSVImporter.Field> fields;

    BaseCSVExtractor(Client client, String label) {
        this.client = client;
        this.label = label;
        this.fields = new ArrayList<CSVImporter.Field>();
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final List<CSVImporter.Field> getFields() {
        return this.fields;
    }

    public final String toString() {
        return this.label;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public List<Extractor.Item> extract(int skipLines, List<String[]> rawValues, Map<String, CSVImporter.Column> field2column, List<Exception> errors) {
        this.securityCache = new SecurityCache(this.client);
        ArrayList<Extractor.Item> result = new ArrayList<Extractor.Item>();
        int lineNo = 1 + skipLines;
        for (String[] strings : rawValues) {
            Object[] trimmed = TextUtil.strip(strings);
            try {
                this.extract(result, (String[])trimmed, field2column);
            }
            catch (IllegalArgumentException | UnsupportedOperationException | ParseException e) {
                errors.add(new IOException(MessageFormat.format(Messages.CSVLineXwithMsgY, lineNo, e.getMessage(), Arrays.toString(trimmed)), e));
            }
            ++lineNo;
        }
        HashMap<Extractor, List<Extractor.Item>> itemsByExtractor = new HashMap<Extractor, List<Extractor.Item>>();
        itemsByExtractor.put(this, result);
        this.securityCache.addMissingSecurityItems(itemsByExtractor);
        this.securityCache = null;
        return result;
    }

    abstract void extract(List<Extractor.Item> var1, String[] var2, Map<String, CSVImporter.Column> var3) throws ParseException;

    protected Security getSecurity(String[] rawValues, Map<String, CSVImporter.Column> field2column, Consumer<Security> onSecurityCreated) {
        Security security = null;
        String isin = this.getISIN(Messages.CSVColumn_ISIN, rawValues, field2column);
        String tickerSymbol = this.getText(Messages.CSVColumn_TickerSymbol, rawValues, field2column);
        String wkn = this.getText(Messages.CSVColumn_WKN, rawValues, field2column);
        String name = this.getText(Messages.CSVColumn_SecurityName, rawValues, field2column);
        if (isin != null || tickerSymbol != null || wkn != null || name != null) {
            name = this.constructName(isin, tickerSymbol, wkn, name);
            security = this.securityCache.lookup(isin, tickerSymbol, wkn, name, () -> {
                Security s = new Security();
                s.setCurrencyCode(this.client.getBaseCurrency());
                onSecurityCreated.accept(s);
                return s;
            });
        }
        return security;
    }

    private String constructName(String isin, String tickerSymbol, String wkn, String name) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String key = isin != null ? isin : (tickerSymbol != null ? tickerSymbol : wkn);
        return MessageFormat.format(Messages.CSVImportedSecurityLabel, key);
    }

    protected String getCurrencyCode(String name, String[] rawValues, Map<String, CSVImporter.Column> field2column) {
        String value = this.getText(name, rawValues, field2column);
        if (value == null) {
            return this.client.getBaseCurrency();
        }
        CurrencyUnit unit = CurrencyUnit.getInstance(value.trim());
        return unit == null ? this.client.getBaseCurrency() : unit.getCurrencyCode();
    }

    protected Money getMoney(String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        return this.getMoney(Messages.CSVColumn_Value, Messages.CSVColumn_TransactionCurrency, rawValues, field2column);
    }

    protected Money getMoney(String value, String currency, String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        Long amount = this.getAmount(value, rawValues, field2column);
        if (amount == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Value), 0);
        }
        String currencyCode = this.getCurrencyCode(currency, rawValues, field2column);
        return Money.of(currencyCode, amount);
    }

    protected Optional<SecurityPrice> getSecurityPrice(String dateField, String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        Long amount = this.getQuote(Messages.CSVColumn_Quote, rawValues, field2column);
        if (amount == null) {
            return Optional.empty();
        }
        LocalDateTime date = this.getDate(dateField, null, rawValues, field2column);
        if (date == null) {
            date = LocalDate.now().atStartOfDay();
        }
        return Optional.of(new SecurityPrice(date.toLocalDate(), Math.abs(amount)));
    }
}

