/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.BaseCSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

class CSVAccountTransactionExtractor
extends BaseCSVExtractor {
    CSVAccountTransactionExtractor(Client client) {
        super(client, Messages.CSVDefAccountTransactions);
        List<CSVImporter.Field> fields = this.getFields();
        fields.add(new CSVImporter.DateField("date", Messages.CSVColumn_Date));
        fields.add(new CSVImporter.Field("time", Messages.CSVColumn_Time).setOptional(true));
        fields.add(new CSVImporter.ISINField("isin", Messages.CSVColumn_ISIN).setOptional(true));
        fields.add(new CSVImporter.Field("ticker", Messages.CSVColumn_TickerSymbol).setOptional(true));
        fields.add(new CSVImporter.Field("wkn", Messages.CSVColumn_WKN).setOptional(true));
        fields.add(new CSVImporter.AmountField("value", Messages.CSVColumn_Value));
        fields.add(new CSVImporter.Field("currency", Messages.CSVColumn_TransactionCurrency).setOptional(true));
        fields.add(new CSVImporter.EnumField<AccountTransaction.Type>("type", Messages.CSVColumn_Type, AccountTransaction.Type.class).setOptional(true));
        fields.add(new CSVImporter.Field("name", Messages.CSVColumn_SecurityName).setOptional(true));
        fields.add(new CSVImporter.AmountField("shares", Messages.CSVColumn_Shares).setOptional(true));
        fields.add(new CSVImporter.Field("note", Messages.CSVColumn_Note).setOptional(true));
        fields.add(new CSVImporter.AmountField("taxes", Messages.CSVColumn_Taxes).setOptional(true));
        fields.add(new CSVImporter.AmountField("fees", Messages.CSVColumn_Fees).setOptional(true));
        fields.add(new CSVImporter.Field("account", Messages.CSVColumn_AccountName).setOptional(true));
        fields.add(new CSVImporter.Field("account2nd", Messages.CSVColumn_AccountName2nd).setOptional(true));
        fields.add(new CSVImporter.Field("portfolio", Messages.CSVColumn_PortfolioName).setOptional(true));
    }

    @Override
    public String getCode() {
        return "account-transaction";
    }

    @Override
    void extract(List<Extractor.Item> items, String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        Security security = this.getSecurity(rawValues, field2column, s -> s.setCurrencyCode(this.getCurrencyCode(Messages.CSVColumn_TransactionCurrency, rawValues, field2column)));
        Money amount = this.getMoney(rawValues, field2column);
        AccountTransaction.Type type = this.inferType(rawValues, field2column, security, amount);
        LocalDateTime date = this.getDate(Messages.CSVColumn_Date, Messages.CSVColumn_Time, rawValues, field2column);
        if (date == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Date), 0);
        }
        String note = this.getText(Messages.CSVColumn_Note, rawValues, field2column);
        Long shares = this.getShares(Messages.CSVColumn_Shares, rawValues, field2column);
        Long taxes = this.getAmount(Messages.CSVColumn_Taxes, rawValues, field2column);
        Long fees = this.getAmount(Messages.CSVColumn_Fees, rawValues, field2column);
        Account account = this.getAccount(this.getClient(), rawValues, field2column);
        Account account2nd = this.getAccount(this.getClient(), rawValues, field2column, true);
        Portfolio portfolio = this.getPortfolio(this.getClient(), rawValues, field2column);
        Extractor.Item item = null;
        switch (type) {
            case TRANSFER_IN: 
            case TRANSFER_OUT: {
                AccountTransferEntry entry = new AccountTransferEntry();
                entry.setAmount(Math.abs(amount.getAmount()));
                entry.setCurrencyCode(amount.getCurrencyCode());
                entry.setDate(date.withHour(0).withMinute(0));
                entry.setNote(note);
                item = new Extractor.AccountTransferItem(entry, type == AccountTransaction.Type.TRANSFER_OUT);
                break;
            }
            case BUY: 
            case SELL: {
                if (security == null) {
                    throw new ParseException(MessageFormat.format(Messages.CSVImportMissingSecurity, new StringJoiner(", ").add(Messages.CSVColumn_ISIN).add(Messages.CSVColumn_TickerSymbol).add(Messages.CSVColumn_WKN).toString()), 0);
                }
                if (shares == null) {
                    throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Shares), 0);
                }
                BuySellEntry buySellEntry = new BuySellEntry();
                buySellEntry.setType(PortfolioTransaction.Type.valueOf(type.name()));
                buySellEntry.setAmount(Math.abs(amount.getAmount()));
                buySellEntry.setShares(Math.abs(shares));
                buySellEntry.setCurrencyCode(amount.getCurrencyCode());
                buySellEntry.setSecurity(security);
                buySellEntry.setDate(date);
                buySellEntry.setNote(note);
                if (taxes != null && taxes != 0L) {
                    buySellEntry.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(buySellEntry.getPortfolioTransaction().getCurrencyCode(), Math.abs(taxes))));
                }
                if (fees != null && fees != 0L) {
                    buySellEntry.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(buySellEntry.getPortfolioTransaction().getCurrencyCode(), Math.abs(fees))));
                }
                if (buySellEntry.getPortfolioTransaction().getAmount() == 0L && buySellEntry.getPortfolioTransaction().getType() == PortfolioTransaction.Type.SELL) {
                    PortfolioTransaction tx = buySellEntry.getPortfolioTransaction();
                    item = new Extractor.TransactionItem(this.convertToOutboundDelivery(tx));
                    break;
                }
                item = new Extractor.BuySellEntryItem(buySellEntry);
                break;
            }
            case DIVIDENDS: {
                if (security == null) {
                    throw new ParseException(MessageFormat.format(Messages.CSVImportMissingSecurity, new StringJoiner(", ").add(Messages.CSVColumn_ISIN).add(Messages.CSVColumn_TickerSymbol).add(Messages.CSVColumn_WKN).toString()), 0);
                }
            }
            case DEPOSIT: 
            case REMOVAL: 
            case INTEREST: 
            case INTEREST_CHARGE: 
            case FEES: 
            case FEES_REFUND: 
            case TAXES: 
            case TAX_REFUND: {
                AccountTransaction t = new AccountTransaction();
                t.setType(type);
                t.setAmount(Math.abs(amount.getAmount()));
                t.setCurrencyCode(amount.getCurrencyCode());
                if (type == AccountTransaction.Type.DIVIDENDS || type == AccountTransaction.Type.TAXES || type == AccountTransaction.Type.TAX_REFUND || type == AccountTransaction.Type.FEES || type == AccountTransaction.Type.FEES_REFUND) {
                    t.setSecurity(security);
                }
                t.setDateTime(date.withHour(0).withMinute(0));
                t.setNote(note);
                if (shares != null && type == AccountTransaction.Type.DIVIDENDS) {
                    t.setShares(Math.abs(shares));
                }
                if (type == AccountTransaction.Type.DIVIDENDS && taxes != null && taxes != 0L) {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(t.getCurrencyCode(), Math.abs(taxes))));
                }
                item = new Extractor.TransactionItem(t);
                break;
            }
            default: {
                throw new IllegalArgumentException(type.toString());
            }
        }
        item.setAccountPrimary(account);
        item.setAccountSecondary(account2nd);
        item.setPortfolioPrimary(portfolio);
        items.add(item);
    }

    private PortfolioTransaction convertToOutboundDelivery(PortfolioTransaction tx) {
        PortfolioTransaction delivery = new PortfolioTransaction();
        delivery.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
        delivery.setDateTime(tx.getDateTime());
        delivery.setAmount(tx.getAmount());
        delivery.setCurrencyCode(tx.getCurrencyCode());
        delivery.setShares(tx.getShares());
        delivery.setSecurity(tx.getSecurity());
        delivery.setNote(tx.getNote());
        delivery.addUnits(tx.getUnits());
        return delivery;
    }

    private AccountTransaction.Type inferType(String[] rawValues, Map<String, CSVImporter.Column> field2column, Security security, Money amount) throws ParseException {
        AccountTransaction.Type type = this.getEnum(Messages.CSVColumn_Type, AccountTransaction.Type.class, rawValues, field2column);
        if (type == null) {
            type = security != null ? (amount.isNegative() ? AccountTransaction.Type.REMOVAL : AccountTransaction.Type.DIVIDENDS) : (amount.isNegative() ? AccountTransaction.Type.REMOVAL : AccountTransaction.Type.DEPOSIT);
        }
        return type;
    }
}

