/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CSVConfig {
    private String label;
    private String target;
    private char delimiter = (char)59;
    private Charset encoding = Charset.defaultCharset();
    private int skipLines = 0;
    private boolean isFirstLineHeader = true;
    private List<CSVColumnConfig> columns = new ArrayList<CSVColumnConfig>();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void readFrom(CSVImporter importer) {
        this.target = importer.getExtractor().getCode();
        this.delimiter = importer.getDelimiter();
        this.encoding = importer.getEncoding();
        this.skipLines = importer.getSkipLines();
        this.isFirstLineHeader = importer.isFirstLineHeader();
        this.columns.clear();
        CSVImporter.Column[] columnArray = importer.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            CSVImporter.Column column = columnArray[n2];
            CSVColumnConfig copy = new CSVColumnConfig();
            copy.setLabel(column.getLabel());
            CSVImporter.Field field = column.getField();
            if (field != null) {
                copy.setCode(field.getCode());
                CSVImporter.FieldFormat format = column.getFormat();
                if (format != null) {
                    copy.setFormat(field.formatToText(format));
                }
            }
            this.columns.add(copy);
            ++n2;
        }
    }

    public void writeTo(CSVImporter importer) {
        importer.getExtractorByCode(this.target).ifPresent(importer::setExtractor);
        importer.setDelimiter(this.delimiter);
        importer.setEncoding(this.encoding);
        importer.setSkipLines(this.skipLines);
        importer.setFirstLineHeader(this.isFirstLineHeader);
        ArrayList<CSVImporter.Column> setup = new ArrayList<CSVImporter.Column>();
        int index = 0;
        for (CSVColumnConfig column : this.columns) {
            CSVImporter.Column copy = new CSVImporter.Column(index, column.getLabel());
            Optional<CSVImporter.Field> field = importer.getExtractor().getFields().stream().filter(f -> f.getCode().equals(column.getCode())).findAny();
            if (field.isPresent()) {
                copy.setField(field.get());
                String format = column.getFormat();
                if (format != null) {
                    copy.setFormat(field.get().textToFormat(format));
                }
                if (copy.getFormat() == null) {
                    field.get().guessFormat(importer.getClient(), null);
                }
            }
            setup.add(copy);
            ++index;
        }
        importer.setColumns(setup.toArray(new CSVImporter.Column[0]));
    }

    public JSONObject toJSON() {
        JSONObject answer = new JSONObject();
        answer.put((Object)"label", (Object)this.label);
        answer.put((Object)"target", (Object)this.target);
        answer.put((Object)"delimiter", (Object)String.valueOf(this.delimiter));
        answer.put((Object)"encoding", (Object)this.encoding.name());
        answer.put((Object)"skipLines", (Object)this.skipLines);
        answer.put((Object)"isFirstLineHeader", (Object)this.isFirstLineHeader);
        JSONArray columnArray = new JSONArray();
        answer.put((Object)"columns", (Object)columnArray);
        this.columns.stream().map(c -> {
            JSONObject col = new JSONObject();
            col.put((Object)"label", (Object)c.getLabel());
            if (c.getCode() != null) {
                col.put((Object)"field", (Object)c.getCode());
            }
            if (c.getFormat() != null) {
                col.put((Object)"format", (Object)c.getFormat());
            }
            return col;
        }).forEach(arg_0 -> columnArray.add(arg_0));
        return answer;
    }

    public void fromJSON(JSONObject json) {
        this.label = Objects.requireNonNull((String)json.get((Object)"label"), MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "label"));
        this.target = Objects.requireNonNull((String)json.get((Object)"target"), MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "target"));
        int d = Objects.requireNonNull((String)json.get((Object)"delimiter"), MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "delimiter")).charAt(0);
        this.delimiter = (char)(",;\t".indexOf(d) >= 0 ? d : 59);
        try {
            String charsetName = (String)json.get((Object)"encoding");
            if (charsetName != null) {
                this.encoding = Charset.forName(charsetName);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            PortfolioLog.error(e);
            this.encoding = Charset.defaultCharset();
        }
        this.skipLines = Objects.requireNonNull((Long)json.get((Object)"skipLines"), MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "skipLines")).intValue();
        this.isFirstLineHeader = Objects.requireNonNull(Boolean.valueOf((Boolean)json.get((Object)"isFirstLineHeader")), MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "isFirstLineHeader"));
        JSONArray array = (JSONArray)json.get((Object)"columns");
        if (array == null || array.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "columns"));
        }
        this.columns.clear();
        int ii = 0;
        while (ii < array.size()) {
            JSONObject col = (JSONObject)array.get(ii);
            CSVColumnConfig column = new CSVColumnConfig();
            column.setLabel(Objects.requireNonNull((String)col.get((Object)"label"), MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "label")));
            column.setCode((String)col.get((Object)"field"));
            column.setFormat((String)col.get((Object)"format"));
            this.columns.add(column);
            ++ii;
        }
    }

    private static class CSVColumnConfig {
        private String label;
        private String code;
        private String format;

        private CSVColumnConfig() {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    private static interface Key {
        public static final String FIELD = "field";
        public static final String TARGET = "target";
        public static final String LABEL = "label";
        public static final String FORMAT = "format";
        public static final String DELIMITER = "delimiter";
        public static final String ENCODING = "encoding";
        public static final String SKIP_LINES = "skipLines";
        public static final String IS_FIRST_LINE_HEADER = "isFirstLineHeader";
        public static final String COLUMNS = "columns";
    }
}

