/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.datatransfer.csv.CSVConfig;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.extensions.Preference;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.osgi.service.prefs.BackingStoreException;

@Singleton
@Creatable
public class CSVConfigManager {
    @Inject
    @Preference
    private IEclipsePreferences preferences;
    private List<CSVConfig> builtIn = new ArrayList<CSVConfig>();
    private boolean isDirty = false;
    private List<CSVConfig> userSpecific = new ArrayList<CSVConfig>();

    @PostConstruct
    private void loadConfigurations() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Scanner scanner = new Scanner(this.getClass().getResourceAsStream("csv-config.json"), StandardCharsets.UTF_8.name());){
                String json = scanner.useDelimiter("\\A").next();
                this.builtIn.addAll(this.fromJSON(json));
                String saved = this.preferences.get(CSVConfigManager.class.getName(), null);
                if (saved != null) {
                    this.userSpecific.addAll(this.fromJSON(saved));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @PreDestroy
    private void saveConfigurations() {
        if (!this.isDirty) {
            return;
        }
        try {
            JSONArray array = new JSONArray();
            this.userSpecific.forEach(config -> {
                boolean bl = array.add((Object)config.toJSON());
            });
            this.preferences.put(CSVConfigManager.class.getName(), array.toJSONString());
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            PortfolioLog.error(e);
        }
    }

    private List<CSVConfig> fromJSON(String json) throws ParseException {
        JSONArray array = (JSONArray)JSONValue.parseWithException((String)json);
        ArrayList<CSVConfig> answer = new ArrayList<CSVConfig>();
        int ii = 0;
        while (ii < array.size()) {
            try {
                CSVConfig config = new CSVConfig();
                config.fromJSON((JSONObject)array.get(ii));
                answer.add(config);
            }
            catch (Exception e) {
                PortfolioLog.error(e);
            }
            ++ii;
        }
        return answer;
    }

    public List<CSVConfig> getBuiltInConfigurations() {
        return Collections.unmodifiableList(this.builtIn);
    }

    public List<CSVConfig> getUserSpecificConfigurations() {
        return Collections.unmodifiableList(this.userSpecific);
    }

    public void addUserSpecificConfiguration(CSVConfig config) {
        Optional<CSVConfig> previous = this.userSpecific.stream().filter(c -> config.getLabel().equals(c.getLabel())).findAny();
        if (previous.isPresent()) {
            this.userSpecific.remove(previous.get());
        }
        this.userSpecific.add(config);
        this.isDirty = true;
    }

    public void removeUserSpecificConfiguration(CSVConfig config) {
        this.userSpecific.remove(config);
        this.isDirty = true;
    }
}

