/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.BaseCSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.Money;

class CSVPortfolioExtractor
extends BaseCSVExtractor {
    CSVPortfolioExtractor(Client client) {
        super(client, Messages.CSVDefPortfolio);
        List<CSVImporter.Field> fields = this.getFields();
        fields.add(new CSVImporter.DateField("date", Messages.CSVColumn_DateValue).setOptional(true));
        fields.add(new CSVImporter.Field("time", Messages.CSVColumn_Time).setOptional(true));
        fields.add(new CSVImporter.ISINField("isin", Messages.CSVColumn_ISIN).setOptional(true));
        fields.add(new CSVImporter.Field("ticker", Messages.CSVColumn_TickerSymbol).setOptional(true));
        fields.add(new CSVImporter.Field("wkn", Messages.CSVColumn_WKN).setOptional(true));
        fields.add(new CSVImporter.Field("name", Messages.CSVColumn_SecurityName).setOptional(true));
        fields.add(new CSVImporter.AmountField("value", Messages.CSVColumn_Value));
        fields.add(new CSVImporter.Field("currency", Messages.CSVColumn_Currency).setOptional(true));
        fields.add(new CSVImporter.AmountField("shares", Messages.CSVColumn_Shares));
        fields.add(new CSVImporter.Field("note", Messages.CSVColumn_Note).setOptional(true));
        fields.add(new CSVImporter.DateField("date-quote", Messages.CSVColumn_DateQuote).setOptional(true));
        fields.add(new CSVImporter.AmountField("quote", Messages.CSVColumn_Quote, "Schluss", "Schlusskurs", "Close").setOptional(true));
        fields.add(new CSVImporter.Field("account", Messages.CSVColumn_AccountName).setOptional(true));
        fields.add(new CSVImporter.Field("portfolio", Messages.CSVColumn_PortfolioName).setOptional(true));
    }

    @Override
    public String getCode() {
        return "portfolio";
    }

    @Override
    void extract(List<Extractor.Item> items, String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        Security security = this.getSecurity(rawValues, field2column, s -> {
            String currency = this.getText(Messages.CSVColumn_Currency, rawValues, field2column);
            if (currency != null) {
                CurrencyUnit unit = CurrencyUnit.getInstance(currency.trim());
                s.setCurrencyCode(unit == null ? this.getClient().getBaseCurrency() : unit.getCurrencyCode());
            }
        });
        if (security == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingSecurity, new StringJoiner(", ").add(Messages.CSVColumn_ISIN).add(Messages.CSVColumn_TickerSymbol).add(Messages.CSVColumn_WKN).toString()), 0);
        }
        Money valuation = this.getMoney(Messages.CSVColumn_Value, Messages.CSVColumn_Currency, rawValues, field2column);
        Long shares = this.getShares(Messages.CSVColumn_Shares, rawValues, field2column);
        if (shares == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Shares), 0);
        }
        LocalDateTime date = this.getDate(Messages.CSVColumn_DateValue, Messages.CSVColumn_Time, rawValues, field2column);
        if (date == null) {
            date = LocalDate.now().atStartOfDay();
        }
        String note = this.getText(Messages.CSVColumn_Note, rawValues, field2column);
        Account account = this.getAccount(this.getClient(), rawValues, field2column);
        Portfolio portfolio = this.getPortfolio(this.getClient(), rawValues, field2column);
        BuySellEntry entry = new BuySellEntry();
        entry.setType(PortfolioTransaction.Type.BUY);
        entry.setSecurity(security);
        entry.setDate(date);
        entry.setAmount(Math.abs(valuation.getAmount()));
        entry.setCurrencyCode(valuation.getCurrencyCode());
        entry.setShares(shares);
        entry.setNote(note);
        Extractor.BuySellEntryItem item = new Extractor.BuySellEntryItem(entry);
        item.setAccountPrimary(account);
        item.setPortfolioPrimary(portfolio);
        items.add(item);
        this.getSecurityPrice(Messages.CSVColumn_DateQuote, rawValues, field2column).ifPresent(price -> {
            boolean bl = items.add(new Extractor.SecurityPriceItem(security, (SecurityPrice)price));
        });
    }
}

