/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.BaseCSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;

class CSVSecurityExtractor
extends BaseCSVExtractor {
    CSVSecurityExtractor(Client client) {
        super(client, Messages.CSVDefSecurities);
        List<CSVImporter.Field> fields = this.getFields();
        fields.add(new CSVImporter.Field("isin", Messages.CSVColumn_ISIN).setOptional(true));
        fields.add(new CSVImporter.Field("wkn", Messages.CSVColumn_WKN).setOptional(true));
        fields.add(new CSVImporter.Field("ticker", Messages.CSVColumn_TickerSymbol).setOptional(true));
        fields.add(new CSVImporter.Field("name", Messages.CSVColumn_SecurityName).setOptional(true));
        fields.add(new CSVImporter.Field("currency", Messages.CSVColumn_Currency).setOptional(true));
        fields.add(new CSVImporter.Field("note", Messages.CSVColumn_Note).setOptional(true));
        fields.add(new CSVImporter.DateField("date", Messages.CSVColumn_DateQuote).setOptional(true));
        fields.add(new CSVImporter.AmountField("quote", Messages.CSVColumn_Quote, "Schluss", "Schlusskurs", "Close").setOptional(true));
    }

    @Override
    public String getCode() {
        return "investment-vehicle";
    }

    @Override
    void extract(List<Extractor.Item> items, String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        Security security = this.getSecurity(rawValues, field2column, s -> {
            s.setCurrencyCode(this.getCurrencyCode(Messages.CSVColumn_Currency, rawValues, field2column));
            String note = this.getText(Messages.CSVColumn_Note, rawValues, field2column);
            s.setNote(note);
            if (s.getTickerSymbol() != null) {
                s.setFeed("YAHOO");
            }
            items.add(new Extractor.SecurityItem((Security)s));
        });
        if (security == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingSecurity, new StringJoiner(", ").add(Messages.CSVColumn_ISIN).add(Messages.CSVColumn_TickerSymbol).add(Messages.CSVColumn_WKN).toString()), 0);
        }
        this.getSecurityPrice(Messages.CSVColumn_DateQuote, rawValues, field2column).ifPresent(price -> {
            boolean bl = items.add(new Extractor.SecurityPriceItem(security, (SecurityPrice)price));
        });
    }
}

