/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.SecurityCache;
import name.abuchen.portfolio.datatransfer.pdf.PDFInputFile;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.Values;

public abstract class AbstractPDFExtractor
implements Extractor {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("d.M.yyyy", Locale.GERMANY);
    private static final DateTimeFormatter DATE_FORMAT_DASHES = DateTimeFormatter.ofPattern("yyyy-M-d", Locale.GERMANY);
    private static final DateTimeFormatter DATE_FORMAT_DASHES_REVERSE = DateTimeFormatter.ofPattern("d-M-yyyy", Locale.GERMANY);
    private static final DateTimeFormatter DATE_TIME_SECONDS_FORMAT = DateTimeFormatter.ofPattern("d.M.yyyy HH:mm", Locale.GERMANY);
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("d.M.yyyy HH:mm:ss", Locale.GERMANY);
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.GERMANY);
    private final Client client;
    private SecurityCache securityCache;
    private final List<String> bankIdentifier = new ArrayList<String>();
    private final List<PDFParser.DocumentType> documentTypes = new ArrayList<PDFParser.DocumentType>();

    public AbstractPDFExtractor(Client client) {
        this.client = client;
    }

    public final Client getClient() {
        return this.client;
    }

    protected final void addDocumentTyp(PDFParser.DocumentType type) {
        this.documentTypes.add(type);
    }

    protected final void addBankIdentifier(String identifier) {
        this.bankIdentifier.add(identifier);
    }

    public List<String> getBankIdentifier() {
        return this.bankIdentifier;
    }

    public String getPDFAuthor() {
        return null;
    }

    @Override
    public List<Extractor.Item> extract(SecurityCache securityCache, Extractor.InputFile inputFile, List<Exception> errors) {
        this.securityCache = securityCache;
        ArrayList<Extractor.Item> results = new ArrayList<Extractor.Item>();
        if (!(inputFile instanceof PDFInputFile)) {
            throw new IllegalArgumentException();
        }
        String text = ((PDFInputFile)inputFile).getText();
        results.addAll(this.extract(inputFile.getFile().getName(), text, errors));
        this.securityCache = null;
        return results;
    }

    private final List<Extractor.Item> extract(String filename, String text, List<Exception> errors) {
        try {
            this.checkBankIdentifier(filename, text);
            List<Extractor.Item> items = this.parseDocumentTypes(this.documentTypes, filename, text);
            if (items.isEmpty()) {
                errors.add(new UnsupportedOperationException(MessageFormat.format(Messages.PDFdbMsgCannotDetermineFileType, this.getLabel(), filename)));
            }
            for (Extractor.Item item : items) {
                if (item.getSubject().getNote() == null) {
                    item.getSubject().setNote(filename);
                    continue;
                }
                item.getSubject().setNote(item.getSubject().getNote().concat(" | ").concat(filename));
            }
            return items;
        }
        catch (IllegalArgumentException e) {
            errors.add(new IllegalArgumentException(String.valueOf(e.getMessage()) + " @ " + filename, e));
            return Collections.emptyList();
        }
        catch (NullPointerException e) {
            IllegalArgumentException error = new IllegalArgumentException("NullPointerException @ " + filename, e);
            PortfolioLog.error(error);
            errors.add(error);
            return Collections.emptyList();
        }
        catch (UnsupportedOperationException e) {
            errors.add(e);
            return Collections.emptyList();
        }
    }

    protected final List<Extractor.Item> parseDocumentTypes(List<PDFParser.DocumentType> documentTypes, String filename, String text) {
        ArrayList<Extractor.Item> items = new ArrayList<Extractor.Item>();
        for (PDFParser.DocumentType type : documentTypes) {
            if (!type.matches(text)) continue;
            type.parse(filename, items, text);
        }
        return items;
    }

    private void checkBankIdentifier(String filename, String text) {
        if (this.bankIdentifier.isEmpty()) {
            this.bankIdentifier.add(this.getLabel());
        }
        for (String identifier : this.bankIdentifier) {
            if (!text.contains(identifier)) continue;
            return;
        }
        throw new UnsupportedOperationException(MessageFormat.format(Messages.PDFMsgFileNotSupported, filename, this.getLabel()));
    }

    protected Security getOrCreateSecurity(Map<String, String> values) {
        Security security;
        String nameRowTwo;
        String name;
        String wkn;
        String tickerSymbol;
        String isin = values.get("isin");
        if (isin != null) {
            isin = isin.trim();
        }
        if ((tickerSymbol = values.get("tickerSymbol")) != null) {
            tickerSymbol = tickerSymbol.trim();
        }
        if ((wkn = values.get("wkn")) != null) {
            wkn = wkn.trim();
        }
        if ((name = values.get("name")) != null) {
            name = name.trim();
        }
        if ((nameRowTwo = values.get("nameContinued")) != null) {
            name = String.valueOf(name) + " " + nameRowTwo.trim();
        }
        if ((security = this.securityCache.lookup(isin, tickerSymbol, wkn, name, () -> {
            Security s = new Security();
            s.setCurrencyCode(this.asCurrencyCode((String)values.get("currency")));
            return s;
        })) == null) {
            throw new IllegalArgumentException("Unable to construct security: " + values.toString());
        }
        return security;
    }

    protected long asShares(String value) {
        try {
            return Math.round(this.numberFormat.parse(value).doubleValue() * (double)Values.Share.factor());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String asCurrencyCode(String currency) {
        if (currency == null) {
            return this.client.getBaseCurrency();
        }
        CurrencyUnit unit = CurrencyUnit.getInstance(currency.trim());
        return unit == null ? this.client.getBaseCurrency() : unit.getCurrencyCode();
    }

    long asAmount(String value) {
        try {
            return Math.abs(Math.round(this.numberFormat.parse(value).doubleValue() * (double)Values.Amount.factor()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    BigDecimal asExchangeRate(String value) {
        try {
            return BigDecimal.valueOf(this.numberFormat.parse(value).doubleValue());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    LocalDateTime asDate(String value) {
        LocalDateTime date = null;
        try {
            date = LocalDate.parse(value, DATE_FORMAT).atStartOfDay();
        }
        catch (DateTimeParseException e1) {
            try {
                date = LocalDate.parse(value, DATE_FORMAT_DASHES).atStartOfDay();
            }
            catch (DateTimeParseException e2) {
                date = LocalDate.parse(value, DATE_FORMAT_DASHES_REVERSE).atStartOfDay();
            }
        }
        return date;
    }

    LocalTime asTime(String value) {
        LocalTime time = null;
        try {
            time = LocalTime.parse(value, DateTimeFormatter.ofPattern("HH:mm"));
        }
        catch (DateTimeParseException e) {
            time = LocalTime.parse(value, DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        return time.withSecond(0);
    }

    LocalDateTime asDate(String date, String time) {
        try {
            return LocalDateTime.parse(String.format("%s %s", date, time), DATE_TIME_SECONDS_FORMAT);
        }
        catch (Exception e) {
            return LocalDateTime.parse(String.format("%s %s", date, time), DATE_TIME_FORMAT);
        }
    }
}

