/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;

public class BondoraGoAndGrowPDFExtractor
extends AbstractPDFExtractor {
    static String ACCOUNT_STATEMENT_DOCUMENT_TYPE = "(Zusammenfassung|Summary)";
    static String ACCOUNT_STATEMENT_TRANSACTION_REGEX = "^(?<date>\\d{2}.\\d{2}.\\d{4}|\\d{4}.\\d{2}.\\d{2})\\s(?<kind>[^\u20ac\\d]*)(\\s[\u20ac]\\D|\\D)(?<amount>[\\d\\s.']+(,\\d+)?)(\\D*)([\\d\\s.']+(,\\d+)*)(.{2})?$";
    static String BANK_IDENTIFIER = "Go & Grow";

    public BondoraGoAndGrowPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier(BANK_IDENTIFIER);
        this.addAccountStatementTransaction();
    }

    private void addAccountStatementTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType(ACCOUNT_STATEMENT_DOCUMENT_TYPE);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(ACCOUNT_STATEMENT_TRANSACTION_REGEX);
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.INTEREST);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("date", "kind", "amount").match(ACCOUNT_STATEMENT_TRANSACTION_REGEX).assign((t, v) -> {
            block20: {
                t.setDateTime(this.asDate((String)v.get("date")));
                t.setAmount(this.asAmount(((String)v.get("amount")).replace(' ', '.')));
                t.setCurrencyCode("EUR");
                String kind = (String)v.get("kind");
                if (kind.endsWith(" ")) {
                    kind = kind.substring(0, kind.length() - 1);
                }
                if (kind == null) break block20;
                switch (kind) {
                    case "\u00dcberweisen": 
                    case "Transfer": {
                        t.setType(AccountTransaction.Type.DEPOSIT);
                        break;
                    }
                    case "Withdrawal": 
                    case "Abheben": {
                        t.setType(AccountTransaction.Type.REMOVAL);
                        break;
                    }
                    case "Go & Grow Zinsen": 
                    case "Go & Grow returns": {
                        t.setType(AccountTransaction.Type.INTEREST);
                        break;
                    }
                }
            }
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t));
    }

    @Override
    public String getLabel() {
        return "Bondora";
    }
}

