/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class CommerzbankPDFExtractor
extends AbstractPDFExtractor {
    public CommerzbankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("C O M M E R Z B A N K");
        this.addBankIdentifier("Commerzbank AG");
        this.addBuyTransaction();
        this.addDividendTransaction();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("W e r t p a p i e r k a u f");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("W e r t p a p i e r k a u f");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("amount", "currency").match(".*Zu I h r e n L a s t e n.*").match("^.* (\\d \\d . \\d \\d . \\d \\d \\d \\d) (?<currency>\\w{3}+)(?<amount>( \\d)*( \\.)?( \\d)* ,( \\d)*)$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount(this.stripBlanks((String)v.get("amount"))));
        }).section("date").match("G e s c h \u00e4 f t s t a g : (?<date>\\d \\d . \\d \\d . \\d \\d \\d \\d) .*").assign((t, v) -> t.setDate(this.asDate(this.stripBlanks((String)v.get("date"))))).section("shares").match("S t . (?<shares>[\\d ,.]*) .*").assign((t, v) -> t.setShares(this.asShares(this.stripBlanks((String)v.get("shares"))))).section("wkn", "name", "isin", "currency").match(".*W e r t p a p i e r - B e z e i c h n u n g.*").match("(?<name>.*) (?<wkn>\\S*)").match("^IBAN.*$").match("^(?<isin>.*) (?<currency>\\w{3}+) (\\d \\d . \\d \\d . \\d \\d \\d \\d) (\\w{3}+)(( \\d)*( \\.)?( \\d)* ,( \\d)*)$").assign((t, v) -> {
            v.put("isin", this.stripBlanks((String)v.get("isin")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type1 = new PDFParser.DocumentType("E r t r a g s g u t s c h r i f t");
        this.addDocumentTyp(type1);
        PDFParser.Block block1 = new PDFParser.Block("E r t r a g s g u t s c h r i f t");
        type1.addBlock(block1);
        block1.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("date", "amount", "currency").match(".*Zu I h r e n Gunsten.*").match("^.* (?<date>\\d \\d . \\d \\d . \\d \\d \\d \\d) (?<currency>\\w{3}+)(?<amount>( \\d)*( \\.)?( \\d)* ,( \\d)*)$").assign((t, v) -> {
            t.setDateTime(this.asDate(this.stripBlanks((String)v.get("date"))));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount(this.stripBlanks((String)v.get("amount"))));
        }).section("wkn", "name", "shares", "isin").match(".*W e r t p a p i e r - B e z e i c h n u n g.*").match("p e r \\d \\d . \\d \\d . \\d \\d \\d \\d (?<name>.*) (?<wkn>\\S*)").match("^STK (?<shares>(\\d )*(\\. )?(\\d )*, (\\d )*).* (?<isin>\\S*)$").assign((t, v) -> {
            v.put("currency", t.getCurrencyCode());
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares(this.stripBlanks((String)v.get("shares"))));
        }).wrap(Extractor.TransactionItem::new));
        PDFParser.DocumentType type2 = new PDFParser.DocumentType("D i v i d e n d e n g u t s c h r i f t");
        this.addDocumentTyp(type2);
        PDFParser.Block block2 = new PDFParser.Block("D i v i d e n d e n g u t s c h r i f t");
        type2.addBlock(block2);
        block2.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("date", "amount", "currency").match(".*Zu I h r e n Gunsten.*").match("^.* (?<date>\\d \\d . \\d \\d . \\d \\d \\d \\d) (?<currency>\\w{3}+)(?<amount>( \\d)*( \\.)?( \\d)* ,( \\d)*)$").assign((t, v) -> {
            t.setDateTime(this.asDate(this.stripBlanks((String)v.get("date"))));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount(this.stripBlanks((String)v.get("amount"))));
        }).section("wkn", "name", "shares", "isin").match(".*WKN/ISIN.*").match("p e r \\d \\d . \\d \\d . \\d \\d \\d \\d\\s*(?<name>.*) (?<wkn>\\S*)$").match("^STK (?<shares>(\\d )*(\\. )?(\\d )*, (\\d )*).* (?<isin>\\S*)$").assign((t, v) -> {
            v.put("currency", t.getCurrencyCode());
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares(this.stripBlanks((String)v.get("shares"))));
        }).wrap(Extractor.TransactionItem::new));
        PDFParser.DocumentType type3 = new PDFParser.DocumentType(".*Steuerliche Behandlung:.*Dividende.*");
        this.addDocumentTyp(type3);
        PDFParser.Block block3 = new PDFParser.Block("Steuerliche Behandlung:.*Dividende.*");
        type3.addBlock(block3);
        block3.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("date").match("Die Gutschrift erfolgt mit Valuta\\s*(?<date>\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d).*").assign((t, v) -> t.setDateTime(this.asDate(this.stripBlanks((String)v.get("date"))))).section("amount", "currency", "tax1", "tax2").match("^Kapitalertragsteuer \\s*(?<currency>\\w{3}+)(?<tax1>( -)?( \\d)*( \\.)?( \\d)* ,( \\d)*).*$").match("^Solidarit\u00e4tszuschlag \\s*(?<currency>\\w{3}+)(?<tax2>( -)?( \\d)*( \\.)?( \\d)* ,( \\d)*).*$").match("^Zu Ihren Gunsten nach Steuern: \\s*(?<currency>\\w{3}+)(?<amount>( \\d)*( \\.)?( \\d)* ,( \\d)*).*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount(this.stripBlanks((String)v.get("amount"))));
            long tax1 = this.asAmount(this.stripBlanks((String)v.get("tax1")));
            long tax2 = this.asAmount(this.stripBlanks((String)v.get("tax2")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), tax1 + tax2)));
        }).section("wkn", "shares", "isin", "name").match("^.*Stk\\. (?<shares>([\\d\\.])*) (?<name>.*) , WKN \\/ ISIN: (?<wkn>\\S*) \\/ (?<isin>\\S*).*$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares(this.stripDots(this.stripBlanks((String)v.get("shares")))));
        }).wrap(Extractor.TransactionItem::new));
    }

    private String stripBlanks(String input) {
        return input.replaceAll("\\s", "");
    }

    private String stripDots(String input) {
        return input.replaceAll("\\.", "");
    }

    @Override
    public String getLabel() {
        return "Commerzbank";
    }
}

