/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class DegiroPDFExtractor
extends AbstractPDFExtractor {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm", Locale.GERMANY);

    public DegiroPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("DEGIRO");
        this.addBankAccountTransactions();
        this.addPortfolioTransactions();
    }

    private void addBankAccountTransactions() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kontoauszug", (context, lines) -> {
            Pattern pCurrencyFx = Pattern.compile("(?<date>\\d+-\\d+-\\d{4}) (?:\\d+:\\d+) (?<valuta>\\d+-\\d+-\\d{4} )?W\u00e4hrungswechsel.* (?<fxRate>[.\\d]+,\\d+) (?<currency>\\w{3}) -?(?<amount>[.\\d]+,\\d+) (\\w{3}) .*");
            Pattern pCurrencyBase = Pattern.compile("(\\d+-\\d+-\\d{4}) (?:\\d+:\\d+) (?:\\d+-\\d+-\\d{4} )?W\u00e4hrungswechsel.* (?<currency>\\w{3}) -?(?<amount>[.\\d]+,\\d+) (\\w{3}).*");
            int i = 10;
            while (i < ((String[])lines).length) {
                Matcher mFx = pCurrencyFx.matcher(lines[i]);
                if (mFx.matches()) {
                    Matcher mBase;
                    StringBuilder contextEntryKey = new StringBuilder("exchange_");
                    contextEntryKey.append(mFx.group("date")).append("_");
                    if (mFx.group("valuta") != null) {
                        contextEntryKey.append(mFx.group("valuta").trim()).append("_");
                    }
                    if (!mFx.group("currency").equalsIgnoreCase(this.getClient().getBaseCurrency())) {
                        contextEntryKey.append(mFx.group("currency")).append("_");
                        contextEntryKey.append(mFx.group("fxRate")).append("_");
                        mBase = pCurrencyBase.matcher(lines[i - 1]);
                        if (mBase.matches() && mBase.group("currency").equalsIgnoreCase(this.getClient().getBaseCurrency())) {
                            contextEntryKey.append(mBase.group("amount"));
                            context.put(contextEntryKey.toString(), mFx.group("amount"));
                        }
                    } else {
                        mBase = pCurrencyBase.matcher(lines[i - 2]);
                        if (mBase.matches() && !mBase.group("currency").equalsIgnoreCase(this.getClient().getBaseCurrency())) {
                            contextEntryKey.append(mBase.group("currency")).append("_");
                            contextEntryKey.append(mFx.group("fxRate")).append("_");
                            contextEntryKey.append(mFx.group("amount"));
                            context.put(contextEntryKey.toString(), mBase.group("amount"));
                        }
                    }
                }
                ++i;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block blockDeposit = new PDFParser.Block("^.* Einzahlung .*$");
        type.addBlock(blockDeposit);
        blockDeposit.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DEPOSIT);
            return t;
        }).section("date", "currency", "amount").match("(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?(SOFORT )?Einzahlung (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d{2}) .*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block blockRemoval = new PDFParser.Block("^.* Auszahlung .*$");
        type.addBlock(blockRemoval);
        blockRemoval.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.REMOVAL);
            return t;
        }).section("date", "currency", "amount").match("(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?Auszahlung (?<currency>\\w{3}) -?(?<amount>[\\d.]+,\\d{2}) .*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block blockDividends = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ (\\d+-\\d+-\\d{4} )?.*Dividende .*");
        type.addBlock(blockDividends);
        blockDividends.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("date", "name", "isin", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?(?<name>.*) (?<isin>\\w{12}+) (Dividende|Fondsaussch\u00fcttung) (?<currency>\\w{3}) -?(?<amount>[\\d.]+,\\d{2}) (\\w{3}).*$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDateTime(this.asDate((String)v.get("date")));
            Map<String, String> context = type.getCurrentContext();
            FxChange fxChange = this.getFxChangeFromContext(context, (String)v.get("date"), (String)v.get("currency"), (String)v.get("amount"));
            if (!((String)v.get("currency")).equalsIgnoreCase(this.getClient().getBaseCurrency()) && fxChange != null) {
                String currencyCodeFx = this.asCurrencyCode(fxChange.getMoney().getCurrencyCode());
                t.setAmount(this.asAmount(fxChange.getAmountBase()));
                t.setCurrencyCode(this.getClient().getBaseCurrency());
                BigDecimal exchangeRate = this.asExchangeRate(fxChange.getExchangeRate());
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long partialAmountDividend = inverseRate.multiply(BigDecimal.valueOf(this.asAmount((String)v.get("amount")))).setScale(0, RoundingMode.HALF_DOWN).longValue();
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(this.getClient().getBaseCurrency(), partialAmountDividend), Money.of(currencyCodeFx, this.asAmount((String)v.get("amount"))), inverseRate));
                context.put("FX_RATE_FOR_TAX_FEES", fxChange.getExchangeRate());
            } else if (((String)v.get("currency")).equalsIgnoreCase(this.getClient().getBaseCurrency())) {
                t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
                t.setAmount(this.asAmount((String)v.get("amount")));
            }
        }).section("isin", "currencyTax", "tax").optional().match("^(\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?(.*) (?<isin>\\w{12}+) .*Dividendensteuer\\s(?<currencyTax>\\w{3}) -?(?<tax>[\\d.]+,\\d{2}) (\\w{3}).*$").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            if (!((String)v.get("currencyTax")).equalsIgnoreCase(this.getClient().getBaseCurrency()) && context.get("FX_RATE_FOR_TAX_FEES") != null && ((String)v.get("isin")).equalsIgnoreCase(t.getSecurity().getIsin())) {
                BigDecimal exchangeRate = this.asExchangeRate(context.get("FX_RATE_FOR_TAX_FEES"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                String currencyCodeFx = this.asCurrencyCode((String)v.get("currencyTax"));
                Money mTaxesFx = Money.of(currencyCodeFx, this.asAmount((String)v.get("tax")));
                long taxesFxInEUR = BigDecimal.valueOf(mTaxesFx.getAmount()).divide(exchangeRate, 10, RoundingMode.HALF_DOWN).setScale(0, RoundingMode.HALF_DOWN).longValue();
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(t.getCurrencyCode(), taxesFxInEUR), mTaxesFx, inverseRate));
            } else if (((String)v.get("currencyTax")).equalsIgnoreCase(this.getClient().getBaseCurrency())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currencyTax")), this.asAmount((String)v.get("tax")))));
            }
        }).section("isin", "currencyFee", "feeFx").optional().match("^(\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?(.*) (?<isin>\\w{12}+) ADR/GDR Weitergabegeb\u00fchr (?<currencyFee>\\w{3}) -?(?<feeFx>[\\d.]+,\\d{2}) .*$").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            if (!((String)v.get("currencyFee")).equalsIgnoreCase(this.getClient().getBaseCurrency()) && context.get("FX_RATE_FOR_TAX_FEES") != null && ((String)v.get("isin")).equalsIgnoreCase(t.getSecurity().getIsin())) {
                BigDecimal exchangeRate = this.asExchangeRate(context.get("FX_RATE_FOR_TAX_FEES"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                String currencyCodeFx = this.asCurrencyCode((String)v.get("currencyFee"));
                Money mFeesFx = Money.of(currencyCodeFx, this.asAmount((String)v.get("feeFx")));
                long feesFxInEUR = BigDecimal.valueOf(mFeesFx.getAmount()).divide(exchangeRate, 10, RoundingMode.HALF_DOWN).setScale(0, RoundingMode.HALF_DOWN).longValue();
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(t.getCurrencyCode(), feesFxInEUR), mFeesFx, inverseRate));
            } else if (((String)v.get("currencyFee")).equalsIgnoreCase(this.getClient().getBaseCurrency())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currencyFee")), this.asAmount((String)v.get("feeFx")))));
            }
        }).wrap(t -> {
            type.getCurrentContext().remove("FX_RATE_FOR_TAX_FEES");
            Optional<Transaction.Unit> grossValue = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            Optional<Transaction.Unit> feesAndTaxesValue = t.getUnits().filter(u -> u.getType() == Transaction.Unit.Type.TAX || u.getType() == Transaction.Unit.Type.FEE).findAny();
            if (grossValue.isPresent() && feesAndTaxesValue.isPresent()) {
                long feesAndTaxes;
                long net = t.getAmount();
                long gross = grossValue.get().getAmount().getAmount();
                long delta = gross - (feesAndTaxes = t.getUnits().filter(u -> u.getType() == Transaction.Unit.Type.TAX || u.getType() == Transaction.Unit.Type.FEE).mapToLong(u -> u.getAmount().getAmount()).sum()) - net;
                if (delta == 1L || delta == -1L) {
                    Transaction.Unit unit = t.getUnits().filter(u -> u.getType() == Transaction.Unit.Type.TAX || u.getType() == Transaction.Unit.Type.FEE).filter(u -> u.getExchangeRate() != null).findFirst().orElseThrow(IllegalArgumentException::new);
                    t.removeUnit(unit);
                    long amountPlusDelta = unit.getAmount().getAmount() + delta;
                    long forexPlusDelta = BigDecimal.ONE.divide(unit.getExchangeRate(), 10, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(amountPlusDelta)).setScale(0, RoundingMode.HALF_DOWN).longValue();
                    Transaction.Unit newUnit = new Transaction.Unit(unit.getType(), Money.of(unit.getAmount().getCurrencyCode(), amountPlusDelta), Money.of(unit.getForex().getCurrencyCode(), forexPlusDelta), unit.getExchangeRate());
                    t.addUnit(newUnit);
                }
            }
            if (t.getCurrencyCode() != null && t.getAmount() != 0L) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        }));
        PDFParser.Block blockInterest = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ (\\d+-\\d+-\\d{4} )?.*Zinsen .*");
        type.addBlock(blockInterest);
        blockInterest.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.INTEREST_CHARGE);
            return t;
        }).section("date", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?.*Zinsen (f\u00fcr Leerverkauf )?(?<currency>\\w{3}) -?(?<amount>[\\d.]+,\\d{2}).*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block blockDepositFee = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ (\\d+-\\d+-\\d{4} )?SOFORT Zahlungsgeb.*hr.*$");
        type.addBlock(blockDepositFee);
        blockDepositFee.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("date", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?SOFORT Zahlungsgeb.*hr (?<currency>\\w{3}) -?(?<amount>[\\d.]+,\\d{2}) .*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block blockTrademodalities = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ (\\d+-\\d+-\\d{4} )?.*Einrichtung von .*$");
        type.addBlock(blockTrademodalities);
        blockTrademodalities.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).oneOf(section -> section.attributes("date", "currency", "type", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?.*Einrichtung von (?<currency>\\w{3})(?<type>\\s-?)(?<amount>[\\d.]+,\\d{2}) (\\w{3}) .*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            if (" ".equalsIgnoreCase((String)v.get("type"))) {
                t.setType(AccountTransaction.Type.FEES_REFUND);
            }
        }), section -> section.attributes("date", "currency", "type", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?.*Einrichtung von Handelsmodalit.* (?<currency>\\w{3})(?<type>\\s-?)(?<amount>[\\d.]+,\\d{2}) (\\w{3}) .*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            if (" ".equalsIgnoreCase((String)v.get("type"))) {
                t.setType(AccountTransaction.Type.FEES_REFUND);
            }
        })).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block blockFeeStrike = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ (\\d+-\\d+-\\d{4} )?.*Geb\u00fchr.* (Aus\u00fcbung|Zuteilung).*$");
        type.addBlock(blockFeeStrike);
        blockFeeStrike.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("date", "name", "isin", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?(?<name>.*) (?<isin>\\w{12}+) .*Geb\u00fchr.* (Aus\u00fcbung|Zuteilung).*(?<currency>\\w{3}) -?(?<amount>[\\d.]+,\\d{2}) .*$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block blockFeeReturn = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ (\\d+-\\d+-\\d{4} )?(Rabatt|Gutschrift).*$");
        type.addBlock(blockFeeReturn);
        blockFeeReturn.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES_REFUND);
            return t;
        }).section("date", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (\\d+-\\d+-\\d{4} )?(Rabatt|Gutschrift) .* (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d{2}) .*$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private FxChange getFxChangeFromContext(Map<String, String> fxContextMap, String date, String currencyCode, String amountFx) {
        String dateOnly = date.substring(0, date.indexOf(" "));
        for (String key : fxContextMap.keySet()) {
            String[] parts = key.split("_");
            if (!parts[0].equalsIgnoreCase("exchange")) continue;
            if (parts[2].equalsIgnoreCase(currencyCode) && (parts[1].equalsIgnoreCase(dateOnly) || fxContextMap.get(key).equalsIgnoreCase(amountFx))) {
                return new FxChange(Money.of(currencyCode, this.asAmount(fxContextMap.get(key))), parts[3], parts[4]);
            }
            if (!parts[3].equalsIgnoreCase(currencyCode) || !parts[1].equalsIgnoreCase(dateOnly) && !parts[2].equalsIgnoreCase(dateOnly)) continue;
            return new FxChange(Money.of(currencyCode, this.asAmount(fxContextMap.get(key))), parts[4], parts[5]);
        }
        return null;
    }

    private void addPortfolioTransactions() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Transaktions\u00fcbersicht|Transacciones|Transacties");
        this.addDocumentTyp(type);
        PDFParser.Block blockBuy = new PDFParser.Block("^\\d+-\\d+-\\d{4} \\d+:\\d+ .* \\w{12}+ .* \\w{3}+ .*[.\\d]+,\\d{2}$");
        type.addBlock(blockBuy);
        blockBuy.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).oneOf(section -> section.attributes("date", "name", "isin", "shares", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (?<name>.*) (?<isin>\\w{12}+) \\w{3} (?<shares>[-]?[.\\d]+[,\\d]*) \\w{3} [-.,\\d]* \\w{3} [-.,\\d]* \\w{3} [-.,\\d]* (?<currency>\\w{3}) -?(?<amount>[.,\\d]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDate(this.asDate((String)v.get("date")));
            if (((String)v.get("shares")).startsWith("-")) {
                t.setType(PortfolioTransaction.Type.SELL);
                t.setShares(this.asShares(((String)v.get("shares")).replaceFirst("-", "")));
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }), section -> section.attributes("date", "name", "isin", "shares", "currencyFee", "fee", "currency", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (?<name>.*) (?<isin>\\w{12}+) \\w{3} (?<shares>[-]?[.\\d]+[,\\d]*) \\w{3} [-.,\\d]* \\w{3} [-.,\\d]* \\w{3} [-.,\\d]* (?<currencyFee>\\w{3}) -?(?<fee>[.,\\d]*) (?<currency>\\w{3}) -?(?<amount>[.,\\d]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDate(this.asDate((String)v.get("date")));
            if (((String)v.get("shares")).startsWith("-")) {
                t.setType(PortfolioTransaction.Type.SELL);
                t.setShares(this.asShares(((String)v.get("shares")).replaceFirst("-", "")));
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            Money feeAmount = Money.of(this.asCurrencyCode((String)v.get("currencyFee")), this.asAmount((String)v.get("fee")));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, feeAmount));
        }), section -> section.attributes("date", "name", "isin", "shares", "currency", "amountFx", "exchangeRate", "currencyFee", "fee", "currencyAccount", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (?<name>.*) (?<isin>\\w{12}+) \\w{3} (?<shares>[-]?[.\\d]+[,\\d]*) \\w{3} -?[.\\d]+,\\d{2,4} (?<currency>\\w{3}) -?(?<amountFx>[.\\d]+,\\d{2}).* \\w{3} -?[.\\d]+,\\d{2} (?<exchangeRate>[.\\d]+,\\d{1,6}) (?<currencyFee>\\w{3}) (?<fee>-?[.\\d]+,\\d{2}) (?<currencyAccount>\\w{3}) -?(?<amount>[.\\d]+,\\d{2})$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDate(this.asDate((String)v.get("date")));
            if (((String)v.get("shares")).startsWith("-")) {
                t.setType(PortfolioTransaction.Type.SELL);
                t.setShares(this.asShares(((String)v.get("shares")).replaceFirst("-", "")));
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currencyAccount")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            Money feeAmount = Money.of(this.asCurrencyCode((String)v.get("currencyFee")), this.asAmount((String)v.get("fee")));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, feeAmount));
            long amountFx = this.asAmount((String)v.get("amountFx"));
            String currencyFx = this.asCurrencyCode((String)v.get("currency"));
            if (currencyFx.equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                Money amount = Money.of(this.asCurrencyCode((String)v.get("currencyAccount")), this.asAmount((String)v.get("amount")));
                amount = t.getPortfolioTransaction().getType() == PortfolioTransaction.Type.BUY ? amount.subtract(feeAmount) : amount.add(feeAmount);
                BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_DOWN);
                Money forex = Money.of(this.asCurrencyCode((String)v.get("currency")), amountFx);
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, forex, exchangeRate);
                t.getPortfolioTransaction().addUnit(grossValue);
            }
        }), section -> section.attributes("date", "name", "isin", "shares", "currency", "amountFx", "exchangeRate", "currencyAccount", "amount").match("^(?<date>\\d+-\\d+-\\d{4} \\d+:\\d+) (?<name>.*) (?<isin>\\w{12}+) \\w{3} (?<shares>[-]?[.\\d]+[,\\d]*) \\w{3} -?[.\\d]+,\\d{2,3} (?<currency>\\w{3}) -?(?<amountFx>[.\\d]+,\\d{2}).* \\w{3} -?[.\\d]+,\\d{2} (?<exchangeRate>[.\\d]+,\\d{1,6}) (?<currencyAccount>\\w{3}) -?(?<amount>[.\\d]+,\\d{2})$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDate(this.asDate((String)v.get("date")));
            if (((String)v.get("shares")).startsWith("-")) {
                t.setType(PortfolioTransaction.Type.SELL);
                t.setShares(this.asShares(((String)v.get("shares")).replaceFirst("-", "")));
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currencyAccount")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            long amountFx = this.asAmount((String)v.get("amountFx"));
            String currencyFx = this.asCurrencyCode((String)v.get("currency"));
            if (currencyFx.equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                Money amount = Money.of(this.asCurrencyCode((String)v.get("currencyAccount")), this.asAmount((String)v.get("amount")));
                BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_DOWN);
                Money forex = Money.of(this.asCurrencyCode((String)v.get("currency")), amountFx);
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, forex, exchangeRate);
                t.getPortfolioTransaction().addUnit(grossValue);
            }
        })).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t)));
    }

    @Override
    LocalDateTime asDate(String value) {
        return LocalDateTime.parse(value, DATE_FORMAT);
    }

    @Override
    public String getLabel() {
        return "DEGIRO";
    }

    private static class FxChange {
        private Money money;
        private String exchangeRate;
        private String amountBase;

        public FxChange(Money money, String exchangeRate, String amountBase) {
            this.money = money;
            this.exchangeRate = exchangeRate;
            this.amountBase = amountBase;
        }

        public Money getMoney() {
            return this.money;
        }

        public String getExchangeRate() {
            return this.exchangeRate;
        }

        public String getAmountBase() {
            return this.amountBase;
        }
    }
}

