/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFExtractorUtils;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class DreiBankenEDVPDFExtractor
extends AbstractPDFExtractor {
    public DreiBankenEDVPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("91810s/Klagenfurt");
        this.addBuySellTransaction();
        this.addDividendeTransaction();
    }

    @Override
    public String getPDFAuthor() {
        return "3BankenEDV";
    }

    @Override
    public String getLabel() {
        return "3BankenEDV";
    }

    private void addBuySellTransaction() {
        PDFParser.DocumentType newType = new PDFParser.DocumentType(".*(Kauf|Verkauf).*");
        this.addDocumentTyp(newType);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        PDFParser.Block firstRelevantLine = new PDFParser.Block(".*(Kauf|Verkauf).*");
        newType.addBlock(firstRelevantLine);
        firstRelevantLine.set(pdfTransaction);
        pdfTransaction.section("type").optional().match("Wertpapier-Abrechnu.*(?<type>Verkauf?).*").assign((t, v) -> {
            if (((String)v.get("type")).equals("Verkauf")) {
                t.setType(PortfolioTransaction.Type.SELL);
            }
        }).section("isin", "name", "shares", "nameContinued").match("(?<isin>[\\w]{12}.*?) (?<name>.*?) (Zugang|Abgang).*(?<shares>[\\d.]+(,\\d+)).*").match("(?<nameContinued>.*)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "time").match("^(Handelszeitpunkt:).*(?<date>\\d+.\\d+.\\d{4}+) (?<time>\\d+:\\d+:\\d+).*").assign((t, v) -> {
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("currency", "amount").match("^(Wertpapierrechn.* Wert) (\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) *(?<amount>[\\d.-]+,\\d+).*").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode((String)v.get("currency"));
        }).section("tax", "currency").optional().match("^(Kursgewinn-KESt) (?<currency>\\w{3}).*(?<tax>-[\\d.]+,\\d{2})").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("fee", "currency").optional().match("^(Dritt.*B.*sengeb.*) (?<currency>\\w{3}+).*(?<fee>[\\d.-]+,\\d+).*").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new);
    }

    private void addDividendeTransaction() {
        PDFParser.DocumentType newType = new PDFParser.DocumentType(".*(Aussch\u00fcttung|Dividende).*");
        this.addDocumentTyp(newType);
        PDFParser.Block block = new PDFParser.Block(".*(Aussch\u00fcttung|Dividende).*");
        newType.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DIVIDENDS);
            return entry;
        });
        pdfTransaction.section("isin", "name", "shares", "nameContinued").match("(?<isin>[\\w]{12}.*?) (?<name>.*?) (Stk .).*(?<shares>[\\d.]+(,\\d+)).*").match("(?<nameContinued>.*)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("currency", "amount").match("^(Wertpapierrechn.* Wert) (\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) *(?<amount>[\\d.-]+,\\d+).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("date").match("^Extag (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("exchangeRate", "fxAmount", "fxCurrency", "amount", "currency").optional().match(".*Kurswert.*(?<fxCurrency>\\w{3}).*(?<fxAmount>[\\d.]+,\\d+).*\\w+.*(\\w{3}).*([\\d.]+,\\d+)").match("\\w.*").match("\\w.*").match(".*(?<exchangeRate>[\\d.]+,\\d+) v. (\\d+.\\d+.\\d{4}).*(?<currency>\\w{3}).*(?<amount>[\\d.]+,\\d+).*").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            if (t.getCurrencyCode().contentEquals(this.asCurrencyCode((String)v.get("fxCurrency")))) {
                exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            }
            newType.getCurrentContext().put("exchangeRate", exchangeRate.toPlainString());
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                Transaction.Unit grossValue;
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                if (!this.asCurrencyCode((String)v.get("fxCurrency")).equals(t.getCurrencyCode())) {
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                } else {
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                }
                t.addUnit(grossValue);
            }
        }).section("exchangeRate", "fxAmount", "fxCurrency", "amount", "currency").optional().match(".*Kurswert.*(?<fxCurrency>\\w{3}).*(?<fxAmount>[\\d.]+,\\d+).*\\w+.*(\\w{3}).*([\\d.]+,\\d+)").match("\\w.*").match(".*(?<exchangeRate>[\\d.]+,\\d+) v. (\\d+.\\d+.\\d{4}).*(?<currency>\\w{3}).*(?<amount>[\\d.]+,\\d+).*").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            if (t.getCurrencyCode().contentEquals(this.asCurrencyCode((String)v.get("fxCurrency")))) {
                exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            }
            newType.getCurrentContext().put("exchangeRate", exchangeRate.toPlainString());
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                Transaction.Unit grossValue;
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                if (!this.asCurrencyCode((String)v.get("fxCurrency")).equals(t.getCurrencyCode())) {
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                } else {
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                }
                t.addUnit(grossValue);
            }
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxesSectionsTransaction(pdfTransaction, newType);
        block.set(pdfTransaction);
    }

    private <T extends PDFParser.Transaction<?>> void addTaxesSectionsTransaction(T transaction, PDFParser.DocumentType type) {
        transaction.section("tax", "currency").optional().match("Auslands-KESt.*(?<currency>\\w{3}).*-(?<tax>[\\d.]+,\\d+).*").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().match(".*(?<tax>[\\d.]+,\\d+).*(?<currency>\\w{3}).*KESt").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().match(".*KESt-Neu.*(?<currency>\\w{3}).*-(?<tax>[\\d.]+,\\d+).*").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().match(".*Quellensteuer.*(?<currency>\\w{3}).*-(?<tax>[\\d.]+,\\d+).*").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type));
    }

    private void processTaxEntries(Object t, Map<String, String> v, PDFParser.DocumentType type) {
        if (t instanceof Transaction) {
            Money tax = Money.of(this.asCurrencyCode(v.get("currency")), this.asAmount(v.get("tax")));
            PDFExtractorUtils.checkAndSetTax(tax, (Transaction)t, type);
        } else {
            Money tax = Money.of(this.asCurrencyCode(v.get("currency")), this.asAmount(v.get("tax")));
            PDFExtractorUtils.checkAndSetTax(tax, ((BuySellEntry)t).getPortfolioTransaction(), type);
        }
    }
}

