/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;

final class PDFParser {
    private PDFParser() {
    }

    static class Block {
        private Pattern startsWith;
        private Pattern endsWith;
        private int maxSize = -1;
        private Transaction<?> transaction;

        public Block(String startsWith) {
            this(startsWith, null);
        }

        public Block(String startsWith, String endsWith) {
            this.startsWith = Pattern.compile(startsWith);
            if (endsWith != null) {
                this.endsWith = Pattern.compile(endsWith);
            }
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public void set(Transaction<?> transaction) {
            this.transaction = transaction;
        }

        public void parse(String filename, List<Extractor.Item> items, String[] lines) {
            ArrayList<Integer> blocks = new ArrayList<Integer>();
            int ii = 0;
            while (ii < lines.length) {
                Matcher matcher = this.startsWith.matcher(lines[ii]);
                if (matcher.matches()) {
                    blocks.add(ii);
                }
                ++ii;
            }
            ii = 0;
            while (ii < blocks.size()) {
                int endLine;
                int startLine = (Integer)blocks.get(ii);
                int n = endLine = ii + 1 < blocks.size() ? (Integer)blocks.get(ii + 1) - 1 : lines.length - 1;
                if (this.endsWith == null || (endLine = this.findBlockEnd(lines, startLine, endLine)) != -1) {
                    if (this.maxSize >= 0) {
                        endLine = Math.min(endLine, startLine + this.maxSize - 1);
                    }
                    this.transaction.parse(filename, items, lines, startLine, endLine);
                }
                ++ii;
            }
        }

        private int findBlockEnd(String[] lines, int startLine, int endLine) {
            int lineNo = startLine;
            while (lineNo <= endLine) {
                Matcher matcher = this.endsWith.matcher(lines[lineNo]);
                if (matcher.matches()) {
                    return lineNo;
                }
                ++lineNo;
            }
            return -1;
        }
    }

    static class DocumentType {
        private List<Pattern> mustInclude = new ArrayList<Pattern>();
        private List<Block> blocks = new ArrayList<Block>();
        private Map<String, String> context = new HashMap<String, String>();
        private BiConsumer<Map<String, String>, String[]> contextProvider;

        public DocumentType(List<Pattern> mustInclude) {
            this.mustInclude.addAll(mustInclude);
        }

        public DocumentType(String mustInclude) {
            this(mustInclude, null);
        }

        public DocumentType(String mustInclude, BiConsumer<Map<String, String>, String[]> contextProvider) {
            this.mustInclude.add(Pattern.compile(mustInclude));
            this.contextProvider = contextProvider;
        }

        public boolean matches(String text) {
            for (Pattern pattern : this.mustInclude) {
                if (pattern.matcher(text).find()) continue;
                return false;
            }
            return true;
        }

        public void addBlock(Block block) {
            this.blocks.add(block);
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public Map<String, String> getCurrentContext() {
            return this.context;
        }

        public void parse(String filename, List<Extractor.Item> items, String text) {
            String[] lines = text.split("\\r?\\n");
            this.context.clear();
            this.parseContext(this.context, lines);
            for (Block block : this.blocks) {
                block.parse(filename, items, lines);
            }
        }

        private void parseContext(Map<String, String> context, String[] lines) {
            if (this.contextProvider != null) {
                this.contextProvider.accept(context, lines);
            }
        }
    }

    static class Section<T> {
        private boolean isOptional = false;
        private boolean isMultipleTimes = false;
        private Transaction<T> transaction;
        private String[] attributes;
        private List<Pattern> pattern = new ArrayList<Pattern>();
        private BiConsumer<T, Map<String, String>> assignment;

        public Section(Transaction<T> transaction, String[] attributes) {
            this.transaction = transaction;
            this.attributes = attributes;
        }

        public Section<T> attributes(String ... attributes) {
            this.attributes = attributes;
            return this;
        }

        public Section<T> optional() {
            this.isOptional = true;
            return this;
        }

        public Section<T> multipleTimes() {
            this.isMultipleTimes = true;
            return this;
        }

        public Section<T> find(String string) {
            this.pattern.add(Pattern.compile("^" + string + "$"));
            return this;
        }

        public Section<T> match(String regex) {
            this.pattern.add(Pattern.compile(regex));
            return this;
        }

        public Transaction<T> assign(BiConsumer<T, Map<String, String>> assignment) {
            this.assignment = assignment;
            return this.transaction;
        }

        public void parse(String filename, String[] lines, int lineNo, int lineNoEnd, T target) {
            if (this.assignment == null) {
                throw new IllegalArgumentException("Assignment function missing");
            }
            HashMap<String, String> values = new HashMap<String, String>();
            int patternNo = 0;
            boolean sectionFoundAtLeastOnce = false;
            int ii = lineNo;
            while (ii <= lineNoEnd) {
                Pattern p = this.pattern.get(patternNo);
                Matcher m = p.matcher(lines[ii]);
                if (m.matches()) {
                    this.extractAttributes(values, p, m);
                    if (++patternNo >= this.pattern.size()) {
                        if (values.size() != this.attributes.length) {
                            throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorMissingValueMatches, values.keySet().toString(), Arrays.toString(this.attributes), filename, lineNo + 1, lineNoEnd + 1));
                        }
                        this.assignment.accept(target, values);
                        if (!this.isMultipleTimes) break;
                        sectionFoundAtLeastOnce = true;
                        patternNo = 0;
                    }
                }
                ++ii;
            }
            if (patternNo < this.pattern.size() && !sectionFoundAtLeastOnce && !this.isOptional) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorNotAllPatternMatched, patternNo, this.pattern.size(), this.pattern.toString(), filename, lineNo + 1, lineNoEnd + 1));
            }
        }

        private void extractAttributes(Map<String, String> values, Pattern p, Matcher m) {
            String[] stringArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                String v;
                String attribute = stringArray[n2];
                if (p.pattern().contains("<" + attribute + ">") && (v = m.group(attribute)) != null) {
                    values.put(attribute, v);
                }
                ++n2;
            }
        }
    }

    static class Transaction<T> {
        private Supplier<T> supplier;
        private Function<T, Extractor.Item> wrapper;
        private List<Section<T>> sections = new ArrayList<Section<T>>();

        Transaction() {
        }

        public Transaction<T> subject(Supplier<T> supplier) {
            this.supplier = supplier;
            return this;
        }

        public Section<T> section(String ... attributes) {
            Section section = new Section(this, attributes);
            this.sections.add(section);
            return section;
        }

        @SafeVarargs
        public final Transaction<T> oneOf(Function<Section<T>, Transaction<T>> ... alternatives) {
            final ArrayList subSections = new ArrayList();
            Function<Section<T>, Transaction<T>>[] functionArray = alternatives;
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                Function function = functionArray[n2];
                Section s = new Section(this, null);
                function.apply(s);
                subSections.add(s);
                ++n2;
            }
            this.sections.add(new Section<T>(this, null){

                @Override
                public void parse(String filename, String[] lines, int lineNo, int lineNoEnd, T target) {
                    ArrayList<String> errors = new ArrayList<String>();
                    for (Section section : subSections) {
                        try {
                            section.parse(filename, lines, lineNo, lineNoEnd, target);
                            return;
                        }
                        catch (IllegalArgumentException ignore) {
                            errors.add(ignore.getMessage());
                        }
                    }
                    throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorNoneOfSubSectionsMatched, String.valueOf(subSections.size()), String.join((CharSequence)"; ", errors), lineNo + 1, lineNoEnd + 1));
                }
            });
            return this;
        }

        public Transaction<T> wrap(Function<T, Extractor.Item> wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public void parse(String filename, List<Extractor.Item> items, String[] lines, int lineNoStart, int lineNoEnd) {
            T target = this.supplier.get();
            for (Section<T> section : this.sections) {
                section.parse(filename, lines, lineNoStart, lineNoEnd, target);
            }
            if (this.wrapper == null) {
                throw new IllegalArgumentException("Wrapping function missing");
            }
            Extractor.Item item = this.wrapper.apply(target);
            if (item != null) {
                items.add(item);
            }
        }
    }
}

