/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class TargobankPDFExtractor
extends AbstractPDFExtractor {
    private static final String regexName = "Wertpapier (?<name>.*)";
    private static final String regexWknAndIsin = "WKN / ISIN (?<wkn>\\S*) / (?<isin>\\S*)";
    private static final String regexAmountAndCurrency = "Konto-Nr. \\w* (?<amount>(\\d+\\.)?\\d+(,\\d+)?) (?<currency>\\w{3}+)";
    private static final String regexDate = "Schlusstag( / Handelszeit)? (?<date>\\d{2}.\\d{2}.\\d{4})( / (?<time>\\d{2}:\\d{2}:\\d{2}))?";
    private static final String regexTime = "(Schlusstag / )?Handelszeit ((?<date>\\d{2}.\\d{2}.\\d{4}) / )?(?<time>\\d{2}:\\d{2}:\\d{2})";
    private static final String regexShares = "St.ck (?<shares>(\\d+.)?\\d+(,\\d+)?)";
    private static final String regexFees = "Provision (?<fee>(\\d+\\.)?\\d+(,\\d+)?) (?<currency>\\w{3}+)";
    private static final String regexTaxes = "Gesamtsumme Steuern (?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)$";
    private static final String regexWithholdingTaxDivDoc = ".*Ausl.ndische Quellensteuer .* (?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)$";
    private static final String regexWithholdingTaxTaxDoc = "Anrechenbare ausl.ndische Quellensteuer (?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)$";
    private static final String TO_BE_DELETED = "to_be_deleted";
    private static final String ATTRIBUTE_PAY_DATE = "pay_date";
    private static final DateTimeFormatter SPECIAL_DATE_FORMAT = DateTimeFormatter.ofPattern("d. MMMM yyyy", Locale.GERMANY);

    public TargobankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("TARGO");
        this.addBankIdentifier("Targobank");
        this.addBankIdentifier("TARGOBANK AG");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
        this.addDividendTransactionFromTaxDocument();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Transaktionstyp )?Kauf");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("name", "wkn", "isin").optional().match(regexName).match(regexWknAndIsin).assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("time").optional().match(regexTime).assign((t, v) -> type.getCurrentContext().put("time", (String)v.get("time"))).section("date").optional().match(regexDate).assign((t, v) -> {
            if (type.getCurrentContext().get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), type.getCurrentContext().get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("amount", "currency").match(regexAmountAndCurrency).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("fee", "currency").optional().match(regexFees).assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("shares").optional().match(regexShares).assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).wrap(t -> {
            if (t.getPortfolioTransaction().getShares() == 0L) {
                throw new IllegalArgumentException(Messages.PDFMsgMissingShares);
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        });
        block.set(pdfTransaction);
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Transaktionstyp )?Verkauf");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("name", "wkn", "isin").match(regexName).match(regexWknAndIsin).assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("time").optional().match(regexTime).assign((t, v) -> type.getCurrentContext().put("time", (String)v.get("time"))).section("date").optional().match(regexDate).assign((t, v) -> {
            if (type.getCurrentContext().get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), type.getCurrentContext().get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("amount", "currency").optional().match(regexAmountAndCurrency).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("fee", "currency").optional().match(regexFees).assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("tax", "currency").optional().match(regexTaxes).assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
        }).section("shares").optional().match(regexShares).assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).wrap(t -> {
            if (t.getPortfolioTransaction().getShares() == 0L) {
                throw new IllegalArgumentException(Messages.PDFMsgMissingShares);
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        });
        block.set(pdfTransaction);
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType ertrag = new PDFParser.DocumentType("(Ertragsgutschrift|Dividendengutschrift) \\d.*");
        this.addDocumentTyp(ertrag);
        PDFParser.Block block = new PDFParser.Block("(Ertragsgutschrift|Dividendengutschrift).*");
        ertrag.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("name", "wkn", "isin", "currency", "shares").match(regexName).match(regexWknAndIsin).match("St.ck (?<shares>[\\d.]+(,\\d+)?)").match("(Aussch.ttung|Dividende) pro St.ck ([\\d.]+,\\d+) (?<currency>\\w{3}+).*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match(regexAmountAndCurrency).assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("date").match("(Ertragsgutschrift|Dividendengutschrift) (?<date>\\d+.\\d+.\\d{4})$").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("date").match("Zahlbar (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.getSecurity().getAttributes().put(new AttributeType(ATTRIBUTE_PAY_DATE), this.asDate((String)v.get("date")))).section("tax", "currency").optional().match(regexWithholdingTaxDivDoc).assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
        }).section("exchangeRate", "fxAmount", "fxCurrency", "amount", "currency").optional().match("Bruttoertrag (?<fxAmount>[\\d.]+,\\d+) (?<fxCurrency>\\w{3}+)").match("Devisenkurs zur Handelsw.hrung (\\w{3}+)/(\\w{3}+) (?<exchangeRate>[\\d.]+,\\d+)").match("Bruttoertrag in (\\w{3}+) (?<amount>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                t.addUnit(grossValue);
            }
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : null));
    }

    private void addDividendTransactionFromTaxDocument() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(Ertragsgutschrift|Dividendengutschrift) \\(Steuerbeilage\\) .*");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Ertragsgutschrift|Dividendengutschrift) \\(Steuerbeilage\\) .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("name", "wkn", "isin", "shares").match(regexName).match(regexWknAndIsin).match("St.ck (?<shares>[\\d.]+(,\\d+)?)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match("Ertr.ge/Verluste (?<amount>[\\d.\\s]*,[\\d\\s]+) (?<currency>[A-Z\\s]*)$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("amount").optional().match("Teilfreistellung .* - (?<amount>[\\d.\\s]*,[\\d\\s]+) ([A-Z\\s]*)$").assign((t, v) -> t.setAmount(t.getAmount() + this.asAmount((String)v.get("amount")))).section("tax", "currency").match(regexTaxes).assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            t.setAmount(t.getAmount() - this.asAmount((String)v.get("tax")));
        }).section("tax", "currency").optional().match(regexWithholdingTaxTaxDoc).assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            t.setAmount(t.getAmount() - this.asAmount((String)v.get("tax")));
        }).section("date").match("(Ertragsgutschrift|Dividendengutschrift) \\(Steuerbeilage\\) (?<date>\\d+.\\d+.\\d{4}+)$").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("date").optional().match("Belastung Ihres Kontos .* mit Wertstellung zum (?<date>\\d+. \\w+ \\d{4}).$").assign((t, v) -> {
            LocalDate date = LocalDate.parse((CharSequence)v.get("date"), SPECIAL_DATE_FORMAT);
            t.getSecurity().getAttributes().put(new AttributeType(ATTRIBUTE_PAY_DATE), date.atStartOfDay());
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public List<Extractor.Item> postProcessing(List<Extractor.Item> items) {
        Map<LocalDateTime, Map<Security, List<Extractor.Item>>> dividends = items.stream().filter(Extractor.TransactionItem.class::isInstance).map(Extractor.TransactionItem.class::cast).filter(i -> i.getSubject() instanceof AccountTransaction).filter(i -> AccountTransaction.Type.DIVIDENDS.equals((Object)((AccountTransaction)i.getSubject()).getType())).collect(Collectors.groupingBy(Extractor.Item::getDate, Collectors.groupingBy(Extractor.Item::getSecurity)));
        dividends.forEach((k, v) -> v.forEach((key, transactions) -> {
            if (transactions.size() == 1) {
                AccountTransaction a1 = (AccountTransaction)((Extractor.Item)transactions.get(0)).getSubject();
                if (a1.getSecurity().getAttributes().get(new AttributeType(ATTRIBUTE_PAY_DATE)) != null) {
                    a1.setDateTime((LocalDateTime)a1.getSecurity().getAttributes().get(new AttributeType(ATTRIBUTE_PAY_DATE)));
                }
            } else if (transactions.size() == 2) {
                AccountTransaction a2;
                AccountTransaction a1 = (AccountTransaction)((Extractor.Item)transactions.get(0)).getSubject();
                if (a1.getUnit(Transaction.Unit.Type.TAX).isPresent()) {
                    a2 = (AccountTransaction)((Extractor.Item)transactions.get(1)).getSubject();
                } else {
                    a1 = (AccountTransaction)((Extractor.Item)transactions.get(1)).getSubject();
                    a2 = (AccountTransaction)((Extractor.Item)transactions.get(0)).getSubject();
                }
                Optional<Transaction.Unit> unitGross = a2.getUnit(Transaction.Unit.Type.GROSS_VALUE);
                if (unitGross.isPresent()) {
                    a1.addUnit(unitGross.get());
                }
                a1.setDateTime((LocalDateTime)a1.getSecurity().getAttributes().get(new AttributeType(ATTRIBUTE_PAY_DATE)));
                a1.setNote(a2.getNote().concat("; ").concat(a1.getNote()));
                a2.setNote(TO_BE_DELETED);
            }
        }));
        Map<LocalDateTime, Map<Security, List<Extractor.Item>>> sells = items.stream().filter(Extractor.BuySellEntryItem.class::isInstance).map(Extractor.BuySellEntryItem.class::cast).filter(i -> i.getSubject() instanceof BuySellEntry).filter(i -> PortfolioTransaction.Type.SELL.equals((Object)((BuySellEntry)i.getSubject()).getPortfolioTransaction().getType())).collect(Collectors.groupingBy(Extractor.Item::getDate, Collectors.groupingBy(Extractor.Item::getSecurity)));
        sells.forEach((k, v) -> v.forEach((key, transactions) -> {
            if (transactions.size() == 2) {
                BuySellEntry a2;
                BuySellEntry a1 = (BuySellEntry)((Extractor.Item)transactions.get(0)).getSubject();
                if (a1.getPortfolioTransaction().getUnit(Transaction.Unit.Type.TAX).isPresent()) {
                    a2 = (BuySellEntry)((Extractor.Item)transactions.get(1)).getSubject();
                } else {
                    a1 = (BuySellEntry)((Extractor.Item)transactions.get(1)).getSubject();
                    a2 = (BuySellEntry)((Extractor.Item)transactions.get(0)).getSubject();
                }
                Optional<Transaction.Unit> unitTax = a1.getPortfolioTransaction().getUnit(Transaction.Unit.Type.TAX);
                if (unitTax.isPresent()) {
                    Money tax = unitTax.get().getAmount();
                    a2.setAmount(a2.getPortfolioTransaction().getAmount() - tax.getAmount());
                    a2.getPortfolioTransaction().addUnit(unitTax.get());
                }
                a2.setNote(a2.getNote().concat("; ").concat(a1.getNote()));
                a1.setNote(TO_BE_DELETED);
            }
        }));
        Iterator<Extractor.Item> iter = items.iterator();
        while (iter.hasNext()) {
            Annotated a;
            Annotated o = iter.next().getSubject();
            if (o instanceof AccountTransaction) {
                a = (AccountTransaction)o;
                if (!((Transaction)a).getNote().equals(TO_BE_DELETED)) continue;
                iter.remove();
                continue;
            }
            if (!(o instanceof BuySellEntry) || !((BuySellEntry)(a = (BuySellEntry)o)).getNote().equals(TO_BE_DELETED)) continue;
            iter.remove();
        }
        return items;
    }

    @Override
    public String getLabel() {
        return "TARGO";
    }
}

