/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;

public class Bookmark
implements Comparable<Bookmark> {
    private static final Pattern REPLACEMENT_PATTERN = Pattern.compile("\\{([^}]*)\\}");
    private String label;
    private String pattern;

    public Bookmark(String pattern) {
        this(pattern, pattern);
    }

    public Bookmark(String label, String pattern) {
        this.label = Objects.requireNonNull(label);
        this.pattern = Objects.requireNonNull(pattern);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isSeparator() {
        return "-".equals(this.label);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)obj;
        if (!Objects.equals(this.label, other.label)) {
            return false;
        }
        return Objects.equals(this.pattern, other.pattern);
    }

    @Override
    public int compareTo(Bookmark other) {
        return this.label.compareTo(other.label);
    }

    public String constructURL(Client client, Security security) {
        HashMap<String, String> types = new HashMap<String, String>();
        types.put("tickerSymbol", security.getTickerSymbol());
        types.put("tickerSymbolPrefix", this.getTickerPrefix(security.getTickerSymbol()));
        types.put("isin", security.getIsin());
        types.put("wkn", security.getWkn());
        types.put("name", security.getName());
        client.getSettings().getAttributeTypes().filter(a -> a.supports(Security.class)).filter(a -> !types.containsKey(a.getColumnLabel())).forEach(attrib -> {
            Object value = security.getAttributes().get((AttributeType)attrib);
            types.put(attrib.getColumnLabel(), attrib.getConverter().toString(value));
        });
        StringBuilder answer = new StringBuilder();
        int position = 0;
        Matcher matcher = REPLACEMENT_PATTERN.matcher(this.pattern);
        block0: while (matcher.find()) {
            answer.append(this.pattern.substring(position, matcher.start()));
            position = matcher.end();
            String[] stringArray = matcher.group(1).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String replacement = (String)types.get(key);
                if (replacement != null && !replacement.isEmpty()) {
                    answer.append(this.encode(replacement));
                    continue block0;
                }
                ++n2;
            }
        }
        answer.append(this.pattern.substring(position));
        return answer.toString();
    }

    private String encode(String s) {
        try {
            return s == null ? "" : URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private String getTickerPrefix(String tickerSymbol) {
        if (tickerSymbol == null) {
            return null;
        }
        int dot = tickerSymbol.indexOf(46);
        return dot > 0 ? tickerSymbol.substring(0, dot) : tickerSymbol;
    }
}

