/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.ColorConversion;

public class Classification
implements Named {
    public static final int ONE_HUNDRED_PERCENT = 100 * Values.Weight.factor();
    public static final BigDecimal ONE_HUNDRED_PERCENT_BD = BigDecimal.valueOf(Values.Weight.factorize(100.0));
    public static final String UNASSIGNED_ID = "$unassigned$";
    public static final String VIRTUAL_ROOT = "$virtualroot$";
    private static final Random RANDOM = new Random();
    private String id;
    private String name;
    private String description;
    private String color;
    private Classification parent;
    private List<Classification> children = new ArrayList<Classification>();
    private List<Assignment> assignments = new ArrayList<Assignment>();
    private int weight;
    private int rank;
    private Map<String, Object> data;

    public Classification() {
    }

    public Classification(String id, String name) {
        this(null, id, name);
    }

    public Classification(Classification parent, String id, String name, String color) {
        this.parent = parent;
        this.id = id;
        this.name = name;
        this.color = color;
        if (color == null) {
            Random r = new Random();
            this.color = String.valueOf('#') + Integer.toHexString(r.nextInt(128) + 127 << 16 | r.nextInt(128) + 127 << 8 | r.nextInt(128) + 127);
        }
        this.weight = ONE_HUNDRED_PERCENT;
    }

    public Classification(Classification parent, String id, String name) {
        this(parent, id, name, null);
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNote() {
        return this.description;
    }

    @Override
    public void setNote(String note) {
        this.description = note;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Classification getParent() {
        return this.parent;
    }

    public void setParent(Classification parent) {
        this.parent = parent;
    }

    public List<Classification> getChildren() {
        return this.children;
    }

    public void addChild(Classification classification) {
        this.children.add(classification);
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public void addAssignment(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public void removeAssignment(Assignment assignment) {
        this.assignments.remove(assignment);
    }

    public void clearAssignments() {
        this.assignments.clear();
    }

    public int getWeight() {
        return this.weight;
    }

    public int getChildrenWeight() {
        int sum = 0;
        for (Classification child : this.children) {
            sum += child.getWeight();
        }
        return sum;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public Object setData(String key, Object object) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return object == null ? this.data.remove(key) : this.data.put(key, object);
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public String getPathName(boolean includeParent, int limit) {
        LinkedList<Classification> path = this.getPath();
        if (!includeParent && path.size() > 1) {
            path.removeFirst();
        }
        if (path.size() == 1) {
            return path.get(0).getName();
        }
        int available = limit;
        StringBuilder leftBuffer = new StringBuilder();
        StringBuilder rightBuffer = new StringBuilder();
        int left = 0;
        int right = 0;
        while (left + right < path.size()) {
            Classification c;
            if ((left + right) % 2 == 0) {
                c = path.get(path.size() - 1 - right);
                if ((available -= c.getName().length()) < 0) break;
                if (rightBuffer.length() > 0) {
                    rightBuffer.insert(0, " \u00bb ");
                }
                rightBuffer.insert(0, c.getName());
                ++right;
                continue;
            }
            c = path.get(left);
            if ((available -= c.getName().length()) < 0) break;
            if (leftBuffer.length() > 0) {
                leftBuffer.append(" \u00bb ");
            }
            leftBuffer.append(c.getName());
            ++left;
        }
        if (left + right == path.size()) {
            return String.valueOf(leftBuffer.toString()) + " \u00bb " + rightBuffer.toString();
        }
        return String.valueOf(leftBuffer.toString()) + " ... " + rightBuffer.toString();
    }

    public String getPathName(boolean includeParent) {
        LinkedList<Classification> path = this.getPath();
        if (!includeParent && path.size() > 1) {
            path.removeFirst();
        }
        StringBuilder buf = new StringBuilder();
        for (Classification c : path) {
            if (buf.length() > 0) {
                buf.append(" \u00bb ");
            }
            buf.append(c.getName());
        }
        return buf.toString();
    }

    private LinkedList<Classification> getPath() {
        LinkedList<Classification> path = new LinkedList<Classification>();
        Classification c = this;
        while (c != null) {
            path.addFirst(c);
            c = c.getParent();
        }
        return path;
    }

    public List<Classification> getTreeElements() {
        ArrayList<Classification> answer = new ArrayList<Classification>();
        LinkedList<Classification> stack = new LinkedList<Classification>();
        ArrayList<Classification> list = new ArrayList<Classification>(this.getChildren());
        list.sort((r, l) -> Integer.compare(r.getRank(), l.getRank()));
        stack.addAll(list);
        while (!stack.isEmpty()) {
            Classification c = (Classification)stack.pop();
            answer.add(c);
            list = new ArrayList<Classification>(c.getChildren());
            list.sort((r, l) -> Integer.compare(r.getRank(), l.getRank()));
            stack.addAll(0, list);
        }
        return answer;
    }

    public List<Classification> getPathToRoot() {
        LinkedList<Classification> path = new LinkedList<Classification>();
        Classification item = this;
        while (item != null) {
            path.addFirst(item);
            item = item.getParent();
        }
        return path;
    }

    public void assignRandomColors() {
        float hue = RANDOM.nextFloat() * 360.0f;
        float saturation = RANDOM.nextFloat() * 0.5f + 0.3f;
        float brightness = RANDOM.nextFloat() * 0.4f + 0.5f;
        this.assignRandomColors(hue, saturation, brightness);
    }

    void assignRandomColors(float hue, float saturation, float brightness) {
        if (this.children.isEmpty()) {
            return;
        }
        Collections.sort(this.children, (c1, c2) -> Integer.compare(c2.getRank(), c1.getRank()));
        int size = this.children.size();
        float step = 360.0f / (float)size;
        int index = 0;
        for (Classification child : this.children) {
            float h = (hue + step * (float)index) % 360.0f;
            child.setColor(ColorConversion.toHex(h, saturation, brightness));
            child.cascadeColorDown(h, saturation, brightness);
            ++index;
        }
    }

    public void cascadeColorDown() {
        if (this.children.isEmpty()) {
            return;
        }
        float[] hsb = ColorConversion.toHSB(this.color);
        this.cascadeColorDown(hsb[0], hsb[1], hsb[2]);
    }

    private void cascadeColorDown(float hue, float saturation, float brightness) {
        if (this.children.isEmpty()) {
            return;
        }
        float childSaturation = Math.max(0.0f, saturation - 0.1f);
        float childBrightness = Math.min(1.0f, brightness + 0.1f);
        for (Classification child : this.children) {
            child.setColor(ColorConversion.toHex(hue, childSaturation, childBrightness));
            child.cascadeColorDown(hue, childSaturation, childBrightness);
        }
    }

    public void accept(Taxonomy.Visitor visitor) {
        visitor.visit(this);
        this.getChildren().stream().sorted((r, l) -> Integer.compare(r.getRank(), l.getRank())).forEach(child -> child.accept(visitor));
        for (Assignment assignment : new ArrayList<Assignment>(this.assignments)) {
            visitor.visit(this, assignment);
        }
    }

    public String toString() {
        return this.name;
    }

    public Classification copy() {
        Classification copy = new Classification(null, UUID.randomUUID().toString(), this.name, this.color);
        copy.rank = this.rank;
        copy.weight = this.weight;
        if (this.data != null) {
            copy.data = new HashMap<String, Object>(this.data);
        }
        for (Classification classification : this.children) {
            Classification c = classification.copy();
            c.setParent(copy);
            copy.addChild(c);
        }
        for (Assignment assignment : this.assignments) {
            Assignment a = new Assignment(assignment.getInvestmentVehicle());
            a.setWeight(assignment.getWeight());
            a.setRank(assignment.getRank());
            if (assignment.data != null) {
                a.data = new HashMap(assignment.data);
            }
            copy.addAssignment(a);
        }
        return copy;
    }

    public static class Assignment {
        private InvestmentVehicle investmentVehicle;
        private int weight;
        private int rank;
        private Map<String, Object> data;

        public Assignment() {
        }

        public Assignment(InvestmentVehicle vehicle) {
            this(vehicle, ONE_HUNDRED_PERCENT);
        }

        public Assignment(InvestmentVehicle vehicle, int weight) {
            this.weight = weight;
            this.investmentVehicle = vehicle;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public InvestmentVehicle getInvestmentVehicle() {
            return this.investmentVehicle;
        }

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            this.rank = rank;
        }

        public Object setData(String key, Object object) {
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            return object == null ? this.data.remove(key) : this.data.put(key, object);
        }

        public Object getData(String key) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(key);
        }
    }
}

