/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;

public class InvestmentPlan
implements Named,
Adaptable,
Attributable {
    private String name;
    private String note;
    private Security security;
    private Portfolio portfolio;
    private Account account;
    private Attributes attributes;
    private boolean autoGenerate = false;
    private LocalDateTime start;
    private int interval = 1;
    private long amount;
    private long fees;
    private List<Transaction> transactions = new ArrayList<Transaction>();

    public InvestmentPlan() {
    }

    public InvestmentPlan(String name) {
        this.name = name;
    }

    public Class<? extends Transaction> getPlanType() {
        if (this.portfolio != null && this.security != null) {
            return PortfolioTransaction.class;
        }
        if (this.portfolio == null && this.account != null && this.security == null) {
            return AccountTransaction.class;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }

    public void setAutoGenerate(boolean autoGenerate) {
        this.autoGenerate = autoGenerate;
    }

    public LocalDate getStart() {
        return this.start.toLocalDate();
    }

    public void setStart(LocalDate start) {
        this.start = start.atStartOfDay();
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public long getFees() {
        return this.fees;
    }

    public void setFees(long fees) {
        this.fees = fees;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public List<TransactionPair<?>> getTransactions(Client client) {
        ArrayList answer = new ArrayList();
        for (Transaction t : this.transactions) {
            if (t instanceof AccountTransaction) {
                answer.add(new TransactionPair<AccountTransaction>(this.lookupOwner(client, (AccountTransaction)t), (AccountTransaction)t));
                continue;
            }
            answer.add(new TransactionPair<PortfolioTransaction>(this.lookupOwner(client, (PortfolioTransaction)t), (PortfolioTransaction)t));
        }
        return answer;
    }

    private Account lookupOwner(Client client, AccountTransaction t) {
        if (this.account != null && this.account.getTransactions().contains(t)) {
            return this.account;
        }
        return client.getAccounts().stream().filter(a -> a.getTransactions().contains(t)).findAny().orElseThrow(IllegalArgumentException::new);
    }

    private Portfolio lookupOwner(Client client, PortfolioTransaction t) {
        if (this.portfolio != null && this.portfolio.getTransactions().contains(t)) {
            return this.portfolio;
        }
        return client.getPortfolios().stream().filter(a -> a.getTransactions().contains(t)).findAny().orElseThrow(IllegalArgumentException::new);
    }

    public void removeTransaction(PortfolioTransaction transaction) {
        this.transactions.remove(transaction);
    }

    public void removeTransaction(AccountTransaction transaction) {
        this.transactions.remove(transaction);
    }

    public String getCurrencyCode() {
        return this.account != null ? this.account.getCurrencyCode() : this.portfolio.getReferenceAccount().getCurrencyCode();
    }

    @Override
    public <T> T adapt(Class<T> type) {
        if (type == Security.class) {
            return type.cast(this.security);
        }
        if (type == Account.class) {
            return type.cast(this.account);
        }
        if (type == Portfolio.class) {
            return type.cast(this.portfolio);
        }
        return null;
    }

    public Optional<LocalDate> getLastDate() {
        LocalDate last = null;
        for (Transaction t : this.transactions) {
            LocalDate date = t.getDateTime().toLocalDate();
            if (last != null && !last.isBefore(date)) continue;
            last = date;
        }
        return Optional.ofNullable(last);
    }

    private LocalDate next(LocalDate transactionDate) {
        LocalDate previousDate = transactionDate;
        if (transactionDate.getDayOfMonth() != this.start.getDayOfMonth()) {
            int daysBetween = Integer.MAX_VALUE;
            LocalDate testDate = transactionDate.minusMonths(1L);
            testDate = testDate.withDayOfMonth(Math.min(testDate.lengthOfMonth(), this.start.getDayOfMonth()));
            int ii = 0;
            while (ii < 3) {
                int d = Dates.daysBetween(transactionDate, testDate);
                if (d < daysBetween) {
                    daysBetween = d;
                    previousDate = testDate;
                }
                testDate = testDate.plusMonths(1L);
                testDate = testDate.withDayOfMonth(Math.min(testDate.lengthOfMonth(), this.start.getDayOfMonth()));
                ++ii;
            }
        }
        LocalDate next = previousDate.plusMonths(this.interval);
        if ((next = next.withDayOfMonth(Math.min(next.lengthOfMonth(), this.start.getDayOfMonth()))).isBefore(this.start.toLocalDate())) {
            next = this.start.toLocalDate();
        }
        TradeCalendar tradeCalendar = this.security != null ? TradeCalendarManager.getInstance(this.security) : TradeCalendarManager.getDefaultInstance();
        while (tradeCalendar.isHoliday(next)) {
            next = next.plusDays(1L);
        }
        return next;
    }

    public LocalDate getDateOfNextTransactionToBeGenerated() {
        Optional<LocalDate> lastDate = this.getLastDate();
        if (lastDate.isPresent()) {
            return this.next(lastDate.get());
        }
        LocalDate startDate = this.start.toLocalDate();
        TradeCalendar tradeCalendar = this.security != null ? TradeCalendarManager.getInstance(this.security) : TradeCalendarManager.getDefaultInstance();
        while (tradeCalendar.isHoliday(startDate)) {
            startDate = startDate.plusDays(1L);
        }
        return startDate;
    }

    public List<TransactionPair<?>> generateTransactions(CurrencyConverter converter) throws IOException {
        LocalDate transactionDate = this.getDateOfNextTransactionToBeGenerated();
        ArrayList newlyCreated = new ArrayList();
        LocalDate now = LocalDate.now();
        while (!transactionDate.isAfter(now)) {
            TransactionPair<?> transaction = this.createTransaction(converter, transactionDate);
            this.transactions.add((Transaction)transaction.getTransaction());
            newlyCreated.add(transaction);
            transactionDate = this.next(transactionDate);
        }
        return newlyCreated;
    }

    private TransactionPair<?> createTransaction(CurrencyConverter converter, LocalDate tDate) throws IOException {
        Class<? extends Transaction> planType = this.getPlanType();
        if (planType == PortfolioTransaction.class) {
            return this.createSecurityTx(converter, tDate);
        }
        if (planType == AccountTransaction.class) {
            return this.createDepositTx(converter, tDate);
        }
        throw new IllegalArgumentException();
    }

    private TransactionPair<?> createSecurityTx(CurrencyConverter converter, LocalDate tDate) throws IOException {
        String targetCurrencyCode = this.getCurrencyCode();
        boolean needsCurrencyConversion = !targetCurrencyCode.equals(this.security.getCurrencyCode());
        Transaction.Unit forex = null;
        long price = this.getSecurity().getSecurityPrice(tDate).getValue();
        if (price == 0L) {
            throw new IOException(MessageFormat.format(Messages.MsgErrorInvestmentPlanMissingSecurityPricesToGenerateTransaction, this.getSecurity().getName()));
        }
        long availableAmount = this.amount - this.fees;
        if (needsCurrencyConversion) {
            Money availableMoney = Money.of(targetCurrencyCode, this.amount - this.fees);
            availableAmount = converter.with(this.security.getCurrencyCode()).convert(tDate, availableMoney).getAmount();
            forex = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, availableMoney, Money.of(this.security.getCurrencyCode(), availableAmount), converter.with(targetCurrencyCode).getRate(tDate, this.security.getCurrencyCode()).getValue());
        }
        long shares = Math.round((double)(availableAmount * (long)Values.Share.factor() * (long)Values.Quote.factorToMoney()) / (double)price);
        if (this.account != null) {
            BuySellEntry entry = new BuySellEntry(this.portfolio, this.account);
            entry.setType(PortfolioTransaction.Type.BUY);
            entry.setDate(tDate.atStartOfDay());
            entry.setShares(shares);
            entry.setCurrencyCode(targetCurrencyCode);
            entry.setAmount(this.amount);
            entry.setSecurity(this.getSecurity());
            entry.setNote(MessageFormat.format(Messages.InvestmentPlanAutoNoteLabel, Values.DateTime.format(LocalDateTime.now()), this.name));
            if (this.fees != 0L) {
                entry.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(targetCurrencyCode, this.fees)));
            }
            if (forex != null) {
                entry.getPortfolioTransaction().addUnit(forex);
            }
            entry.insert();
            return new TransactionPair<PortfolioTransaction>(this.portfolio, entry.getPortfolioTransaction());
        }
        PortfolioTransaction transaction = new PortfolioTransaction();
        transaction.setDateTime(tDate.atStartOfDay());
        transaction.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
        transaction.setSecurity(this.security);
        transaction.setCurrencyCode(targetCurrencyCode);
        transaction.setAmount(this.amount);
        transaction.setShares(shares);
        transaction.setNote(MessageFormat.format(Messages.InvestmentPlanAutoNoteLabel, Values.DateTime.format(LocalDateTime.now()), this.name));
        if (this.fees != 0L) {
            transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(targetCurrencyCode, this.fees)));
        }
        if (forex != null) {
            transaction.addUnit(forex);
        }
        this.portfolio.addTransaction(transaction);
        return new TransactionPair<PortfolioTransaction>(this.portfolio, transaction);
    }

    private TransactionPair<?> createDepositTx(CurrencyConverter converter, LocalDate tDate) {
        boolean needsCurrencyConversion;
        Money deposit = Money.of(this.getCurrencyCode(), this.amount);
        boolean bl = needsCurrencyConversion = !this.getCurrencyCode().equals(this.account.getCurrencyCode());
        if (needsCurrencyConversion) {
            deposit = (Money)converter.with(this.account.getCurrencyCode()).at(tDate).apply(deposit);
        }
        AccountTransaction transaction = new AccountTransaction();
        transaction.setDateTime(tDate.atStartOfDay());
        transaction.setType(AccountTransaction.Type.DEPOSIT);
        transaction.setMonetaryAmount(deposit);
        transaction.setNote(MessageFormat.format(Messages.InvestmentPlanAutoNoteLabel, Values.DateTime.format(LocalDateTime.now()), this.name));
        this.account.addTransaction(transaction);
        return new TransactionPair<AccountTransaction>(this.account, transaction);
    }
}

