/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.Objects;
import java.util.Optional;
import name.abuchen.portfolio.money.Values;

public class LimitPrice
implements Comparable<LimitPrice> {
    private RelationalOperator operator = null;
    private long value;

    public LimitPrice(RelationalOperator operator, long value) {
        this.operator = Objects.requireNonNull(operator);
        this.value = value;
    }

    public RelationalOperator getRelationalOperator() {
        return this.operator;
    }

    public long getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitPrice other = (LimitPrice)obj;
        if (this.value != other.value) {
            return false;
        }
        return this.operator == other.operator;
    }

    @Override
    public int compareTo(LimitPrice other) {
        int compare = this.operator.getOperatorString().compareTo(other.getRelationalOperator().getOperatorString());
        if (compare != 0) {
            return compare;
        }
        return (int)(this.value - other.getValue());
    }

    public String toString() {
        return String.valueOf(this.operator.getOperatorString()) + " " + Values.Quote.format(this.value);
    }

    public static enum RelationalOperator {
        GREATER_OR_EQUAL(">="),
        SMALLER_OR_EQUAL("<="),
        GREATER(">"),
        SMALLER("<");

        private String operatorString;

        private RelationalOperator(String operator) {
            this.operatorString = operator;
        }

        public String getOperatorString() {
            return this.operatorString;
        }

        public static Optional<RelationalOperator> findByOperator(String op) {
            RelationalOperator[] relationalOperatorArray = RelationalOperator.values();
            int n = relationalOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                RelationalOperator t = relationalOperatorArray[n2];
                if (t.getOperatorString().equals(op)) {
                    return Optional.of(t);
                }
                ++n2;
            }
            return Optional.empty();
        }
    }
}

