/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.TransactionOwner;

public class Portfolio
implements Named,
TransactionOwner<PortfolioTransaction>,
Attributable {
    private String uuid;
    private String name;
    private String note;
    private boolean isRetired = false;
    private Account referenceAccount;
    private List<PortfolioTransaction> transactions = new ArrayList<PortfolioTransaction>();
    private Attributes attributes;

    public Portfolio() {
        this.uuid = UUID.randomUUID().toString();
    }

    public Portfolio(String name) {
        this();
        this.name = name;
    }

    public String getUUID() {
        return this.uuid;
    }

    void generateUUID() {
        this.uuid = UUID.randomUUID().toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    public boolean isRetired() {
        return this.isRetired;
    }

    public void setRetired(boolean isRetired) {
        this.isRetired = isRetired;
    }

    public Account getReferenceAccount() {
        return this.referenceAccount;
    }

    public void setReferenceAccount(Account referenceAccount) {
        this.referenceAccount = referenceAccount;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public List<PortfolioTransaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public void addTransaction(PortfolioTransaction transaction) {
        this.transactions.add(transaction);
    }

    @Override
    public void shallowDeleteTransaction(PortfolioTransaction transaction, Client client) {
        this.transactions.remove(transaction);
        client.getPlans().stream().forEach(plan -> plan.removeTransaction(transaction));
    }

    public void addAllTransaction(List<PortfolioTransaction> transactions) {
        this.transactions.addAll(transactions);
    }

    public String toString() {
        return this.name;
    }
}

