/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.ResourceBundle;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.money.Values;

public class PortfolioTransaction
extends Transaction {
    private Type type;
    @Deprecated
    transient long fees;
    @Deprecated
    transient long taxes;

    public PortfolioTransaction() {
    }

    public PortfolioTransaction(LocalDateTime date, String currencyCode, long amount, Security security, long shares, Type type, long fees, long taxes) {
        super(date, currencyCode, amount, security, shares, null);
        this.type = type;
        if (fees != 0L) {
            this.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currencyCode, fees)));
        }
        if (taxes != 0L) {
            this.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(currencyCode, taxes)));
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Money getMonetaryAmount(CurrencyConverter converter) {
        if (this.getCurrencyCode().equals(converter.getTermCurrency())) {
            return this.getMonetaryAmount();
        }
        if (this.getSecurity().getCurrencyCode().equals(converter.getTermCurrency())) {
            Optional<Transaction.Unit> grossValue = this.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            BigDecimal exchangeRate = grossValue.isPresent() ? grossValue.get().getExchangeRate() : converter.getRate(this.getDateTime(), this.getCurrencyCode()).getValue();
            return Money.of(converter.getTermCurrency(), BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(this.getAmount())).setScale(0, RoundingMode.HALF_DOWN).longValue());
        }
        return converter.convert(this.getDateTime(), this.getMonetaryAmount());
    }

    public long getGrossValueAmount() {
        long taxAndFees = this.getUnitSum(Transaction.Unit.Type.FEE, Transaction.Unit.Type.TAX).getAmount();
        if (this.type.isPurchase()) {
            return this.getAmount() - taxAndFees;
        }
        return this.getAmount() + taxAndFees;
    }

    public Money getGrossValue() {
        return Money.of(this.getCurrencyCode(), this.getGrossValueAmount());
    }

    public Money getGrossValue(CurrencyConverter converter) {
        Optional<Transaction.Unit> grossValue;
        if (this.getCurrencyCode().equals(converter.getTermCurrency())) {
            return this.getGrossValue();
        }
        if (this.getSecurity().getCurrencyCode().equals(converter.getTermCurrency()) && (grossValue = this.getUnit(Transaction.Unit.Type.GROSS_VALUE)).isPresent()) {
            return Money.of(converter.getTermCurrency(), grossValue.get().getForex().getAmount());
        }
        return converter.convert(this.getDateTime(), this.getGrossValue());
    }

    public Quote getGrossPricePerShare() {
        if (this.getShares() == 0L) {
            return Quote.of(this.getCurrencyCode(), 0L);
        }
        long grossPrice = BigDecimal.valueOf(this.getGrossValueAmount()).movePointRight(Values.Quote.precisionDeltaToMoney()).movePointRight(Values.Share.precision()).divide(BigDecimal.valueOf(this.getShares()), Values.MC).setScale(0, RoundingMode.HALF_EVEN).longValue();
        return Quote.of(this.getCurrencyCode(), grossPrice);
    }

    public Quote getGrossPricePerShare(CurrencyConverter converter) {
        if (this.getShares() == 0L) {
            return Quote.of(converter.getTermCurrency(), 0L);
        }
        if (converter.getTermCurrency().equals(this.getCurrencyCode())) {
            return this.getGrossPricePerShare();
        }
        long grossPrice = BigDecimal.valueOf(this.getGrossValue(converter).getAmount()).movePointRight(Values.Quote.precisionDeltaToMoney()).movePointRight(Values.Share.precision()).divide(BigDecimal.valueOf(this.getShares()), Values.MC).setScale(0, RoundingMode.HALF_EVEN).longValue();
        return Quote.of(converter.getTermCurrency(), grossPrice);
    }

    public String toString() {
        return String.format("%s %-17s %s %9s %s", Values.DateTime.format(this.getDateTime()), this.type.name(), this.getCurrencyCode(), Values.Amount.format(this.getAmount()), this.getSecurity().getName());
    }

    public static enum Type {
        BUY(true),
        SELL(false),
        TRANSFER_IN(true),
        TRANSFER_OUT(false),
        DELIVERY_INBOUND(true),
        DELIVERY_OUTBOUND(false);

        private static final ResourceBundle RESOURCES;
        private final boolean isPurchase;

        static {
            RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.model.labels");
        }

        private Type(boolean isPurchase) {
            this.isPurchase = isPurchase;
        }

        public boolean isPurchase() {
            return this.isPurchase;
        }

        public boolean isLiquidation() {
            return !this.isPurchase;
        }

        public String toString() {
            return RESOURCES.getString("portfolio." + this.name());
        }
    }
}

