/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.time.LocalDateTime;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;

public class PortfolioTransferEntry
implements CrossEntry,
Annotated {
    private Portfolio portfolioFrom;
    private PortfolioTransaction transactionFrom = new PortfolioTransaction();
    private Portfolio portfolioTo;
    private PortfolioTransaction transactionTo;

    public PortfolioTransferEntry() {
        this.transactionFrom.setType(PortfolioTransaction.Type.TRANSFER_OUT);
        this.transactionFrom.setCrossEntry(this);
        this.transactionTo = new PortfolioTransaction();
        this.transactionTo.setType(PortfolioTransaction.Type.TRANSFER_IN);
        this.transactionTo.setCrossEntry(this);
    }

    public PortfolioTransferEntry(Portfolio portfolioFrom, Portfolio portfolioTo) {
        this();
        this.portfolioFrom = portfolioFrom;
        this.portfolioTo = portfolioTo;
    }

    public void setSourceTransaction(PortfolioTransaction transaction) {
        this.transactionFrom = transaction;
    }

    public void setTargetTransaction(PortfolioTransaction transaction) {
        this.transactionTo = transaction;
    }

    public PortfolioTransaction getSourceTransaction() {
        return this.transactionFrom;
    }

    public PortfolioTransaction getTargetTransaction() {
        return this.transactionTo;
    }

    public void setSourcePortfolio(Portfolio portfolio) {
        this.portfolioFrom = portfolio;
    }

    public void setTargetPortfolio(Portfolio portfolio) {
        this.portfolioTo = portfolio;
    }

    public Portfolio getSourcePortfolio() {
        return this.portfolioFrom;
    }

    public Portfolio getTargetPortfolio() {
        return this.portfolioTo;
    }

    public void setDate(LocalDateTime date) {
        this.transactionFrom.setDateTime(date);
        this.transactionTo.setDateTime(date);
    }

    public void setSecurity(Security security) {
        this.transactionFrom.setSecurity(security);
        this.transactionTo.setSecurity(security);
    }

    public void setShares(long shares) {
        this.transactionFrom.setShares(shares);
        this.transactionTo.setShares(shares);
    }

    public void setAmount(long amount) {
        this.transactionFrom.setAmount(amount);
        this.transactionTo.setAmount(amount);
    }

    public void setCurrencyCode(String currencyCode) {
        this.transactionFrom.setCurrencyCode(currencyCode);
        this.transactionTo.setCurrencyCode(currencyCode);
    }

    @Override
    public String getNote() {
        return this.transactionFrom.getNote();
    }

    @Override
    public void setNote(String note) {
        this.transactionFrom.setNote(note);
        this.transactionTo.setNote(note);
    }

    @Override
    public void insert() {
        this.portfolioFrom.addTransaction(this.transactionFrom);
        this.portfolioTo.addTransaction(this.transactionTo);
    }

    @Override
    public void updateFrom(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            this.copyAttributesOver(this.transactionFrom, this.transactionTo);
        } else if (t.equals(this.transactionTo)) {
            this.copyAttributesOver(this.transactionTo, this.transactionFrom);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void copyAttributesOver(PortfolioTransaction source, PortfolioTransaction target) {
        target.setDateTime(source.getDateTime());
        target.setSecurity(source.getSecurity());
        target.setShares(source.getShares());
        target.setNote(source.getNote());
    }

    @Override
    public TransactionOwner<? extends Transaction> getOwner(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            return this.portfolioFrom;
        }
        if (t.equals(this.transactionTo)) {
            return this.portfolioTo;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOwner(Transaction t, TransactionOwner<? extends Transaction> owner) {
        if (!(owner instanceof Portfolio)) {
            throw new IllegalArgumentException();
        }
        if (t.equals(this.transactionFrom) && !this.portfolioTo.equals(owner)) {
            this.portfolioFrom = (Portfolio)owner;
        } else if (t.equals(this.transactionTo) && !this.portfolioFrom.equals(owner)) {
            this.portfolioTo = (Portfolio)owner;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Transaction getCrossTransaction(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            return this.transactionTo;
        }
        if (t.equals(this.transactionTo)) {
            return this.transactionFrom;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionOwner<? extends Transaction> getCrossOwner(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            return this.portfolioTo;
        }
        if (t.equals(this.transactionTo)) {
            return this.portfolioFrom;
        }
        throw new UnsupportedOperationException();
    }
}

