/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.MonetaryOperator;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Quote;

public interface CurrencyConverter {
    public String getTermCurrency();

    default public Money convert(LocalDate date, Money amount) {
        String termCurrency = this.getTermCurrency();
        if (termCurrency.equals(amount.getCurrencyCode())) {
            return amount;
        }
        if (amount.isZero()) {
            return Money.of(termCurrency, 0L);
        }
        ExchangeRate rate = this.getRate(date, amount.getCurrencyCode());
        BigDecimal converted = rate.getValue().multiply(BigDecimal.valueOf(amount.getAmount())).setScale(0, RoundingMode.HALF_DOWN);
        return Money.of(termCurrency, converted.longValue());
    }

    default public Quote convert(LocalDate date, Quote quote) {
        String termCurrency = this.getTermCurrency();
        if (termCurrency.equals(quote.getCurrencyCode())) {
            return quote;
        }
        if (quote.isZero()) {
            return Quote.of(termCurrency, 0L);
        }
        ExchangeRate rate = this.getRate(date, quote.getCurrencyCode());
        BigDecimal converted = rate.getValue().multiply(BigDecimal.valueOf(quote.getAmount())).setScale(0, RoundingMode.HALF_DOWN);
        return Quote.of(termCurrency, converted.longValue());
    }

    default public Money convert(LocalDateTime date, Money amount) {
        return this.convert(date.toLocalDate(), amount);
    }

    default public MonetaryOperator at(LocalDate date) {
        return m -> this.convert(date, (Money)m);
    }

    default public MonetaryOperator at(LocalDateTime date) {
        return m -> this.convert(date.toLocalDate(), (Money)m);
    }

    default public ExchangeRate getRate(LocalDateTime date, String currencyCode) {
        return this.getRate(date.toLocalDate(), currencyCode);
    }

    public ExchangeRate getRate(LocalDate var1, String var2);

    public CurrencyConverter with(String var1);
}

