/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.events.SecurityChangeEvent;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.impl.ChainedExchangeRateTimeSeries;
import name.abuchen.portfolio.money.impl.EmptyExchangeRateTimeSeries;
import name.abuchen.portfolio.money.impl.InverseExchangeRateTimeSeries;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;

public class ExchangeRateProviderFactory {
    private static final List<ExchangeRateProvider> PROVIDERS = new ArrayList<ExchangeRateProvider>();
    private final Client client;
    private final ConcurrentMap<CurrencyPair, ExchangeRateTimeSeries> cache = new ConcurrentHashMap<CurrencyPair, ExchangeRateTimeSeries>();

    static {
        Iterator<ExchangeRateProvider> registeredProvider = ServiceLoader.load(ExchangeRateProvider.class).iterator();
        while (registeredProvider.hasNext()) {
            PROVIDERS.add(registeredProvider.next());
        }
    }

    @Inject
    public ExchangeRateProviderFactory(Client client) {
        this.client = client;
        this.client.addPropertyChangeListener("securities", event -> {
            if (event.getOldValue() != null && ((Security)event.getOldValue()).isExchangeRate() || event.getNewValue() != null && ((Security)event.getNewValue()).isExchangeRate()) {
                this.clearCache();
            }
        });
    }

    @Inject
    @Optional
    public void onSecurityEdited(@EventTopic(value="security/edited") SecurityChangeEvent event) {
        if (event.appliesTo(this.client) && event.getSecurity().isExchangeRate()) {
            this.clearCache();
        }
    }

    public static List<ExchangeRateProvider> getProviders() {
        return new ArrayList<ExchangeRateProvider>(PROVIDERS);
    }

    public List<ExchangeRateTimeSeries> getAvailableTimeSeries() {
        ArrayList<ExchangeRateTimeSeries> series = new ArrayList<ExchangeRateTimeSeries>();
        for (ExchangeRateProvider p : PROVIDERS) {
            series.addAll(p.getAvailableTimeSeries(this.client));
        }
        return series;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ExchangeRateTimeSeries getTimeSeries(String baseCurrency, String termCurrency) {
        return this.cache.computeIfAbsent(new CurrencyPair(baseCurrency, termCurrency), pair -> this.computeTimeSeries(baseCurrency, termCurrency));
    }

    private ExchangeRateTimeSeries computeTimeSeries(String baseCurrency, String termCurrency) {
        Dijkstra dijkstra = new Dijkstra(this.getAvailableTimeSeries(), baseCurrency);
        List<ExchangeRateTimeSeries> answer = dijkstra.findShortestPath(termCurrency);
        if (answer.isEmpty()) {
            PortfolioLog.warning(MessageFormat.format(Messages.MsgNoExchangeRateAvailableForConversion, baseCurrency, termCurrency));
            return new EmptyExchangeRateTimeSeries(baseCurrency, termCurrency);
        }
        if (answer.size() == 1) {
            return answer.get(0);
        }
        return new ChainedExchangeRateTimeSeries(answer.toArray(new ExchangeRateTimeSeries[0]));
    }

    private static class CurrencyPair {
        private final String base;
        private final String term;

        public CurrencyPair(String base, String term) {
            this.base = base;
            this.term = term;
        }

        public int hashCode() {
            return Objects.hash(this.base, this.term);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CurrencyPair other = (CurrencyPair)obj;
            if (!Objects.equals(this.base, other.base)) {
                return false;
            }
            return Objects.equals(this.term, other.term);
        }
    }

    private static class Dijkstra {
        private List<ExchangeRateTimeSeries> timeSeries = new ArrayList<ExchangeRateTimeSeries>();
        private Set<String> visited = new HashSet<String>();
        private Set<String> unvisited = new HashSet<String>();
        private Map<String, ExchangeRateTimeSeries> predecessors = new HashMap<String, ExchangeRateTimeSeries>();
        private Map<String, Integer> distance = new HashMap<String, Integer>();

        /*
         * Unable to fully structure code
         */
        public Dijkstra(List<ExchangeRateTimeSeries> availableTimeSeries, String baseCurrency) {
            super();
            availableTimeSeries.stream().forEach((Consumer<ExchangeRateTimeSeries>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(name.abuchen.portfolio.money.ExchangeRateTimeSeries ), (Lname/abuchen/portfolio/money/ExchangeRateTimeSeries;)V)((Dijkstra)this));
            this.distance.put(baseCurrency, 0);
            this.unvisited = CurrencyUnit.getAvailableCurrencyUnits().stream().map((Function<CurrencyUnit, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getCurrencyCode(), (Lname/abuchen/portfolio/money/CurrencyUnit;)Ljava/lang/String;)()).collect(Collectors.toSet());
            if (this.unvisited.contains(baseCurrency)) ** GOTO lbl28
            return;
lbl-1000:
            // 1 sources

            {
                node = this.getNodeWithMinimumDistance(this.unvisited);
                this.unvisited.remove(node);
                this.visited.add(node);
                if (this.getDistance(node) == 0x7FFFFFFF) continue;
                for (ExchangeRateTimeSeries neighbor : this.getNeighbors(node)) {
                    neighborNode = neighbor.getTermCurrency();
                    alternativeDistance = this.getDistance(node) + neighbor.getWeight();
                    if (alternativeDistance >= this.getDistance(neighborNode)) continue;
                    this.distance.put(neighborNode, alternativeDistance);
                    this.predecessors.put(neighborNode, neighbor);
                }
lbl28:
                // 3 sources

                ** while (!this.unvisited.isEmpty())
            }
lbl29:
            // 1 sources

        }

        public List<ExchangeRateTimeSeries> findShortestPath(String termCurrency) {
            ExchangeRateTimeSeries current = this.predecessors.get(termCurrency);
            if (current == null) {
                return Collections.emptyList();
            }
            LinkedList<ExchangeRateTimeSeries> answer = new LinkedList<ExchangeRateTimeSeries>();
            while (current != null) {
                answer.addFirst(current);
                current = this.predecessors.get(current.getBaseCurrency());
            }
            return answer;
        }

        private List<ExchangeRateTimeSeries> getNeighbors(String node) {
            return this.timeSeries.stream().filter(ts -> ts.getBaseCurrency().equals(node) && !this.visited.contains(ts.getTermCurrency())).collect(Collectors.toList());
        }

        private String getNodeWithMinimumDistance(Set<String> currencies) {
            return currencies.stream().min(Comparator.comparingInt(this::getDistance)).orElse(currencies.iterator().next());
        }

        private int getDistance(String currency) {
            Integer d = this.distance.get(currency);
            return d == null ? Integer.MAX_VALUE : d;
        }

        private /* synthetic */ void lambda$0(ExchangeRateTimeSeries ts) {
            this.timeSeries.add(ts);
            this.timeSeries.add(new InverseExchangeRateTimeSeries(ts));
        }
    }
}

